/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJGrip;
import com.mathworks.mwswing.NarrowBevelBorder;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDocumentsFrame;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroupFrame;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTSingleClientFrame;
import com.mathworks.widgets.desk.DTTabbedPane;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.DTToolBarContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

class DTBorderFactory {
    private static Border sFrameBorder;
    private static Border sBrandedFrameBorder;
    private static Border sDockedFrameBorder;
    private static Border sBrandedDockedFrameBorder;
    private static Border sMenuBarBorder;
    private static Border sToolBarBorder;
    private static Border sToolBarContainerBorder;
    private static Border sTopSeparatorBorder;
    private static Border sBottomSeparatorBorder;
    private static Border sConditionalBottomSeparatorBorder;
    private static int XP_LEFT;
    private static int XP_TOP;
    private static int XP_RIGHT;
    private static int XP_BOTTOM;
    private static Color MAC_ACTIVE_BORDER_COLOR;
    private static Color MAC_INACTIVE_BORDER_COLOR;
    private static Color BRANDED_ACTIVE_BORDER_COLOR;
    private static Color BRANDED_CONSIDERING_BORDER_COLOR;
    private static Color[][] XP_ACTIVE_BLUE_BORDER;
    private static Color[][] XP_INACTIVE_BLUE_BORDER;
    private static Color[][] XP_ACTIVE_GREEN_BORDER;
    private static Color[][] XP_INACTIVE_GREEN_BORDER;
    private static Color[][] XP_ACTIVE_SILVER_BORDER;
    private static Color[][] XP_INACTIVE_SILVER_BORDER;

    DTBorderFactory() {
    }

    static Border createFrameBorder(boolean bl) {
        if (bl) {
            if (sBrandedFrameBorder == null) {
                sBrandedFrameBorder = new BrandedFrameBorder();
            }
            return sBrandedFrameBorder;
        }
        if (sFrameBorder == null) {
            sFrameBorder = PlatformInfo.isWindowsXPAppearance() ? new XPFrameBorder() : (PlatformInfo.isWindowsVistaAppearance() ? new XPFrameBorder() : (PlatformInfo.isMacintosh() ? new MacFrameBorder() : new BasicFrameBorder()));
        }
        return sFrameBorder;
    }

    static Border createDockedFrameBorder(boolean bl) {
        if (bl) {
            if (sBrandedDockedFrameBorder == null) {
                sBrandedDockedFrameBorder = new DockedFrameBorder(true);
            }
            return sBrandedDockedFrameBorder;
        }
        if (sDockedFrameBorder == null) {
            sDockedFrameBorder = new DockedFrameBorder(false);
        }
        return sDockedFrameBorder;
    }

    static Border createMenuBarBorder() {
        if (sMenuBarBorder == null) {
            sMenuBarBorder = DTBorderFactory.createConditionalBottomSeparatorBorder();
        }
        return sMenuBarBorder;
    }

    static Border createToolBarBorder() {
        if (sToolBarBorder == null) {
            sToolBarBorder = new BasicToolBarBorder();
        }
        return sToolBarBorder;
    }

    static Border createToolBarContainerBorder() {
        if (sToolBarContainerBorder == null) {
            sToolBarContainerBorder = new ToolBarContainerBorder();
        }
        return sToolBarContainerBorder;
    }

    static Border createTopSeparatorBorder() {
        if (sTopSeparatorBorder == null) {
            sTopSeparatorBorder = new TopSeparatorBorder();
        }
        return sTopSeparatorBorder;
    }

    static Border createBottomSeparatorBorder() {
        if (sBottomSeparatorBorder == null) {
            sBottomSeparatorBorder = new BottomSeparatorBorder();
        }
        return sBottomSeparatorBorder;
    }

    static Border createConditionalBottomSeparatorBorder() {
        if (sConditionalBottomSeparatorBorder == null) {
            sConditionalBottomSeparatorBorder = new ConditionalBottomSeparatorBorder();
        }
        return sConditionalBottomSeparatorBorder;
    }

    private static boolean isFrameSelected(Component component) {
        while (component != null) {
            if (component instanceof DTSelectable) {
                return ((DTSelectable)((Object)component)).isSelected();
            }
            component = component.getParent();
        }
        return true;
    }

    private static boolean isFrameConsideringSelection(Component component) {
        while (component != null) {
            if (component instanceof DTSelectable) {
                return ((DTSelectable)((Object)component)).isConsideringSelection();
            }
            component = component.getParent();
        }
        return false;
    }

    static {
        XP_LEFT = 0;
        XP_TOP = 1;
        XP_RIGHT = 2;
        XP_BOTTOM = 2;
        MAC_ACTIVE_BORDER_COLOR = new Color(165, 174, 189);
        MAC_INACTIVE_BORDER_COLOR = new Color(190, 200, 210);
        BRANDED_ACTIVE_BORDER_COLOR = new Color(17, 74, 135);
        BRANDED_CONSIDERING_BORDER_COLOR = new Color(69, 106, 141);
        XP_ACTIVE_BLUE_BORDER = new Color[][]{{new Color(0, 25, 207), new Color(0, 59, 226), new Color(22, 106, 238), new Color(8, 85, 221)}, {new Color(0, 89, 232), new Color(61, 149, 255), new Color(43, 144, 255), new Color(1, 108, 254)}, {new Color(0, 19, 140), new Color(0, 30, 160), new Color(0, 61, 220), new Color(0, 72, 241)}};
        XP_INACTIVE_BLUE_BORDER = new Color[][]{{new Color(91, 104, 205), new Color(118, 127, 216), new Color(117, 140, 221), new Color(117, 140, 220)}, {new Color(104, 141, 224), new Color(152, 178, 232), new Color(157, 185, 235), new Color(139, 176, 233)}, {new Color(79, 83, 188), new Color(109, 116, 205), new Color(117, 135, 221), new Color(117, 134, 220)}};
        XP_ACTIVE_GREEN_BORDER = new Color[][]{{new Color(171, 141, 94), new Color(139, 161, 105), new Color(171, 189, 133), new Color(164, 178, 127)}, {new Color(139, 161, 105), new Color(234, 245, 201), new Color(224, 231, 184), new Color(191, 203, 146)}, {new Color(94, 118, 79), new Color(137, 155, 109), new Color(186, 200, 145), new Color(203, 215, 152)}};
        XP_INACTIVE_GREEN_BORDER = new Color[][]{{new Color(200, 208, 183), new Color(208, 214, 189), new Color(224, 226, 200), new Color(214, 216, 190)}, {new Color(214, 216, 187), new Color(241, 241, 218), new Color(237, 239, 211), new Color(223, 224, 194)}, {new Color(183, 189, 171), new Color(190, 195, 175), new Color(215, 219, 193), new Color(221, 226, 197)}};
        XP_ACTIVE_SILVER_BORDER = new Color[][]{{new Color(102, 102, 126), new Color(251, 252, 253), new Color(168, 169, 187), new Color(102, 102, 126)}, {new Color(102, 102, 126), new Color(168, 167, 191), new Color(255, 255, 255), new Color(215, 216, 226)}, {new Color(102, 102, 126), new Color(251, 252, 253), new Color(168, 169, 187), new Color(102, 102, 126)}};
        XP_INACTIVE_SILVER_BORDER = new Color[][]{{new Color(201, 201, 215), new Color(253, 255, 252), new Color(234, 237, 245), new Color(201, 201, 215)}, {new Color(186, 186, 197), new Color(236, 238, 245), new Color(255, 255, 255), new Color(236, 238, 245)}, {new Color(201, 201, 215), new Color(251, 252, 253), new Color(234, 237, 245), new Color(201, 201, 215)}};
    }

    static class BackgroundBorder
    extends AbstractBorder {
        Insets fInsets;

        BackgroundBorder(int n, int n2, int n3, int n4) {
            this.fInsets = new Insets(n, n2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(this.fInsets.top, this.fInsets.left, this.fInsets.bottom, this.fInsets.right);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = this.fInsets.top;
            insets.left = this.fInsets.left;
            insets.bottom = this.fInsets.bottom;
            insets.right = this.fInsets.right;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("control"));
            Area area = new Area(new Rectangle(n, n2, n3, n4));
            area.subtract(new Area(new Rectangle(n + this.fInsets.left, n2 + this.fInsets.top, n3 - this.fInsets.left - this.fInsets.right, n4 - this.fInsets.top - this.fInsets.bottom)));
            Graphics2D graphics2D = (Graphics2D)graphics;
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(area);
            graphics.fillRect(n, n2, n3, n4);
            graphics2D.setClip(shape);
            graphics.setColor(color);
        }
    }

    static class ToolBarContainerBorder
    extends AbstractBorder {
        ToolBarContainerBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = insets.right;
            insets.top = this.needTopHighlight(component) ? 1 : 0;
            insets.bottom = this.needBottomSeparator(component) ? 2 : 0;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color;
            if (this.needTopHighlight(component)) {
                color = graphics.getColor();
                graphics.setColor(UIManager.getColor("controlLtHighlight"));
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.setColor(color);
            }
            if (this.needBottomSeparator(component)) {
                color = graphics.getColor();
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                graphics.setColor(UIManager.getColor("controlLtHighlight"));
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.setColor(color);
            }
        }

        private boolean needTopHighlight(Component component) {
            if (!((DTToolBarContainer)((Object)component)).isAnyToolBarVisible()) {
                return false;
            }
            DTFrame dTFrame = (DTFrame)((Object)SwingUtilities.getAncestorOfClass(DTFrame.class, component));
            return dTFrame != null && dTFrame.usingToolstrip();
        }

        private boolean needBottomSeparator(Component component) {
            PropertyChangeListener propertyChangeListener;
            if (!((DTToolBarContainer)((Object)component)).isAnyToolBarVisible()) {
                return false;
            }
            DTClient dTClient = null;
            DTInternalFrame dTInternalFrame = (DTInternalFrame)((Object)SwingUtilities.getAncestorOfClass(DTInternalFrame.class, component));
            if (dTInternalFrame instanceof DTClientFrame) {
                dTClient = ((DTClientFrame)dTInternalFrame).getClient();
            } else if (dTInternalFrame != null) {
                propertyChangeListener = null;
                if (dTInternalFrame instanceof DTGroupFrame) {
                    propertyChangeListener = ((DTGroupFrame)dTInternalFrame).getDocumentContainer();
                } else if (dTInternalFrame instanceof DTDocumentsFrame) {
                    propertyChangeListener = ((DTDocumentsFrame)dTInternalFrame).getDocumentContainer();
                }
                if (propertyChangeListener != null && ((DTDocumentContainer)propertyChangeListener).getArrangement() == 1) {
                    dTClient = ((DTDocumentContainer)propertyChangeListener).getMaximizedDocument();
                }
            }
            if (dTClient != null && dTClient.wantsTopSeparator()) {
                return true;
            }
            propertyChangeListener = (DTMultipleClientFrame)((Object)SwingUtilities.getAncestorOfClass(DTMultipleClientFrame.class, component));
            if (propertyChangeListener != null && ((DTMultipleClientFrame)propertyChangeListener).isMainFrame()) {
                DTContainer dTContainer = ((DTMultipleClientFrame)propertyChangeListener).getNestChild();
                if (dTContainer instanceof DTGroupFrame) {
                    return true;
                }
                if (dTContainer instanceof DTInternalFrame) {
                    return ((DTInternalFrame)dTContainer).isAnyToolBarVisible();
                }
            }
            return false;
        }
    }

    static class BasicToolBarBorder
    extends AbstractBorder {
        static final String SEPARATOR_PROPERTY_KEY = "ToolBarBorderSeparatorKey";
        static final String GRIP_PROPERTY_KEY = "ToolBarBorderGripKey";
        static final int GRIP_WIDTH = 5;
        static final int GRIP_SIDE_MARGIN = 2;
        static final int GRIP_TOP_MARGIN = 3;
        static final int RIGHT_MARGIN = 0;

        BasicToolBarBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 0;
            insets.bottom = 0;
            insets.top = 0;
            insets.left = 0;
            if (BasicToolBarBorder.wantSeparator(component)) {
                insets.top = 2;
            }
            if (BasicToolBarBorder.wantGrip(component)) {
                insets.left = 10;
            }
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (BasicToolBarBorder.wantSeparator(component)) {
                Color color = graphics.getColor();
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.setColor(UIManager.getColor("controlLtHighlight"));
                graphics.drawLine(n, n2 + 1, n + n3 - 1, n2 + 1);
                graphics.setColor(color);
            }
            if (BasicToolBarBorder.wantGrip(component)) {
                MJGrip.paint((Graphics)graphics, (int)(n + 2 + 1), (int)(n2 + 3), (int)5, (int)(n4 - 6));
            }
        }

        static boolean wantSeparator(Component component) {
            if (component instanceof JComponent) {
                Boolean bl = (Boolean)((JComponent)component).getClientProperty(SEPARATOR_PROPERTY_KEY);
                return bl != null && bl != false;
            }
            return false;
        }

        static boolean wantGrip(Component component) {
            if (component instanceof JComponent) {
                Boolean bl = (Boolean)((JComponent)component).getClientProperty(GRIP_PROPERTY_KEY);
                return bl != null && bl != false;
            }
            return false;
        }

        static void setWantSeparator(JComponent jComponent, boolean bl) {
            jComponent.putClientProperty(SEPARATOR_PROPERTY_KEY, bl);
        }

        static void setWantGrip(JComponent jComponent, boolean bl) {
            jComponent.putClientProperty(GRIP_PROPERTY_KEY, bl);
        }
    }

    static class ConditionalBottomSeparatorBorder
    extends AbstractBorder {
        ConditionalBottomSeparatorBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            insets.bottom = this.needSeparator(component) ? 2 : 0;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.needSeparator(component)) {
                Color color = graphics.getColor();
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                graphics.setColor(UIManager.getColor("controlLtHighlight"));
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.setColor(color);
            }
        }

        private boolean needSeparator(Component component) {
            Window window = SwingUtilities.windowForComponent(component);
            if (!(window instanceof DTSingleClientFrame)) {
                return true;
            }
            DTSingleClientFrame dTSingleClientFrame = (DTSingleClientFrame)((Object)window);
            DTClient dTClient = dTSingleClientFrame.getClient();
            return dTClient == null || dTClient.wantsTopSeparator() || dTSingleClientFrame.getToolBarContainer().isAnyToolBarVisible();
        }
    }

    static class BottomSeparatorBorder
    extends AbstractBorder {
        BottomSeparatorBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 2;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(n, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
            graphics.setColor(UIManager.getColor("controlLtHighlight"));
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(color);
        }
    }

    static class TopSeparatorBorder
    extends AbstractBorder {
        TopSeparatorBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 0;
            insets.right = 0;
            insets.left = 0;
            if (this.needSeparator(component)) {
                insets.top = 2;
            }
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.needSeparator(component)) {
                Color color = graphics.getColor();
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.setColor(UIManager.getColor("controlLtHighlight"));
                graphics.drawLine(n, n2 + 1, n + n3 - 1, n2 + 1);
                graphics.setColor(color);
            }
        }

        protected boolean needSeparator(Component component) {
            return true;
        }
    }

    static class DockedFrameBorder
    extends AbstractBorder
    implements SelectionDependent {
        private final boolean fBranded;
        static Border sOuterBorder;

        DockedFrameBorder(boolean bl) {
            this.fBranded = bl;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 2;
            insets.top = 2;
            insets.right = 2;
            insets.left = 2;
            if (PlatformInfo.isWindowsClassicAppearance() && !(component.getParent() instanceof DTTabbedPane)) {
                sOuterBorder = DockedFrameBorder.createOuterBorder();
                Insets insets2 = sOuterBorder.getBorderInsets(component);
                insets.left += insets2.left;
                insets.right += insets2.right;
                insets.top += insets2.top;
                insets.bottom += insets2.bottom;
            }
            return insets;
        }

        static Color getLineColor(boolean bl, boolean bl2, boolean bl3) {
            if (bl3 && bl) {
                return BRANDED_ACTIVE_BORDER_COLOR;
            }
            if (bl3 && bl2) {
                return BRANDED_CONSIDERING_BORDER_COLOR;
            }
            return PlatformInfo.isMacintosh() ? (bl ? MAC_ACTIVE_BORDER_COLOR : MAC_INACTIVE_BORDER_COLOR) : DTTitleBar.InternalUI.getBottomColor(bl);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = DTBorderFactory.isFrameSelected(component);
            Color color = graphics.getColor();
            Color color2 = DockedFrameBorder.getLineColor(bl, DTBorderFactory.isFrameConsideringSelection(component), this.fBranded);
            Rectangle rectangle = new Rectangle(n, n2, n3 - 1, n4 - 1);
            boolean bl2 = component.getParent() instanceof DTTabbedPane;
            if (PlatformInfo.isWindowsClassicAppearance() && !bl2) {
                sOuterBorder = DockedFrameBorder.createOuterBorder();
                sOuterBorder.paintBorder(component, graphics, n, n2, n3, n4);
                Insets insets = sOuterBorder.getBorderInsets(component);
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
                if (!bl) {
                    return;
                }
            }
            if (bl || !PlatformInfo.isWindowsClassicAppearance()) {
                graphics.setColor(color2);
                if (bl || bl2) {
                    // empty if block
                }
                graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
                if (bl || bl2) {
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
            graphics.setColor(color);
        }

        static Border createOuterBorder() {
            if (sOuterBorder == null) {
                sOuterBorder = BorderFactory.createCompoundBorder((Border)new NarrowBevelBorder(1), (Border)new NarrowBevelBorder(0));
            }
            return sOuterBorder;
        }
    }

    static class BrandedFrameBorder
    extends AbstractBorder
    implements SelectionDependent {
        BrandedFrameBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 4;
            insets.top = 4;
            insets.right = 4;
            insets.left = 4;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(DTBorderFactory.isFrameSelected(component) ? ColorUtils.fade((Color)BRANDED_ACTIVE_BORDER_COLOR) : UIManager.getColor("control"));
            int n5 = 0;
            while (n5 < 4) {
                if (n5 > 0) {
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                }
                ++n5;
                ++n;
                ++n2;
                n3 -= 2;
                n4 -= 2;
            }
            graphics.setColor(color);
        }
    }

    static class MacFrameBorder
    extends AbstractBorder {
        MacFrameBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 2;
            insets.top = 2;
            insets.right = 2;
            insets.left = 2;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("control"));
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
            graphics.setColor(color);
        }
    }

    static class XPFrameBorder
    extends AbstractBorder
    implements SelectionDependent {
        XPFrameBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 4;
            insets.top = 4;
            insets.right = 4;
            insets.left = 4;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n + n3 - 1;
            int n6 = n2 + n4 - 1;
            Color[][] colorArray = XP_INACTIVE_BLUE_BORDER;
            switch (PlatformInfo.getWindowsColorScheme()) {
                case 0: {
                    colorArray = DTBorderFactory.isFrameSelected(component) ? XP_ACTIVE_BLUE_BORDER : XP_INACTIVE_BLUE_BORDER;
                    break;
                }
                case 1: {
                    colorArray = DTBorderFactory.isFrameSelected(component) ? XP_ACTIVE_GREEN_BORDER : XP_INACTIVE_GREEN_BORDER;
                    break;
                }
                case 2: {
                    colorArray = DTBorderFactory.isFrameSelected(component) ? XP_ACTIVE_SILVER_BORDER : XP_INACTIVE_SILVER_BORDER;
                }
            }
            int n7 = 0;
            while (n7 < 4) {
                graphics.setColor(colorArray[XP_LEFT][n7]);
                graphics.drawLine(n, n2 + 1, n, n6);
                graphics.setColor(colorArray[XP_BOTTOM][n7]);
                graphics.drawLine(n + 1, n6, n5, n6);
                graphics.setColor(colorArray[XP_RIGHT][n7]);
                graphics.drawLine(n5, n6 - 1, n5, n2);
                graphics.setColor(colorArray[XP_TOP][n7]);
                graphics.drawLine(n, n2, n5 - 1, n2);
                ++n7;
                ++n;
                ++n2;
                --n5;
                --n6;
            }
            graphics.setColor(color);
        }
    }

    static class BasicFrameBorder
    extends AbstractBorder {
        BasicFrameBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 4;
            insets.top = 4;
            insets.right = 4;
            insets.left = 4;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n + n3 - 1;
            int n6 = n2 + n4 - 1;
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawLine(n, n2, n5 - 1, n2);
            graphics.drawLine(n, n2, n, n6 - 1);
            graphics.setColor(UIManager.getColor("controlLtHighlight"));
            graphics.drawLine(n + 1, n2 + 1, n5 - 2, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n6 - 2);
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawLine(n, n6, n5, n6);
            graphics.drawLine(n5, n2, n5, n6);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(n + 1, n6 - 1, n5 - 1, n6 - 1);
            graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n6 - 1);
            graphics.setColor(UIManager.getColor("control"));
            graphics.drawRect(n + 2, n2 + 2, n3 - 5, n4 - 5);
            graphics.drawRect(n + 3, n2 + 3, n3 - 7, n4 - 7);
            graphics.setColor(color);
        }
    }

    static interface SelectionDependent {
    }
}

