/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.widgets.desk.DTLocation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.zip.DataFormatException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DTFloatingLocation
extends DTLocation {
    private int fZ = Integer.MIN_VALUE;
    private int fRestoreX = Integer.MIN_VALUE;
    private int fRestoreY = Integer.MIN_VALUE;
    private int fRestoreWidth = Integer.MIN_VALUE;
    private int fRestoreHeight = Integer.MIN_VALUE;
    private float fNormalizedX = -2.1474836E9f;
    private float fNormalizedY = -2.1474836E9f;
    private float fNormalizedWidth = -2.1474836E9f;
    private float fNormalizedHeight = -2.1474836E9f;
    private boolean fIsExternal;
    private boolean fIsMaximized;
    private boolean fIsMinimized;
    private boolean fIsEntirelyVisible;
    private static final int MARGIN = 10;
    private static final String Z_ATTRIBUTE = "Z";
    private static final String MAXIMIZED_ATTRIBUTE = "Maximized";
    private static final String MINIMIZED_ATTRIBUTE = "Minimized";
    private static final String EXTERNAL_ATTRIBUTE = "External";
    private static final String ENTIRELY_VISIBLE_ATTRIBUTE = "EntirelyVisible";
    private static final String YES_VALUE = "yes";

    DTFloatingLocation(boolean bl) {
        this.fIsExternal = bl;
    }

    DTFloatingLocation(int n, int n2, boolean bl) {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, n, n2, bl);
    }

    DTFloatingLocation(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.fX = n;
        this.fY = n2;
        this.fZ = n3;
        this.fWidth = n4;
        this.fHeight = n5;
        this.fIsExternal = bl;
    }

    DTFloatingLocation(float f, float f2, float f3, float f4, boolean bl) {
        this.fNormalizedX = f;
        this.fNormalizedY = f2;
        this.fNormalizedWidth = f3;
        this.fNormalizedHeight = f4;
        this.fIsExternal = bl;
    }

    DTFloatingLocation(float f, float f2, boolean bl) {
        this(-2.1474836E9f, -2.1474836E9f, f, f2, bl);
    }

    DTFloatingLocation(DTFloatingLocation dTFloatingLocation) {
        super(dTFloatingLocation);
        this.fZ = dTFloatingLocation.fZ;
        this.fRestoreX = dTFloatingLocation.fRestoreX;
        this.fRestoreY = dTFloatingLocation.fRestoreY;
        this.fRestoreWidth = dTFloatingLocation.fRestoreWidth;
        this.fRestoreHeight = dTFloatingLocation.fRestoreHeight;
        this.fNormalizedX = dTFloatingLocation.fNormalizedX;
        this.fNormalizedY = dTFloatingLocation.fNormalizedY;
        this.fNormalizedWidth = dTFloatingLocation.fNormalizedWidth;
        this.fNormalizedHeight = dTFloatingLocation.fNormalizedHeight;
        this.fIsExternal = dTFloatingLocation.fIsExternal;
        this.fIsMaximized = dTFloatingLocation.fIsMaximized;
        this.fIsMinimized = dTFloatingLocation.fIsMinimized;
        this.fIsEntirelyVisible = dTFloatingLocation.fIsEntirelyVisible;
    }

    public int getFrameZ() {
        return this.fZ;
    }

    public int getRestoreX() {
        return this.fRestoreX;
    }

    public int getRestoreY() {
        return this.fRestoreY;
    }

    public int getRestoreWidth() {
        return this.fRestoreWidth;
    }

    public int getRestoreHeight() {
        return this.fRestoreHeight;
    }

    public Rectangle getRestoreBounds() {
        return new Rectangle(this.fRestoreX, this.fRestoreY, this.fRestoreWidth, this.fRestoreHeight);
    }

    @Override
    public boolean isExternal() {
        return this.fIsExternal;
    }

    @Override
    public boolean isMaximized() {
        return this.fIsMaximized;
    }

    @Override
    public boolean isMinimized() {
        return this.fIsMinimized;
    }

    boolean hasNormalizedLocation() {
        return this.fNormalizedX >= 0.0f && this.fNormalizedY >= 0.0f;
    }

    boolean hasNormalizedSize() {
        return this.fNormalizedWidth >= 0.0f && this.fNormalizedHeight >= 0.0f;
    }

    void initializeLocation(Dimension dimension) {
        this.initializeLocation(new Rectangle(0, 0, dimension.width, dimension.height));
    }

    void initializeLocation(Rectangle rectangle) {
        if (this.fNormalizedX > 0.0f) {
            this.fX = rectangle.x + (int)(this.fNormalizedX * (float)rectangle.width);
        }
        if (this.fNormalizedY > 0.0f) {
            this.fY = rectangle.y + (int)(this.fNormalizedY * (float)rectangle.height);
        }
    }

    void initializeSize(Dimension dimension) {
        if (this.fNormalizedWidth > 0.0f) {
            this.fWidth = (int)(this.fNormalizedWidth * (float)dimension.width);
        }
        if (this.fNormalizedHeight > 0.0f) {
            this.fHeight = (int)(this.fNormalizedHeight * (float)dimension.height);
        }
    }

    void setMaximized(boolean bl) {
        if (this.fIsMaximized == bl) {
            return;
        }
        this.fIsMaximized = bl;
        if (bl) {
            if (!this.fIsMinimized) {
                this.fRestoreX = this.fX;
                this.fRestoreY = this.fY;
                this.fRestoreWidth = this.fWidth;
                this.fRestoreHeight = this.fHeight;
            }
            this.fIsMinimized = false;
        }
        this.fireChangeEvent();
    }

    void setMinimized(boolean bl) {
        if (bl != this.fIsMinimized) {
            this.fIsMinimized = bl;
            if (bl) {
                this.setMaximized(false);
            }
            this.fireChangeEvent();
        }
    }

    void ensureVisible(Dimension dimension) {
        this.ensureVisible(new Rectangle(0, 0, dimension.width, dimension.height));
    }

    void ensureVisible(Rectangle rectangle) {
        Point point = this.getFrameLocation();
        Dimension dimension = this.getFrameSize();
        if (this.fIsEntirelyVisible) {
            int n = 0;
            if (dimension.width > rectangle.width) {
                this.fWidth = dimension.width = rectangle.width - 20;
                n = 10;
            }
            if (dimension.height > rectangle.height) {
                this.fHeight = dimension.height = rectangle.height - 20;
                n = 10;
            }
            point = WindowUtils.ensureOnScreen((Rectangle)rectangle, (Point)point, (Dimension)dimension, (int)n);
        } else {
            point = WindowUtils.ensureTitleInBounds((Rectangle)rectangle, (Point)this.getFrameLocation(), (Dimension)this.getFrameSize(), null);
        }
        this.fX = point.x;
        this.fY = point.y;
    }

    void recordVisibility(Rectangle rectangle) {
        this.fIsEntirelyVisible = rectangle.contains(this.getFrameBounds());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(this.fIsExternal ? "Top-level frame at " : "Internal frame at ");
        stringBuffer.append("x = ");
        stringBuffer.append(this.fX);
        stringBuffer.append(", y = ");
        stringBuffer.append(this.fY);
        stringBuffer.append(", w = ");
        stringBuffer.append(this.fWidth);
        stringBuffer.append(", h = ");
        stringBuffer.append(this.fHeight);
        if (this.fIsMaximized) {
            stringBuffer.append(", Maximized: Restore bounds = ");
            stringBuffer.append("x = ");
            stringBuffer.append(this.fRestoreX);
            stringBuffer.append(", y = ");
            stringBuffer.append(this.fRestoreY);
            stringBuffer.append(", w = ");
            stringBuffer.append(this.fRestoreWidth);
            stringBuffer.append(", h = ");
            stringBuffer.append(this.fRestoreHeight);
        }
        if (this.fIsMinimized) {
            stringBuffer.append(", Maximized");
        }
        if (!this.fIsExternal) {
            stringBuffer.append(", z-order = ");
            stringBuffer.append(this.fZ);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DTFloatingLocation && super.equals(object)) {
            DTFloatingLocation dTFloatingLocation = (DTFloatingLocation)object;
            return this.fX == dTFloatingLocation.fX && this.fY == dTFloatingLocation.fY && this.fZ == dTFloatingLocation.fZ && this.fWidth == dTFloatingLocation.fWidth && this.fHeight == dTFloatingLocation.fHeight && this.fIsExternal == dTFloatingLocation.fIsExternal && this.fIsMaximized == dTFloatingLocation.fIsMaximized && this.fIsMinimized == dTFloatingLocation.fIsMinimized;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.fX;
        n = 37 * n + this.fY;
        n = 37 * n + this.fZ;
        n = 37 * n + this.fWidth;
        n = 37 * n + this.fHeight;
        n = 37 * n + (this.fIsExternal ? 1 : 0);
        n = 37 * n + (this.fIsMaximized ? 1 : 0);
        n = 37 * n + (this.fIsMinimized ? 1 : 0);
        return n;
    }

    @Override
    public Element toXML(Document document) {
        int n;
        int n2;
        int n3;
        int n4;
        Element element = super.toXML(document);
        element.setAttribute("Type", "floating");
        if (this.fIsMaximized) {
            n4 = this.fRestoreX;
            n3 = this.fRestoreY;
            n2 = this.fRestoreWidth;
            n = this.fRestoreHeight;
        } else {
            n4 = this.fX;
            n3 = this.fY;
            n2 = this.fWidth;
            n = this.fHeight;
        }
        if (n4 != Integer.MIN_VALUE) {
            element.setAttribute("X", Integer.toString(n4));
        } else if (this.fNormalizedX != -2.1474836E9f) {
            element.setAttribute("X", Float.toString(this.fNormalizedX));
        }
        if (n3 != Integer.MIN_VALUE) {
            element.setAttribute("Y", Integer.toString(n3));
        } else if (this.fNormalizedY != -2.1474836E9f) {
            element.setAttribute("Y", Float.toString(this.fNormalizedY));
        }
        if (this.fZ != Integer.MIN_VALUE) {
            element.setAttribute(Z_ATTRIBUTE, Integer.toString(this.fZ));
        }
        if (n2 != Integer.MIN_VALUE) {
            element.setAttribute("Width", Integer.toString(n2));
        } else if (this.fNormalizedWidth != -2.1474836E9f) {
            element.setAttribute("Width", Float.toString(this.fNormalizedWidth));
        }
        if (n != Integer.MIN_VALUE) {
            element.setAttribute("Height", Integer.toString(n));
        } else if (this.fNormalizedHeight != -2.1474836E9f) {
            element.setAttribute("Height", Float.toString(this.fNormalizedHeight));
        }
        if (this.fIsMaximized) {
            element.setAttribute(MAXIMIZED_ATTRIBUTE, YES_VALUE);
        }
        if (this.fIsMinimized) {
            element.setAttribute(MINIMIZED_ATTRIBUTE, YES_VALUE);
        }
        if (this.fIsExternal) {
            element.setAttribute(EXTERNAL_ATTRIBUTE, YES_VALUE);
        }
        if (this.fIsEntirelyVisible) {
            element.setAttribute(ENTIRELY_VISIBLE_ATTRIBUTE, YES_VALUE);
        }
        return element;
    }

    DTFloatingLocation(SimpleElement simpleElement) throws DataFormatException {
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        String string = simpleElement.getAttribute("X");
        if (string != null && string.length() > 0) {
            try {
                if (string.indexOf(46) == -1) {
                    n = Integer.parseInt(string);
                    if (n == -1) {
                        n = Integer.MIN_VALUE;
                    }
                } else {
                    this.fNormalizedX = Float.parseFloat(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid X: " + string);
            }
        }
        if ((string = simpleElement.getAttribute("Y")) != null && string.length() > 0) {
            try {
                if (string.indexOf(46) == -1) {
                    n2 = Integer.parseInt(string);
                    if (n2 == -1) {
                        n2 = Integer.MIN_VALUE;
                    }
                } else {
                    this.fNormalizedY = Float.parseFloat(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Y: " + string);
            }
        }
        if ((string = simpleElement.getAttribute(Z_ATTRIBUTE)) != null && string.length() > 0) {
            try {
                this.fZ = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Z: " + string);
            }
        }
        if ((string = simpleElement.getAttribute("Width")) != null && string.length() > 0) {
            try {
                if (string.indexOf(46) == -1) {
                    n3 = Integer.parseInt(string);
                    if (n3 == -1) {
                        n3 = Integer.MIN_VALUE;
                    }
                } else {
                    this.fNormalizedWidth = Float.parseFloat(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Width: " + string);
            }
        }
        if ((string = simpleElement.getAttribute("Height")) != null && string.length() > 0) {
            try {
                if (string.indexOf(46) == -1) {
                    n4 = Integer.parseInt(string);
                    if (n4 == -1) {
                        n4 = Integer.MIN_VALUE;
                    }
                } else {
                    this.fNormalizedHeight = Float.parseFloat(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Height: " + string);
            }
        }
        string = simpleElement.getAttribute(MAXIMIZED_ATTRIBUTE);
        this.fIsMaximized = YES_VALUE.equalsIgnoreCase(string);
        string = simpleElement.getAttribute(MINIMIZED_ATTRIBUTE);
        this.fIsMinimized = YES_VALUE.equalsIgnoreCase(string);
        string = simpleElement.getAttribute(EXTERNAL_ATTRIBUTE);
        this.fIsExternal = YES_VALUE.equalsIgnoreCase(string);
        string = simpleElement.getAttribute(ENTIRELY_VISIBLE_ATTRIBUTE);
        this.fIsEntirelyVisible = YES_VALUE.equalsIgnoreCase(string);
        if (this.fIsMaximized) {
            this.fRestoreX = n;
            this.fRestoreY = n2;
            this.fRestoreWidth = n3;
            this.fRestoreHeight = n4;
        } else {
            this.fX = n;
            this.fY = n2;
            this.fWidth = n3;
            this.fHeight = n4;
        }
    }
}

