/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.editor.breakpoints;

import com.mathworks.matlab.api.debug.Breakpoint;
import com.mathworks.widgets.text.mcode.CmdManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class BreakpointAdjustmentUtils {
    private BreakpointAdjustmentUtils() {
    }

    public static <T extends Breakpoint> List<T> adjustBreakpoints(List<T> list, int n, int n2, CmdManager cmdManager, EventType eventType) {
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)"The line must be greater than or equal to zero.");
        Validate.isTrue((n2 >= 0 ? 1 : 0) != 0, (String)"The line must be greater than or equal to zero.");
        Validate.isTrue((n < n2 ? 1 : 0) != 0, (String)"The first line must be before the last line.");
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        for (Breakpoint breakpoint : list) {
            Breakpoint breakpoint2 = BreakpointAdjustmentUtils.adjustBreakpoint(breakpoint, n, n2, cmdManager, eventType);
            if (breakpoint2 == null) continue;
            arrayList.add(breakpoint2);
        }
        return arrayList;
    }

    private static <T extends Breakpoint> T adjustBreakpoint(T t, int n, int n2, CmdManager cmdManager, EventType eventType) {
        Breakpoint breakpoint = null;
        int n3 = BreakpointAdjustmentUtils.getLineDelta(n, n2, eventType);
        int n4 = t.getZeroBasedLineNumber();
        int n5 = n4 + n3;
        if (BreakpointAdjustmentUtils.shouldAddUnadjustedBreakpoint(n4, n, cmdManager)) {
            breakpoint = t;
        } else if (BreakpointAdjustmentUtils.shouldAddAdjustedBreakpoint(eventType, n4, n5, n, n2, cmdManager)) {
            breakpoint = t.deriveBreakpoint(n5);
        }
        return (T)breakpoint;
    }

    private static int getLineDelta(int n, int n2, EventType eventType) {
        int n3 = n2 - n;
        return eventType == EventType.REMOVE ? -n3 : n3;
    }

    private static boolean shouldAddUnadjustedBreakpoint(int n, int n2, CmdManager cmdManager) {
        boolean bl = cmdManager.isExecutableLine(n);
        boolean bl2 = n < n2;
        boolean bl3 = n2 == n && bl;
        return bl2 || bl3;
    }

    private static boolean shouldAddAdjustedBreakpoint(EventType eventType, int n, int n2, int n3, int n4, CmdManager cmdManager) {
        boolean bl = cmdManager.isExecutableLine(n2);
        boolean bl2 = eventType == EventType.INSERT && n >= n3 && bl;
        boolean bl3 = n >= n4 && bl;
        return bl2 || bl3;
    }

    public static enum EventType {
        INSERT,
        REMOVE;

    }
}

