/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.find;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindClientRegistryListener;
import com.mathworks.widgets.find.LookinItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public final class FindClientRegistry {
    private static final Map<FindClientInterface, RegisteredComponent> sStaticComponents = new HashMap<FindClientInterface, RegisteredComponent>();
    private static final Map<String, RegisteredComponent> sDynamicComponents = new HashMap<String, RegisteredComponent>();
    private static final List<FindClientRegistryListener> sListeners = new ArrayList<FindClientRegistryListener>();

    private FindClientRegistry() {
    }

    public static void register(FindClientInterface findClientInterface, String[] stringArray, boolean bl) {
        FindClientRegistry.register(sStaticComponents, findClientInterface, findClientInterface, stringArray, bl);
    }

    public static void register(String string, FindClientInterface findClientInterface, String[] stringArray, boolean bl) {
        FindClientRegistry.register(sDynamicComponents, string, findClientInterface, stringArray, bl);
    }

    public static void unregister(String string) {
        FindClientRegistry.unregister(sDynamicComponents, string);
    }

    public static void unregister(FindClientInterface findClientInterface) {
        FindClientRegistry.unregister(sStaticComponents, findClientInterface);
    }

    static void clear() {
        FindClientRegistry.clear(sStaticComponents);
        FindClientRegistry.clear(sDynamicComponents);
    }

    static void addListener(final FindClientRegistryListener findClientRegistryListener) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                sListeners.add(findClientRegistryListener);
            }
        });
    }

    static void removeListener(final FindClientRegistryListener findClientRegistryListener) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                sListeners.remove(findClientRegistryListener);
            }
        });
    }

    private static <K> void register(final Map<K, RegisteredComponent> map, final K k, final FindClientInterface findClientInterface, final String[] stringArray, final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RegisteredComponent registeredComponent = new RegisteredComponent(findClientInterface, stringArray, bl);
                map.put(k, registeredComponent);
                FindClientRegistry.fireLookinsChanged(findClientInterface, registeredComponent.getLookins());
            }
        });
    }

    private static <K> void unregister(final Map<K, RegisteredComponent> map, final K k) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RegisteredComponent registeredComponent = (RegisteredComponent)map.remove(k);
                if (registeredComponent != null) {
                    FindClientRegistry.fireLookinsChanged(registeredComponent.getClientInterface(), new ArrayList());
                }
            }
        });
    }

    private static <K> void clear(final Map<K, RegisteredComponent> map) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Object k : new ArrayList(map.keySet())) {
                    FindClientRegistry.unregister(map, k);
                }
            }
        });
    }

    private static void fireLookinsChanged(final FindClientInterface findClientInterface, final List<LookinItem> list) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Collections.sort(list);
                for (FindClientRegistryListener findClientRegistryListener : new ArrayList(sListeners)) {
                    findClientRegistryListener.lookinsChanged(findClientInterface, new ArrayList<LookinItem>(list));
                }
            }
        });
    }

    static List<LookinItem> getLookins(FindClientInterface findClientInterface) {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<LookinItem> arrayList = new ArrayList<LookinItem>();
        for (RegisteredComponent registeredComponent : sStaticComponents.values()) {
            if (registeredComponent.getClientInterface() != findClientInterface) continue;
            arrayList.addAll(registeredComponent.getLookins());
        }
        for (RegisteredComponent registeredComponent : sDynamicComponents.values()) {
            if (registeredComponent.getClientInterface() != findClientInterface) continue;
            arrayList.addAll(registeredComponent.getLookins());
        }
        return arrayList;
    }

    static List<LookinItem> getAllLookins() {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<LookinItem> arrayList = new ArrayList<LookinItem>();
        for (RegisteredComponent registeredComponent : sStaticComponents.values()) {
            arrayList.addAll(registeredComponent.getLookins());
        }
        for (RegisteredComponent registeredComponent : sDynamicComponents.values()) {
            arrayList.addAll(registeredComponent.getLookins());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static class RegisteredComponent {
        private final List<LookinItem> fLookins;
        private final boolean fAllowReplace;
        private final FindClientInterface fClient;

        RegisteredComponent(FindClientInterface findClientInterface, String[] stringArray, boolean bl) {
            assert (stringArray != null);
            this.fClient = findClientInterface;
            this.fLookins = new ArrayList<LookinItem>();
            for (String string : stringArray) {
                this.fLookins.add(new LookinItem(string, findClientInterface, bl));
            }
            this.fAllowReplace = bl;
        }

        public FindClientInterface getClientInterface() {
            return this.fClient;
        }

        public List<LookinItem> getLookins() {
            return new ArrayList<LookinItem>(this.fLookins);
        }

        public boolean isReplaceAllowed() {
            return this.fAllowReplace;
        }
    }
}

