/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.grouptable.GroupingTable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class EditOnClickHandler<T> {
    private final GroupingTable<T> fTable;
    private final MouseListener fMouseListener;
    private final MouseMotionListener fMouseMotionListener;
    private final ListSelectionListener fSelectionListener;
    private final ParameterRunnable<Integer> fStartEditingCode;
    private Timer fTimer;
    private int fSelectedRow;
    private long fSelectionTime;
    private boolean fEnabled;

    public EditOnClickHandler(GroupingTable<T> groupingTable, ParameterRunnable<Integer> parameterRunnable) {
        this.fTable = groupingTable;
        this.fStartEditingCode = parameterRunnable;
        this.fMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                EditOnClickHandler.this.cancelTimer();
            }
        };
        this.fMouseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1 && !MJUtilities.isRightMouseButton((MouseEvent)mouseEvent)) {
                    if (!EditOnClickHandler.this.fEnabled) {
                        return;
                    }
                    final int n = EditOnClickHandler.this.fTable.rowAtPoint(mouseEvent.getPoint());
                    int n2 = EditOnClickHandler.this.fTable.columnAtPoint(mouseEvent.getPoint());
                    if (n > -1 && n2 > -1 && EditOnClickHandler.this.fTable.isRightOfIndentation(mouseEvent.getPoint()) && EditOnClickHandler.this.fSelectedRow == n && EditOnClickHandler.this.fSelectionTime < System.currentTimeMillis() - 300L && EditOnClickHandler.this.fTable.isCellEditable(n, n2)) {
                        int n3 = 500;
                        try {
                            Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
                            n3 = Math.max(500, (int)Long.parseLong(object.toString()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        EditOnClickHandler.this.fTimer = new Timer(n3, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (!EditOnClickHandler.this.fTable.isEditing() || EditOnClickHandler.this.fTable.getEditingRow() != n) {
                                    EditOnClickHandler.this.fStartEditingCode.run((Object)n);
                                }
                                EditOnClickHandler.this.fTimer = null;
                            }
                        });
                        EditOnClickHandler.this.fTimer.setRepeats(false);
                        EditOnClickHandler.this.fTimer.start();
                    }
                } else {
                    EditOnClickHandler.this.cancelTimer();
                }
            }
        };
        this.fSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditOnClickHandler.this.cancelTimer();
                if (EditOnClickHandler.this.fTable.getSelectedRows() != null && EditOnClickHandler.this.fTable.getSelectedRows().length == 1) {
                    EditOnClickHandler.this.fSelectedRow = EditOnClickHandler.this.fTable.getSelectedRow();
                    EditOnClickHandler.this.fSelectionTime = System.currentTimeMillis();
                } else {
                    EditOnClickHandler.this.fSelectedRow = -1;
                }
            }
        };
        this.fTable.getSelectionModel().addListSelectionListener(this.fSelectionListener);
        this.fTable.addMouseListener(this.fMouseListener);
        this.fTable.addMouseMotionListener(this.fMouseMotionListener);
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            Timer timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditOnClickHandler.this.fEnabled = true;
                }
            });
            timer.setRepeats(false);
            timer.start();
        } else {
            this.fEnabled = bl;
        }
        this.cancelTimer();
    }

    public void cancelTimer() {
        if (this.fTimer != null) {
            this.fTimer.stop();
            this.fTimer = null;
        }
    }

    public void destroy() {
        this.fTable.getSelectionModel().removeListSelectionListener(this.fSelectionListener);
        this.fTable.removeMouseListener(this.fMouseListener);
        this.fTable.removeMouseMotionListener(this.fMouseMotionListener);
    }
}

