/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.jidesoft.grid.TreeTable;
import com.mathworks.util.Converter;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTableCellRenderer;
import com.mathworks.widgets.grouptable.GroupingTableEditor;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public final class GroupingTableColumn<T> {
    private final String fName;
    private final String fKey;
    private final Class<?> fType;
    private final boolean fCanHide;
    private final Icon fOriginalHeaderIcon;
    private final Converter<T, ?> fConverter;
    private final GroupingTableEditor<T> fEditor;
    private final Comparator<T> fComparator;
    private final List<GroupingMode<T>> fGroupingModes;
    private Icon fPaddedHeaderIcon;

    public GroupingTableColumn(String string, String string2, boolean bl) {
        this(string, string2, bl, null);
    }

    public GroupingTableColumn(String string, String string2, boolean bl, Converter<T, ?> converter) {
        this(string, string2, bl, converter, null);
    }

    public GroupingTableColumn(String string, String string2, boolean bl, Converter<T, ?> converter, GroupingTableEditor<T> groupingTableEditor) {
        this(string, string2, bl, String.class, null, converter, groupingTableEditor, null, new GroupingMode[0]);
    }

    public GroupingTableColumn(String string, String string2, boolean bl, Class<?> clazz, Icon icon, Converter<T, ?> converter, GroupingTableEditor<T> groupingTableEditor, Comparator<T> comparator, GroupingMode<T> ... groupingModeArray) {
        this.fKey = string;
        this.fName = string2;
        this.fType = clazz;
        this.fOriginalHeaderIcon = icon;
        this.fCanHide = bl;
        this.fGroupingModes = new Vector<GroupingMode<T>>(Arrays.asList(groupingModeArray));
        this.fConverter = converter != null ? converter : new Converter<T, String>(){

            public String convert(T t) {
                return t.toString();
            }
        };
        this.fComparator = comparator != null ? comparator : new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return GroupingTableColumn.this.getValue(t).toString().compareToIgnoreCase(GroupingTableColumn.this.getValue(t2).toString());
            }
        };
        this.fEditor = groupingTableEditor;
    }

    public String getKey() {
        return this.fKey;
    }

    public String getName() {
        return this.fName;
    }

    public Object getValue(T t) {
        return this.fConverter.convert(t);
    }

    public boolean canHide() {
        return this.fCanHide;
    }

    public Class<?> getType() {
        return this.fType;
    }

    public GroupingTableEditor<T> getEditor() {
        return this.fEditor;
    }

    public Comparator<T> getComparator() {
        return this.fComparator;
    }

    public List<GroupingMode<T>> getGroupingModes() {
        return new Vector<GroupingMode<T>>(this.fGroupingModes);
    }

    public GroupingMode<T> getGroupingModeByKey(String string) {
        for (GroupingMode<T> groupingMode : this.fGroupingModes) {
            if (!groupingMode.getKey().equals(string)) continue;
            return groupingMode;
        }
        return null;
    }

    public int hashCode() {
        return this.fKey.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof GroupingTableColumn && this.fKey.equals(((GroupingTableColumn)object).getKey());
    }

    public TableCellRenderer getCellRenderer(boolean bl) {
        return this.getCellRenderer(bl, bl);
    }

    public TableCellRenderer getCellRenderer(boolean bl, boolean bl2) {
        return new GroupingTableCellRenderer(this, bl, bl2);
    }

    public TableCellRenderer getSpecialHeaderRenderer(final TableCellRenderer tableCellRenderer) {
        if (this.fOriginalHeaderIcon != null) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component;
                    if (GroupingTableColumn.this.fPaddedHeaderIcon == null) {
                        GroupingTableColumn.this.fPaddedHeaderIcon = GroupingTableColumn.addPaddingOnLeft(GroupingTableColumn.this.fOriginalHeaderIcon, ((TreeTable)jTable).getIndent());
                    }
                    if ((component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JLabel) {
                        ((JLabel)component).setIcon(GroupingTableColumn.this.fPaddedHeaderIcon);
                        ((JLabel)component).setText("");
                    }
                    return component;
                }
            };
        }
        return null;
    }

    private static Icon addPaddingOnLeft(Icon icon, int n) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth() + n, icon.getIconHeight(), 2);
        icon.paintIcon(null, bufferedImage.getGraphics(), n, 0);
        return new ImageIcon(bufferedImage);
    }
}

