/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.HeaderRenderer;
import com.mathworks.widgets.spreadsheet.ICellQueryInformant;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import com.mathworks.widgets.spreadsheet.IHeaderRendererProvider;
import com.mathworks.widgets.spreadsheet.IRowHeaderPopupMenuSource;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SpreadsheetScrollPane
extends MJScrollPane
implements ICellQueryInformant {
    private HeaderTableModel fRowHeaderModel;
    private IHeaderRenderer fRowHeaderRenderer = null;
    private MJTable fRowHeaderTable;
    private HeaderRenderer fTopLeftRenderer;
    private MJPopupMenu fPopupMenu;
    private int fPreviousRequiredWidth = -1;
    private PropertyChangeListener fRowHeightListener;
    private ListSelectionListener fSelListener;
    private FocusListener fFocusReassigner;
    private MouseListener fAutoGrowthMouseListener;
    private MouseListener fRowHeaderMEL;
    private MouseListener fTopLeftMEL;
    private TableModelListener fMRL;
    private final ChangeListener fVerticalScrollChangeListener;
    private boolean fIsDragSelectionEnabled = true;
    private int fStartSelectionIndex = -1;
    private int fPrevSelectionIndex = -1;
    private static final int HEADER_WIDTH_ADJUSTMENT = PlatformInfo.isWindows() ? 4 : 6;

    public SpreadsheetScrollPane(JTable jTable) {
        super((Component)jTable);
        if (jTable == null) {
            throw new IllegalArgumentException("SpreadsheetScrollPane constructor must be passed a non-null argument.");
        }
        this.fVerticalScrollChangeListener = new VerticalScrollingChangeListener();
        this.fAutoGrowthMouseListener = new AutoGrowthMouseListener();
        this.getHorizontalScrollBar().addMouseListener(this.fAutoGrowthMouseListener);
        this.getVerticalScrollBar().addMouseListener(this.fAutoGrowthMouseListener);
        this.fMRL = new AutoGrowthResizeListener();
        jTable.getModel().addTableModelListener(this.fMRL);
        jTable.setAutoResizeMode(0);
        this.fRowHeaderModel = new HeaderTableModel(jTable);
        this.fRowHeaderTable = new NamedRowHeaderTable(this.fRowHeaderModel);
        this.fRowHeaderTable.setName("SpreadsheetRowHeaderTable");
        this.fRowHeaderTable.setIntercellSpacing(new Dimension(0, 0));
        this.fRowHeaderTable.getTableHeader().setReorderingAllowed(false);
        this.fRowHeaderTable.getColumnModel().getColumn(0).setResizable(false);
        this.fRowHeaderTable.getTableHeader().setResizingAllowed(false);
        this.fTopLeftRenderer = new HeaderRenderer(2, 0, jTable);
        this.fRowHeaderTable.getColumnModel().getColumn(0).setHeaderRenderer(this.fTopLeftRenderer);
        this.fRowHeaderTable.getTableHeader().setDefaultRenderer(this.fTopLeftRenderer);
        this.setCorner("UPPER_LEFT_CORNER", this.fRowHeaderTable.getTableHeader());
        this.setRowHeaderView((Component)this.fRowHeaderTable);
        this.resizeRowHeadersToRequiredWidth(jTable.getModel().getRowCount());
        this.fRowHeightListener = new RowHeightListener();
        jTable.addPropertyChangeListener(this.fRowHeightListener);
        this.fSelListener = new RowSelectionL();
        jTable.getSelectionModel().addListSelectionListener(this.fSelListener);
        this.fFocusReassigner = new FocusReassigner();
        this.fRowHeaderTable.addFocusListener(this.fFocusReassigner);
        if (jTable instanceof IRowHeaderPopupMenuSource) {
            this.fPopupMenu = ((IRowHeaderPopupMenuSource)((Object)jTable)).getRowHeaderPopupMenu();
        }
        this.fRowHeaderMEL = new RowHeaderMouseEventL();
        this.fRowHeaderTable.addMouseListener(this.fRowHeaderMEL);
        this.fRowHeaderTable.addMouseMotionListener((MouseMotionListener)((Object)this.fRowHeaderMEL));
        this.fTopLeftMEL = new TopLeftMouseEventL();
        this.fRowHeaderTable.getTableHeader().addMouseListener(this.fTopLeftMEL);
    }

    public void setRowHeaderTableModel(HeaderTableModel headerTableModel) {
        this.fRowHeaderModel = headerTableModel;
        this.fRowHeaderTable.setModel((TableModel)headerTableModel);
    }

    public JTable getRowHeaderTable() {
        return this.fRowHeaderTable;
    }

    public void setRowHeaderView(Component component) {
        JViewport jViewport = this.getRowHeader();
        if (jViewport != null) {
            if (component == jViewport.getView()) {
                return;
            }
            jViewport.removeChangeListener(this.fVerticalScrollChangeListener);
        }
        super.setRowHeaderView(component);
        IHeaderRenderer iHeaderRenderer = this.fRowHeaderRenderer;
        this.fRowHeaderRenderer = this.getViewportView() instanceof IHeaderRendererProvider ? ((IHeaderRendererProvider)((Object)this.getViewportView())).createRowHeaderRenderer(this.getViewportView()) : new HeaderRenderer(1, 0, this.getViewportView());
        this.refreshRowHeaderRenderer();
        if (iHeaderRenderer != null) {
            iHeaderRenderer.cleanup();
        }
        this.getRowHeader().addChangeListener(this.fVerticalScrollChangeListener);
    }

    private void setAutoGrowthTemporarilyDisabled(boolean bl) {
        JTable jTable = null;
        try {
            jTable = this.getViewportView();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (jTable != null && jTable instanceof AbstractSpreadsheetTable) {
            ((AbstractSpreadsheetTable)((Object)jTable)).setAutoGrowthTemporarilyDisabled(bl);
        }
    }

    private JTable getViewportView() {
        Component component = this.getViewport().getView();
        assert (component instanceof JTable) : this.viewport != null ? this.viewport : "null";
        return (JTable)component;
    }

    private void refreshRowHeaderRenderer() {
        TableColumn tableColumn = this.fRowHeaderTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this.fRowHeaderRenderer);
        if (this.fRowHeaderRenderer instanceof TableCellEditor) {
            this.fRowHeaderTable.setDefaultEditor(this.fRowHeaderTable.getColumnClass(0), (TableCellEditor)((Object)this.fRowHeaderRenderer));
        }
        this.fRowHeaderTable.repaint();
    }

    public void clearPreviousRequiredWidth() {
        this.fPreviousRequiredWidth = -1;
    }

    public void resizeRowHeadersToRequiredWidth(int n) {
        if (this.fRowHeaderTable != null) {
            int n2;
            Object object;
            MJTable mJTable = this.fRowHeaderTable;
            Font font = mJTable.getFont();
            FontMetrics fontMetrics = mJTable.getFontMetrics(font);
            int n3 = this.fRowHeaderRenderer.getPreferredWidth(fontMetrics, object = this.fRowHeaderModel.getLongestValue(fontMetrics));
            int n4 = Math.max(15, Math.max(n3, n2 = HEADER_WIDTH_ADJUSTMENT));
            if (n4 > this.fPreviousRequiredWidth) {
                mJTable.setPreferredScrollableViewportSize(new Dimension(n4 + mJTable.getColumnModel().getColumnMargin(), 0));
                this.fPreviousRequiredWidth = n4;
            }
            this.refreshRowHeaderRenderer();
        }
    }

    private Rectangle getMainTableVisibleRegion() {
        JTable jTable = this.getViewportView();
        Rectangle rectangle = this.getViewport().getViewRect();
        Point point = new Point(rectangle.x, rectangle.y);
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n = jTable.rowAtPoint(point);
        int n2 = jTable.rowAtPoint(point2);
        int n3 = jTable.columnAtPoint(point);
        int n4 = jTable.columnAtPoint(point2);
        int n5 = jTable.getRowCount();
        if (n == -1) {
            int n6 = n = n5 > 0 ? 0 : -1;
        }
        if (n2 == -1) {
            int n7 = n2 = n5 > 0 ? n5 - 1 : -1;
        }
        if (n3 == -1) {
            int n8 = n3 = n5 > 0 ? 0 : -1;
        }
        if (n4 == -1) {
            n4 = n5 > 0 ? n5 - 1 : -1;
        }
        return new Rectangle(n, n3, n2 - n + 1, n4 - n3 + 1);
    }

    @Override
    public Rectangle getForthcomingRequestRegion(int n, int n2) {
        return this.getMainTableVisibleRegion();
    }

    public boolean IsDragSelectionEnabled() {
        return this.fIsDragSelectionEnabled;
    }

    public void setDragSelectionEnabled(boolean bl) {
        this.fIsDragSelectionEnabled = bl;
    }

    protected int getRowAtPoint(MouseEvent mouseEvent) {
        return this.fRowHeaderTable.rowAtPoint(mouseEvent.getPoint());
    }

    private boolean processPossiblePopup(MouseEvent mouseEvent) {
        Object object;
        boolean bl = false;
        if (this.fPopupMenu != null && mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component) {
            this.fPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
            bl = true;
        }
        return bl;
    }

    public void cleanup() {
        this.getRowHeader().removeChangeListener(this.fVerticalScrollChangeListener);
        this.fRowHeaderTable.removeFocusListener(this.fFocusReassigner);
        this.fFocusReassigner = null;
        this.fRowHeaderTable.removeMouseListener(this.fRowHeaderMEL);
        this.fRowHeaderTable.removeMouseMotionListener((MouseMotionListener)((Object)this.fRowHeaderMEL));
        this.fRowHeaderMEL = null;
        this.fRowHeaderTable.getTableHeader().removeMouseListener(this.fTopLeftMEL);
        this.fTopLeftMEL = null;
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        this.fRowHeaderTable.getColumn((Object)"").setCellRenderer(defaultTableCellRenderer);
        this.fRowHeaderTable.getColumn((Object)"").setHeaderRenderer(defaultTableCellRenderer);
        this.fRowHeaderTable = null;
        this.fRowHeaderModel = null;
        this.fTopLeftRenderer.cleanup();
        this.fTopLeftRenderer = null;
        JPanel jPanel = new JPanel();
        this.setCorner("UPPER_LEFT_CORNER", jPanel);
        this.getViewportView().removePropertyChangeListener(this.fRowHeightListener);
        this.fRowHeightListener = null;
        this.getViewportView().getSelectionModel().removeListSelectionListener(this.fSelListener);
        this.fSelListener = null;
        this.fRowHeaderRenderer.cleanup();
        this.fRowHeaderRenderer = null;
        this.getHorizontalScrollBar().removeMouseListener(this.fAutoGrowthMouseListener);
        this.getVerticalScrollBar().removeMouseListener(this.fAutoGrowthMouseListener);
        this.fAutoGrowthMouseListener = null;
        this.getViewportView().getModel().removeTableModelListener(this.fMRL);
        this.fMRL = null;
        this.fPopupMenu = null;
        this.setViewportView(jPanel);
    }

    private class NamedRowHeaderTable
    extends MJTable {
        private int iLastRowClick;

        NamedRowHeaderTable(TableModel tableModel) {
            super(tableModel);
            this.iLastRowClick = -1;
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    NamedRowHeaderTable.this.editingStopped(new ChangeEvent((Object)NamedRowHeaderTable.this));
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (SpreadsheetScrollPane.this.fRowHeaderRenderer instanceof TableCellEditor) {
                        NamedRowHeaderTable.this.setCursor(null);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    NamedRowHeaderTable.this.iLastRowClick = NamedRowHeaderTable.this.rowAtPoint(mouseEvent.getPoint());
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (SpreadsheetScrollPane.this.fRowHeaderRenderer instanceof TableCellEditor) {
                        int n = NamedRowHeaderTable.this.rowAtPoint(mouseEvent.getPoint());
                        int n2 = NamedRowHeaderTable.this.columnAtPoint(mouseEvent.getPoint());
                        if (NamedRowHeaderTable.this.getModel().isCellEditable(n, n2)) {
                            NamedRowHeaderTable.this.setCursor(new Cursor(2));
                        } else {
                            NamedRowHeaderTable.this.setCursor(null);
                        }
                    }
                }
            });
        }

        public void editingStopped(ChangeEvent changeEvent) {
            super.editingStopped(changeEvent);
            SpreadsheetScrollPane.this.clearPreviousRequiredWidth();
            SpreadsheetScrollPane.this.resizeRowHeadersToRequiredWidth(-1);
        }

        public boolean isCellEditable(int n, int n2) {
            return SpreadsheetScrollPane.this.fRowHeaderModel.isCellEditable(n, n2) && this.iLastRowClick == n;
        }

        public void processFocusEvent(FocusEvent focusEvent) {
            if (!this.isEditing()) {
                super.processFocusEvent(focusEvent);
            }
        }
    }

    private class TopLeftMouseEventL
    extends MouseAdapter {
        private TopLeftMouseEventL() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JTable jTable = SpreadsheetScrollPane.this.getViewportView();
            jTable.selectAll();
            jTable.getSelectionModel().setAnchorSelectionIndex(0);
            jTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(0);
            SpreadsheetScrollPane.this.processPossiblePopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            SpreadsheetScrollPane.this.processPossiblePopup(mouseEvent);
        }
    }

    private class RowHeaderMouseEventL
    extends MouseAdapter {
        private RowHeaderMouseEventL() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl = SpreadsheetScrollPane.this.processPossiblePopup(mouseEvent);
            if (!bl) {
                int n;
                int n2;
                AbstractSpreadsheetTable abstractSpreadsheetTable = null;
                JTable jTable = SpreadsheetScrollPane.this.getViewportView();
                if (jTable instanceof AbstractSpreadsheetTable) {
                    abstractSpreadsheetTable = (AbstractSpreadsheetTable)((Object)jTable);
                }
                if (!jTable.getRowSelectionAllowed()) {
                    n2 = 1;
                    if (abstractSpreadsheetTable != null && abstractSpreadsheetTable.isSelectionModeByHeader()) {
                        n2 = 0;
                    }
                    if (n2 != 0) {
                        return;
                    }
                }
                if ((n2 = SpreadsheetScrollPane.this.getRowAtPoint(mouseEvent)) == -1) {
                    return;
                }
                if (SpreadsheetScrollPane.this.fIsDragSelectionEnabled && mouseEvent.getButton() == 1) {
                    SpreadsheetScrollPane.this.fStartSelectionIndex = n2;
                    SpreadsheetScrollPane.this.fPrevSelectionIndex = n2;
                }
                if ((n = jTable.getColumnCount()) != 0 && abstractSpreadsheetTable != null && abstractSpreadsheetTable.isSelectionModeByHeader()) {
                    jTable.setColumnSelectionAllowed(false);
                    jTable.setRowSelectionAllowed(true);
                }
                ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                boolean bl2 = false;
                if (mouseEvent.isShiftDown()) {
                    int n3 = listSelectionModel.getAnchorSelectionIndex();
                    int n4 = listSelectionModel.getLeadSelectionIndex();
                    if (n3 != -1) {
                        boolean bl3 = listSelectionModel.getValueIsAdjusting();
                        listSelectionModel.setValueIsAdjusting(true);
                        boolean bl4 = listSelectionModel.isSelectedIndex(n3);
                        if (n4 != -1) {
                            if (bl4) {
                                listSelectionModel.removeSelectionInterval(n3, n4);
                            } else {
                                listSelectionModel.addSelectionInterval(n3, n4);
                            }
                        }
                        if (bl4) {
                            listSelectionModel.addSelectionInterval(n3, n2);
                        } else {
                            listSelectionModel.removeSelectionInterval(n3, n2);
                        }
                        bl2 = true;
                        listSelectionModel.setValueIsAdjusting(bl3);
                    } else {
                        bl2 = true;
                        listSelectionModel.setSelectionInterval(n2, n2);
                    }
                } else if (mouseEvent.isControlDown() || PlatformInfo.isMacintosh() && mouseEvent.isMetaDown()) {
                    if (listSelectionModel.isSelectedIndex(n2)) {
                        listSelectionModel.removeSelectionInterval(n2, n2);
                    } else {
                        listSelectionModel.addSelectionInterval(n2, n2);
                    }
                } else if (!SwingUtilities.isRightMouseButton(mouseEvent) && !mouseEvent.isPopupTrigger() || !listSelectionModel.isSelectedIndex(n2)) {
                    listSelectionModel.setSelectionInterval(n2, n2);
                    bl2 = true;
                }
                if (bl2 && abstractSpreadsheetTable != null) {
                    abstractSpreadsheetTable.selectEntireRows();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle;
            super.mouseDragged(mouseEvent);
            AbstractSpreadsheetTable abstractSpreadsheetTable = null;
            JTable jTable = SpreadsheetScrollPane.this.getViewportView();
            if (jTable instanceof AbstractSpreadsheetTable) {
                abstractSpreadsheetTable = (AbstractSpreadsheetTable)((Object)jTable);
            }
            Point point = mouseEvent.getPoint();
            int n = SpreadsheetScrollPane.this.getRowAtPoint(mouseEvent);
            if (n < 0) {
                return;
            }
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            listSelectionModel.setValueIsAdjusting(true);
            if (SpreadsheetScrollPane.this.fStartSelectionIndex != -1 && !(rectangle = SpreadsheetScrollPane.this.getVisibleRect()).contains(point) && n >= 0) {
                Rectangle rectangle2 = jTable.getCellRect(n, 0, true);
                jTable.scrollRectToVisible(rectangle2);
            }
            if (SpreadsheetScrollPane.this.fStartSelectionIndex != -1 && SpreadsheetScrollPane.this.fIsDragSelectionEnabled) {
                if (SpreadsheetScrollPane.this.fStartSelectionIndex <= n && n < SpreadsheetScrollPane.this.fPrevSelectionIndex || SpreadsheetScrollPane.this.fStartSelectionIndex >= n && n > SpreadsheetScrollPane.this.fPrevSelectionIndex || n >= SpreadsheetScrollPane.this.fStartSelectionIndex && SpreadsheetScrollPane.this.fStartSelectionIndex > SpreadsheetScrollPane.this.fPrevSelectionIndex || n <= SpreadsheetScrollPane.this.fStartSelectionIndex && SpreadsheetScrollPane.this.fStartSelectionIndex < SpreadsheetScrollPane.this.fPrevSelectionIndex) {
                    listSelectionModel.removeSelectionInterval(SpreadsheetScrollPane.this.fPrevSelectionIndex, n);
                    listSelectionModel.removeSelectionInterval(SpreadsheetScrollPane.this.fPrevSelectionIndex, SpreadsheetScrollPane.this.fStartSelectionIndex);
                    listSelectionModel.removeSelectionInterval(SpreadsheetScrollPane.this.fStartSelectionIndex, n);
                    listSelectionModel.addSelectionInterval(SpreadsheetScrollPane.this.fStartSelectionIndex, n);
                }
                if (n != SpreadsheetScrollPane.this.fStartSelectionIndex) {
                    if (n != SpreadsheetScrollPane.this.fPrevSelectionIndex && n >= 0) {
                        if (!listSelectionModel.isSelectedIndex(n)) {
                            listSelectionModel.addSelectionInterval(SpreadsheetScrollPane.this.fStartSelectionIndex, n);
                        }
                        SpreadsheetScrollPane.this.fPrevSelectionIndex = n;
                    }
                    if (abstractSpreadsheetTable != null) {
                        abstractSpreadsheetTable.repaint();
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            SpreadsheetScrollPane.this.processPossiblePopup(mouseEvent);
            JTable jTable = SpreadsheetScrollPane.this.getViewportView();
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            listSelectionModel.setValueIsAdjusting(false);
            SpreadsheetScrollPane.this.fStartSelectionIndex = -1;
            SpreadsheetScrollPane.this.fPrevSelectionIndex = -1;
        }
    }

    private class AutoGrowthMouseListener
    extends MouseAdapter {
        private AutoGrowthMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            SpreadsheetScrollPane.this.setAutoGrowthTemporarilyDisabled(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            SpreadsheetScrollPane.this.setAutoGrowthTemporarilyDisabled(false);
        }
    }

    public static class HeaderTableModel
    extends AbstractTableModel {
        protected JTable iMainTable;
        private int iRowCount;

        public HeaderTableModel(JTable jTable) {
            this.iMainTable = jTable;
            this.iRowCount = jTable.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.iMainTable.getRowCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n + 1;
        }

        public Object getLongestValue(FontMetrics fontMetrics) {
            return Integer.toString(this.getRowCount());
        }

        @Override
        public String getColumnName(int n) {
            return "";
        }

        public void updateRowCount() {
            int n = this.iRowCount;
            int n2 = this.iMainTable.getRowCount();
            if (n2 < n) {
                this.fireTableRowsInserted(n, n2 - 1);
            }
            if (n2 > n) {
                this.fireTableRowsDeleted(n, n2 - 1);
            }
            this.iRowCount = n2;
        }
    }

    private class AutoGrowthResizeListener
    implements TableModelListener {
        private AutoGrowthResizeListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getColumn();
            int n3 = tableModelEvent.getType();
            JTable jTable = SpreadsheetScrollPane.this.getViewportView();
            if (n == -1) {
                SpreadsheetScrollPane.this.fRowHeaderModel.updateRowCount();
                SpreadsheetScrollPane.this.resizeRowHeadersToRequiredWidth(jTable.getModel().getRowCount());
            }
            if (n2 == -1) {
                if (n3 == 1 || n3 == -1) {
                    SpreadsheetScrollPane.this.fRowHeaderModel.updateRowCount();
                    SpreadsheetScrollPane.this.resizeRowHeadersToRequiredWidth(jTable.getModel().getRowCount());
                }
                if (n == 0 && n3 == 1) {
                    SpreadsheetScrollPane.this.fRowHeaderTable.getColumn((Object)"").setCellRenderer(SpreadsheetScrollPane.this.fRowHeaderRenderer);
                }
            }
        }
    }

    private class VerticalScrollingChangeListener
    implements ChangeListener {
        private VerticalScrollingChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Point point = ((JViewport)changeEvent.getSource()).getViewPosition();
            Point point2 = SpreadsheetScrollPane.this.getViewport().getViewPosition();
            if (point.y != point2.y) {
                point2.y = point.y;
                SpreadsheetScrollPane.this.getViewport().setViewPosition(point2);
            }
        }
    }

    private class FocusReassigner
    implements FocusListener {
        private FocusReassigner() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            SpreadsheetScrollPane.this.getViewportView().requestFocusInWindow();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class RowSelectionL
    implements ListSelectionListener {
        private RowSelectionL() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SpreadsheetScrollPane.this.fRowHeaderModel.fireTableRowsUpdated(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex());
            SpreadsheetScrollPane.this.refreshRowHeaderRenderer();
        }
    }

    private class RowHeightListener
    implements PropertyChangeListener {
        private RowHeightListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("rowHeight")) {
                JTable jTable = SpreadsheetScrollPane.this.getViewportView();
                if (jTable != null && SpreadsheetScrollPane.this.fRowHeaderTable != null && SpreadsheetScrollPane.this.fRowHeaderTable.getColumnModel() != null && SpreadsheetScrollPane.this.fRowHeaderTable.getColumnModel().getColumnCount() > 0) {
                    SpreadsheetScrollPane.this.fRowHeaderTable.setFont(jTable.getFont());
                    SpreadsheetScrollPane.this.fRowHeaderRenderer.setFont(jTable.getFont());
                    SpreadsheetScrollPane.this.fPreviousRequiredWidth = -1;
                    SpreadsheetScrollPane.this.resizeRowHeadersToRequiredWidth(-1);
                }
                SpreadsheetScrollPane.this.fRowHeaderTable.setRowHeight(((Integer)propertyChangeEvent.getNewValue()).intValue());
            }
        }
    }
}

