/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.spreadsheet.data.ComplexArray;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarDouble;
import java.util.Arrays;

public final class ComplexArrayDouble
extends ComplexArray {
    private final double[][] fR;
    private final double[][] fI;
    private static final ComplexArrayDouble EMPTY_REAL = ComplexArrayDouble.valueOf(new double[0][0]);
    private static final ComplexArrayDouble EMPTY_COMPLEX = ComplexArrayDouble.valueOf(new double[0][0], new double[0][0]);

    public static ComplexArrayDouble valueOf(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!ArrayUtils.isRectangular((Object)dArray)) {
            throw new IllegalArgumentException("Array argument must be rectangular.");
        }
        return new ComplexArrayDouble(dArray);
    }

    public static ComplexArrayDouble valueOf(double[][] dArray, double[][] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!Arrays.equals(ArrayUtils.getLengths((double[][])dArray), ArrayUtils.getLengths((double[][])dArray2))) {
            throw new IllegalArgumentException("Real and imaginary array arguments must have the same size.");
        }
        return new ComplexArrayDouble(dArray, dArray2);
    }

    public static ComplexArrayDouble getEmptyRealInstance() {
        return EMPTY_REAL;
    }

    public static ComplexArrayDouble getEmptyComplexInstance() {
        return EMPTY_COMPLEX;
    }

    private ComplexArrayDouble(double[][] dArray) {
        super(true);
        this.fR = dArray;
        this.fI = null;
    }

    private ComplexArrayDouble(double[][] dArray, double[][] dArray2) {
        super(true);
        this.fR = dArray;
        this.fI = dArray2;
    }

    public double[][] doubleValueReal() {
        return this.fR;
    }

    public double[][] doubleValueImaginary() {
        return this.fI;
    }

    @Override
    public boolean isReal() {
        return this.fI == null;
    }

    @Override
    public int[] getLengths() {
        return ArrayUtils.getLengths((double[][])this.fR);
    }

    @Override
    public ComplexScalarDouble getValueAt(int n, int n2) {
        if (this.isReal()) {
            return ComplexScalarDouble.valueOf(this.fR[n][n2]);
        }
        return ComplexScalarDouble.valueOf(this.fR[n][n2], this.fI[n][n2]);
    }
}

