/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.print;

import com.mathworks.widgets.spreadsheet.IDataBoundsSupplier;
import com.mathworks.widgets.spreadsheet.SelectionHider;
import com.mathworks.widgets.spreadsheet.print.ArrayPrintable;
import com.mathworks.widgets.text.print.MultiHeaderUtils;
import com.mathworks.widgets.text.print.PrintUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class MultiHeaderSpreadsheetPrinter {
    private MultiHeaderSpreadsheetPrinter() {
    }

    public static void print(JTable jTable, String string, String string2, Component component) {
        int n;
        int n2;
        int n3;
        int n4;
        TableModel tableModel = jTable.getModel();
        boolean bl = false;
        if (tableModel instanceof IDataBoundsSupplier) {
            IDataBoundsSupplier iDataBoundsSupplier = (IDataBoundsSupplier)((Object)tableModel);
            n4 = iDataBoundsSupplier.getFirstDataRow();
            n3 = iDataBoundsSupplier.getLastDataRow();
            n2 = iDataBoundsSupplier.getFirstDataColumn();
            n = iDataBoundsSupplier.getLastDataColumn();
            bl = true;
        } else if (jTable.getTableHeader().getReorderingAllowed()) {
            n2 = 0;
            n4 = 0;
            n3 = tableModel.getRowCount() - 1;
            n = tableModel.getColumnCount() - 1;
            int n5 = -1;
            for (int i = 0; i <= n; ++i) {
                n5 = Math.max(n5, jTable.convertColumnIndexToView(i));
            }
            n = n5;
        } else {
            n4 = 0;
            n2 = 0;
            n3 = tableModel.getRowCount() - 1;
            n = tableModel.getColumnCount() - 1;
        }
        MultiHeaderSpreadsheetPrinter.performPrinting(jTable, component, string, string2, new Rectangle(n2, n4, n + 1, n3 + 1), bl);
    }

    public static void printSelection(JTable jTable, String string, String string2) {
        int[] nArray = jTable.getSelectedRows();
        int[] nArray2 = jTable.getSelectedColumns();
        if (nArray.length > 0) {
            int n = nArray[0];
            int n2 = nArray[nArray.length - 1];
            int n3 = nArray2[0];
            int n4 = nArray2[nArray2.length - 1];
            TableModel tableModel = jTable.getModel();
            if (tableModel instanceof IDataBoundsSupplier) {
                IDataBoundsSupplier iDataBoundsSupplier = (IDataBoundsSupplier)((Object)tableModel);
                n2 = Math.min(n2, iDataBoundsSupplier.getLastDataRow());
                n4 = Math.min(n4, iDataBoundsSupplier.getLastDataColumn());
            }
            MultiHeaderSpreadsheetPrinter.performPrinting(jTable, jTable, string, string2, new Rectangle(n3, n, n4 - n3 + 1, n2 - n + 1), true);
        }
    }

    private static void performPrinting(JTable jTable, Component component, String string, String string2, Rectangle rectangle, boolean bl) {
        SelectionHider selectionHider = null;
        ListSelectionModel listSelectionModel = null;
        ListSelectionModel listSelectionModel2 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        int n = -1;
        int n2 = -1;
        if (jTable instanceof SelectionHider) {
            selectionHider = (SelectionHider)((Object)jTable);
            selectionHider.setSelectionHidden(true);
        } else {
            listSelectionModel = jTable.getColumnModel().getSelectionModel();
            listSelectionModel2 = jTable.getSelectionModel();
            n = listSelectionModel.getAnchorSelectionIndex();
            n2 = listSelectionModel2.getAnchorSelectionIndex();
            nArray = jTable.getSelectedColumns();
            nArray2 = jTable.getSelectedRows();
            jTable.clearSelection();
        }
        TableModel tableModel = jTable.getModel();
        int n3 = tableModel.getRowCount() - 1;
        int n4 = tableModel.getColumnCount() - 1;
        Object[] objectArray = new Object[]{new Date()};
        MessageFormat messageFormat = new MessageFormat(MultiHeaderSpreadsheetPrinter.cleanupHeader(string2));
        MessageFormat messageFormat2 = new MessageFormat(MessageFormat.format(MultiHeaderUtils.getDateAndTimeHeaderText(), objectArray));
        ArrayPrintable arrayPrintable = new ArrayPrintable(jTable, JTable.PrintMode.NORMAL, messageFormat, messageFormat2, rectangle == null ? new Rectangle(0, 0, n4 + 1, n3 + 1) : rectangle);
        arrayPrintable.setBorder(bl);
        PrintUtils.processPrint(arrayPrintable, string, jTable.getTopLevelAncestor(), component);
        if (selectionHider != null) {
            SwingUtilities.invokeLater(new SelectionUnhider(selectionHider));
        } else if (nArray2.length > 0 && nArray.length > 0) {
            listSelectionModel2.setSelectionInterval(nArray2[0], nArray2[nArray2.length - 1]);
            listSelectionModel.setSelectionInterval(nArray[0], nArray[nArray.length - 1]);
            listSelectionModel.setAnchorSelectionIndex(n);
            listSelectionModel2.setAnchorSelectionIndex(n2);
        }
    }

    private static String cleanupHeader(String string) {
        String string2;
        StringBuilder stringBuilder;
        int n = string.indexOf(9);
        if (n >= 0) {
            stringBuilder = new StringBuilder(string.substring(0, n));
            string2 = string.substring(n);
        } else {
            stringBuilder = new StringBuilder(string);
            string2 = "";
        }
        MultiHeaderSpreadsheetPrinter.wrapString(stringBuilder, "{");
        MultiHeaderSpreadsheetPrinter.wrapString(stringBuilder, "}");
        return stringBuilder.append(string2).toString();
    }

    private static void wrapString(StringBuilder stringBuilder, String string) {
        int n = stringBuilder.indexOf(string);
        while (n >= 0) {
            stringBuilder.insert(n, '\'');
            stringBuilder.insert(n + 2, '\'');
            n = stringBuilder.indexOf(string, n + 2);
        }
    }

    private static class SelectionUnhider
    implements Runnable {
        private SelectionHider iHider;

        SelectionUnhider(SelectionHider selectionHider) {
            this.iHider = selectionHider;
        }

        @Override
        public void run() {
            this.iHider.setSelectionHidden(false);
        }
    }
}

