/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorLanguagePriority;
import com.mathworks.util.Log;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.text.DocumentUtils;
import com.mathworks.widgets.text.SmartFormatter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.ext.ExtKit;

public class EditorLanguageUtils {
    private static List<EditorLanguage> sLanguages = null;

    private EditorLanguageUtils() {
    }

    public static synchronized List<EditorLanguage> getLanguages() {
        if (sLanguages == null) {
            sLanguages = EditorLanguageUtils.registerLanguages();
        }
        return sLanguages;
    }

    public static EditorLanguage findLanguage(String string) {
        for (EditorLanguage editorLanguage : EditorLanguageUtils.getLanguages()) {
            if (!editorLanguage.getMimeType().equals(string)) continue;
            return editorLanguage;
        }
        return null;
    }

    public static String getMimeTypeFromFilename(String string) {
        return EditorLanguageUtils.getLanguageFromFilename(string).getMimeType();
    }

    public static EditorLanguage getLanguageFromFilename(String string) {
        Validate.notNull((Object)string, (String)"'filename' cannot be null");
        String string2 = FilenameUtils.getExtension((String)string);
        for (EditorLanguage editorLanguage : EditorLanguageUtils.getLanguages()) {
            if (!editorLanguage.isMatchingExtension(string2)) continue;
            return editorLanguage;
        }
        throw new IllegalStateException("PlainLanguage did not accept " + string);
    }

    public static int compareLanguages(EditorLanguage editorLanguage, EditorLanguage editorLanguage2) {
        EditorLanguagePriority editorLanguagePriority;
        EditorLanguagePriority editorLanguagePriority2 = editorLanguage.getPriority();
        int n = editorLanguagePriority2.compareTo((Enum)(editorLanguagePriority = editorLanguage2.getPriority()));
        return n != 0 ? n : editorLanguage.getInternalName().compareTo(editorLanguage2.getInternalName());
    }

    private static List<EditorLanguage> registerLanguages() {
        Collection collection = ClasspathOSGiManager.getInstance().getImplementors(EditorLanguage.class);
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, new Comparator<EditorLanguage>(){

            @Override
            public int compare(EditorLanguage editorLanguage, EditorLanguage editorLanguage2) {
                return EditorLanguageUtils.compareLanguages(editorLanguage, editorLanguage2);
            }
        });
        return Collections.unmodifiableList(arrayList);
    }

    public static boolean isSmartIndentingSupported(EditorLanguage editorLanguage) {
        return ((ExtKit)editorLanguage.createDefaultKit()).createFormatter() instanceof SmartFormatter;
    }

    public static String indentText(EditorLanguage editorLanguage, String string) {
        Validate.isTrue((boolean)EditorLanguageUtils.isSmartIndentingSupported(editorLanguage), (String)("Supplied languages does not support smart indenting: " + editorLanguage));
        ExtKit extKit = (ExtKit)editorLanguage.createDefaultKit();
        Formatter formatter = extKit.createFormatter();
        BaseDocument baseDocument = new BaseDocument(extKit.getClass(), false);
        try {
            baseDocument.read((Reader)new StringReader(string), 0);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        return DocumentUtils.indentText(baseDocument, formatter, 0, baseDocument.getLength());
    }
}

