/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.text.TextUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.layer.EditorTip;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import com.mathworks.widgets.tooltip.ToolTipAndComponentAWTListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ToolTipSupport;

public class MWToolTipSupport
extends ToolTipSupport {
    private Font fFont;
    protected EditorTip fTip;
    private SupportToolTipAndComponentAWTListener fAWTListener;
    private boolean fManual;
    private List<EditorMessage> fMessages = Collections.emptyList();
    private boolean fIsSameTip;
    private DismissEventListener fDocumentListener;

    public MWToolTipSupport(ExtEditorUI extEditorUI) {
        super(extEditorUI);
    }

    public void setToolTipTextAndFont(String string, Font font) {
        this.fFont = font;
        super.setToolTipText(string);
    }

    public void setToolTipText(String string) {
        this.fFont = null;
        super.setToolTipText(string);
    }

    protected JTextArea createTextToolTip() {
        this.cleanupTip();
        JTextArea jTextArea = new JTextArea(){

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        jTextArea.setOpaque(true);
        jTextArea.setEditable(false);
        Color color = UIManager.getColor("ToolTip.background");
        Color color2 = UIManager.getColor("ToolTip.foreground");
        if (this.fFont != null) {
            jTextArea.setFont(this.fFont);
            this.fFont = null;
        } else {
            jTextArea.setFont(UIManager.getFont("ToolTip.font"));
        }
        if (color2 != null) {
            jTextArea.setForeground(color2);
        }
        if (color != null) {
            jTextArea.setBackground(color);
        }
        jTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(jTextArea.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        jTextArea.setActionMap(new ActionMap());
        return jTextArea;
    }

    protected void registerMouseListeners(JTextComponent jTextComponent) {
        super.registerMouseListeners(jTextComponent);
        this.fAWTListener = new SupportToolTipAndComponentAWTListener(jTextComponent);
        this.fDocumentListener = new DismissEventListener();
        jTextComponent.addCaretListener(this.fDocumentListener);
    }

    public void unregisterMouseListeners(JTextComponent jTextComponent) {
        this.fAWTListener.uninstall();
        jTextComponent.removeCaretListener(this.fDocumentListener);
        super.unregisterMouseListeners(jTextComponent);
    }

    public void makeTipAtMouse(List<? extends EditorMessage> list, JTextComponent jTextComponent) {
        Window window = WindowUtils.getTopmostWindow((Component)jTextComponent);
        if (this.getLastMouseEvent() == null || window == null || !window.isActive()) {
            return;
        }
        JPopupMenu jPopupMenu = ((ExtEditorUI)Utilities.getEditorUI((JTextComponent)jTextComponent)).getPopupMenu();
        if (jPopupMenu == null || !jPopupMenu.isShowing()) {
            this.makeTip(list, jTextComponent);
        }
    }

    public void makeOrExpandTip(List<? extends EditorMessage> list, JTextComponent jTextComponent) {
        if (this.fTip != null && ((Object)this.fMessages).equals(list)) {
            this.fTip.expand();
        } else {
            this.makeTip(list, jTextComponent);
            this.fManual = true;
        }
    }

    public void makeTip(List<? extends EditorMessage> list, JTextComponent jTextComponent) {
        this.makeTip(list, jTextComponent, false);
    }

    public void makeTip(List<? extends EditorMessage> list, JTextComponent jTextComponent, boolean bl) {
        assert (!list.isEmpty()) : "This method should only be called if the messages are non-empty";
        this.fAWTListener.stopHideTimer();
        if (this.isTipVisible() && ((Object)this.fMessages).equals(list)) {
            this.fIsSameTip = true;
            return;
        }
        if (bl) {
            this.fManual = true;
        }
        this.fMessages = Collections.unmodifiableList(list);
        if (bl && this.fTip != null && this.isTipVisible()) {
            this.fTip.updateTip(this.fMessages);
        } else {
            if (this.fTip != null) {
                this.fTip.cleanup();
            }
            assert (this.fTip == null);
            this.fTip = this.makeAndShowTip(list, jTextComponent);
        }
    }

    public EditorTip getTip() {
        return this.fTip;
    }

    private EditorTip makeAndShowTip(List<? extends EditorMessage> list, JTextComponent jTextComponent) {
        Object object;
        STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)jTextComponent);
        int n = 0;
        Rectangle rectangle = null;
        try {
            Object object2;
            n = list.get(0).getStartPosition();
            int n2 = list.get(0).getEndPosition();
            object = jTextComponent.modelToView(n);
            Rectangle rectangle2 = jTextComponent.modelToView(n2);
            if (rectangle2 == null || object == null) {
                int n3 = list.get(0).getLineNumber();
                object2 = TextUtils.getLineStartAndEnd((JTextComponent)jTextComponent, (int)n3);
                if (object == null) {
                    object = jTextComponent.modelToView((int)object2[0]);
                }
                if (rectangle2 == null) {
                    rectangle2 = jTextComponent.modelToView((int)object2[1]);
                }
            }
            Point point = ((Rectangle)object).getLocation();
            object2 = rectangle2.getLocation();
            SwingUtilities.convertPointToScreen(point, jTextComponent);
            SwingUtilities.convertPointToScreen((Point)object2, jTextComponent);
            rectangle = new Rectangle(point.x, point.y, ((Point)object2).x - point.x, ((Rectangle)object).height);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        Point point = null;
        try {
            point = jTextComponent.modelToView(n).getLocation();
            point.y += sTPBaseInterface.getLineHeight();
            point.x = jTextComponent.getParent() instanceof JViewport ? ((JViewport)jTextComponent.getParent()).getViewPosition().x : 0;
            SwingUtilities.convertPointToScreen(point, jTextComponent);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        object = new EditorTip(jTextComponent, new EditorTip.MEditorTipStrategy(){

            @Override
            public String formatMessage(EditorMessage editorMessage) {
                return editorMessage.getMessage();
            }

            @Override
            public List<BalloonToolTip.ArrowDirection> getPossiblePositions() {
                return BalloonToolTip.SOUTH_NORTH;
            }
        }, list, rectangle, point){

            @Override
            public void cleanup() {
                super.cleanup();
                MWToolTipSupport.this.fTip = null;
                MWToolTipSupport.this.fManual = false;
            }
        };
        ((EditorTip)object).show();
        return object;
    }

    public void cleanupTip() {
        if (this.fTip != null) {
            this.fTip.cleanup();
        }
    }

    public boolean isTipVisible() {
        return this.fAWTListener.isTipShowing();
    }

    public boolean keyControlKeyPressed(ActionEvent actionEvent, String string) {
        return this.fTip.forwardStroke(actionEvent, string);
    }

    public boolean shouldAcceptKeyStroke() {
        return this.isTipVisible();
    }

    private class SupportToolTipAndComponentAWTListener
    extends ToolTipAndComponentAWTListener {
        private SupportToolTipAndComponentAWTListener(JTextComponent jTextComponent) {
            super(jTextComponent, 200);
        }

        @Override
        protected boolean shouldStartHideTimer() {
            return this.isTipShowing() && !MWToolTipSupport.this.fManual && !MWToolTipSupport.this.fTip.isScrolling();
        }

        @Override
        protected void hideTip() {
            if (this.isTipShowing() && (!MWToolTipSupport.this.fIsSameTip || this.movedOutsideSource())) {
                MWToolTipSupport.this.fTip.cleanup();
            }
        }

        @Override
        protected void movedInsideSource(MouseEvent mouseEvent) {
            MWToolTipSupport.this.fIsSameTip = false;
            MWToolTipSupport.this.lastMouseEvent = mouseEvent;
        }

        @Override
        protected boolean isTipShowing() {
            return MWToolTipSupport.this.fTip != null;
        }

        @Override
        protected boolean doesTipContainScreenCoordinates(Point point) {
            return this.isTipShowing() && MWToolTipSupport.this.fTip.containsScreenPoint(point);
        }

        @Override
        protected void mouseWheeledInsideTip(MouseWheelEvent mouseWheelEvent) {
            assert (this.isTipShowing()) : "method should not be called if there is no tip";
            MWToolTipSupport.this.fTip.notifyMouseWheelListeners(mouseWheelEvent);
        }

        @Override
        protected void mouseClickedInsideTip(MouseEvent mouseEvent) {
            assert (this.isTipShowing()) : "method should not be called if there is no tip";
            MWToolTipSupport.this.fTip.clickedInside(mouseEvent);
        }
    }

    private class DismissEventListener
    implements CaretListener {
        private DismissEventListener() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (!MWToolTipSupport.this.fManual) {
                MWToolTipSupport.this.cleanupTip();
            }
        }
    }
}

