/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.layer;

import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.messagepanel.MessageModel;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.MWToolTipSupport;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.STPMessagePanel;
import com.mathworks.widgets.text.layer.LayerUtils;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtUtilities;

public class LayerActions {
    public static final String NEXT_USAGE_ACTION = "next-message";
    public static final String PREVIOUS_USAGE_ACTION = "previous-message";
    public static final String MESSAGE_OPEN_ACTION = "open-mlint-message";
    public static final String CARET_MOVED_BY_GO_TO_MESSAGE_ACTION = "layeractions.gotomessage";

    private LayerActions() {
    }

    public static BaseAction createGoToPreviousAction() {
        return LayerActions.createGoToPreviousAction(null);
    }

    public static BaseAction createGoToPreviousAction(MessageModel<EditorMessage> messageModel) {
        return new GoToPreviousMessageAction(messageModel);
    }

    public static BaseAction createGoToNextAction() {
        return LayerActions.createGoToNextAction(null);
    }

    public static BaseAction createGoToNextAction(MessageModel<EditorMessage> messageModel) {
        return new GoToNextMessageAction(messageModel);
    }

    public static Action createOpenMessageAction() {
        return new OpenMessageAction();
    }

    public static Action createOpenMessageMenuItemAction() {
        return new OpenMessageActionWrapper();
    }

    private static void goForward(STPBaseInterface sTPBaseInterface, MessageModel<EditorMessage> messageModel) {
        int n = sTPBaseInterface.getCaretPosition();
        if (messageModel == null) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < messageModel.getMessageCount(); ++i) {
            EditorMessage editorMessage = messageModel.getMessageAt(i);
            if (editorMessage.getStartPosition() <= n) continue;
            LayerActions.goToMessage(editorMessage, sTPBaseInterface);
            bl = true;
            break;
        }
        if (!bl && messageModel.getMessageCount() > 0) {
            LayerActions.goToMessage(messageModel.getMessageAt(0), sTPBaseInterface);
        }
    }

    private static MessageModel<EditorMessage> getActiveModel(STPBaseInterface sTPBaseInterface) {
        ExtEditorUI extEditorUI = ExtUtilities.getExtEditorUI((JTextComponent)sTPBaseInterface.getActiveTextComponent());
        STPMessagePanel sTPMessagePanel = ((MWEditorUI)extEditorUI).getMessagePanel();
        return sTPMessagePanel != null ? sTPMessagePanel.getActiveModel() : null;
    }

    private static void goBackward(STPBaseInterface sTPBaseInterface, MessageModel<EditorMessage> messageModel) {
        int n = sTPBaseInterface.getCaretPosition();
        if (messageModel == null) {
            return;
        }
        boolean bl = false;
        for (int i = messageModel.getMessageCount() - 1; i >= 0; --i) {
            EditorMessage editorMessage = messageModel.getMessageAt(i);
            if (editorMessage.getEndPosition() >= n) continue;
            LayerActions.goToMessage(editorMessage, sTPBaseInterface);
            bl = true;
            break;
        }
        if (!bl && messageModel.getMessageCount() > 0) {
            LayerActions.goToMessage(messageModel.getMessageAt(messageModel.getMessageCount() - 1), sTPBaseInterface);
        }
    }

    private static void goToMessage(EditorMessage editorMessage, STPBaseInterface sTPBaseInterface) {
        int n = editorMessage.getStartPosition();
        sTPBaseInterface.getActiveTextComponent().putClientProperty(CARET_MOVED_BY_GO_TO_MESSAGE_ACTION, true);
        sTPBaseInterface.selectAndCenterIfNotVisible(n, n);
    }

    private static class OpenMessageActionWrapper
    extends ChildAction {
        private OpenMessageActionWrapper() {
            super((Action)((Object)new OpenMessageAction()));
            String string = (String)this.getParent().getValue("Name");
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABEditor", string, (ExtendedAction)this);
        }
    }

    private static class OpenMessageAction
    extends BaseAction {
        private OpenMessageAction() {
            super(LayerActions.MESSAGE_OPEN_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            List<? extends EditorMessage> list = LayerUtils.getMessagesAtCaret(jTextComponent);
            if (!list.isEmpty()) {
                MWToolTipSupport mWToolTipSupport = (MWToolTipSupport)ExtUtilities.getExtEditorUI((JTextComponent)jTextComponent).getToolTipSupport();
                mWToolTipSupport.makeOrExpandTip(list, jTextComponent);
            }
        }
    }

    private static class GoToNextMessageAction
    extends BaseAction {
        private final MessageModel<EditorMessage> fModel;

        private GoToNextMessageAction(MessageModel<EditorMessage> messageModel) {
            super(LayerActions.NEXT_USAGE_ACTION);
            this.fModel = messageModel;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)jTextComponent);
            LayerActions.goForward(sTPBaseInterface, this.fModel == null ? LayerActions.getActiveModel(sTPBaseInterface) : this.fModel);
        }
    }

    private static class GoToPreviousMessageAction
    extends BaseAction {
        private final MessageModel<EditorMessage> fModel;

        private GoToPreviousMessageAction(MessageModel<EditorMessage> messageModel) {
            super(LayerActions.PREVIOUS_USAGE_ACTION);
            this.fModel = messageModel;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)jTextComponent);
            LayerActions.goBackward(sTPBaseInterface, this.fModel == null ? LayerActions.getActiveModel(sTPBaseInterface) : this.fModel);
        }
    }
}

