/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.print;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.services.ColorPrefs;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.print.MultiHeaderUtils;
import com.mathworks.widgets.text.print.PrintSettings;
import com.mathworks.widgets.text.print.TextPrintable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;

public class PrintUtils {
    private static ResourceBundle sBundle = ResourceBundle.getBundle("com.mathworks.widgets.text.print.resources.RES_Print");

    private PrintUtils() {
    }

    public static String getResource(String string) {
        return sBundle.getString(string);
    }

    static String getResource(String string, String string2) {
        return MessageFormat.format(PrintUtils.getResource(string), string2);
    }

    public static void processPrint(Printable printable, String string, final Component component, final Component component2) {
        PrintSettings printSettings = PrintSettings.getInstance();
        final PrintRequestAttributeSet printRequestAttributeSet = printSettings.getLastPrintRequestAttributes(string);
        component2.setCursor(Cursor.getPredefinedCursor(3));
        final DocPrintJob docPrintJob = printSettings.showPrintDialog(DocFlavor.SERVICE_FORMATTED.PRINTABLE, MJFrame.getFrame((Component)component), printRequestAttributeSet);
        if (docPrintJob != null) {
            final SimpleDoc simpleDoc = new SimpleDoc(printable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, new HashDocAttributeSet());
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        docPrintJob.print(simpleDoc, printRequestAttributeSet);
                    }
                    catch (PrintException printException) {
                        if (!(printException.getCause() instanceof PrinterAbortException)) {
                            MJOptionPane.showMessageDialog((Component)MJFrame.getFrame((Component)component), (Object)(SyntaxTextPaneUtilities.intlString("errorPrinting") + "\n\n" + printException.getLocalizedMessage()), (String)SyntaxTextPaneUtilities.intlString("errorPrintingTitle"), (int)0);
                        }
                    }
                    finally {
                        component2.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }
        component2.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void showPageSetupDialog(String string) {
        PageSetupThread pageSetupThread = new PageSetupThread(string);
        Thread thread = new Thread(pageSetupThread);
        thread.start();
    }

    private static SyntaxTextPane createSyntaxTextPane(String string, Component component, boolean bl) {
        SyntaxTextPane syntaxTextPane = new SyntaxTextPane();
        syntaxTextPane.setName(component.getName());
        syntaxTextPane.getDocument().putProperty("__EndOfLine__", "\n");
        syntaxTextPane.registerEditorKit(MLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new MColorCodeKit()));
        syntaxTextPane.setContentType(MLanguage.INSTANCE.getMimeType());
        syntaxTextPane.setHighlightCaretRow(false, false);
        syntaxTextPane.enableDelimiterMatchForArrows(false, false);
        syntaxTextPane.setFont(component.getFont(), false);
        syntaxTextPane.setSyntaxHighlightingEnabled(MLanguage.INSTANCE, bl);
        syntaxTextPane.setTextColor(ColorPrefs.getTextColor(), false);
        syntaxTextPane.setBackgroundColor(ColorPrefs.getBackgroundColor(), false);
        syntaxTextPane.setText(string);
        return syntaxTextPane;
    }

    public static void printHighlightedText(String string, JComponent jComponent, Font font, String string2, String string3) {
        PrintUtils.printText(string, jComponent, font, string2, string3, true);
    }

    public static void printPlainText(String string, JComponent jComponent, Font font, String string2, String string3) {
        PrintUtils.printText(string, jComponent, font, string2, string3, false);
    }

    private static void printText(String string, JComponent jComponent, Font font, String string2, String string3, boolean bl) {
        SyntaxTextPane syntaxTextPane = PrintUtils.createSyntaxTextPane(string, jComponent, bl);
        Document document = syntaxTextPane.getDocument();
        PrintUtils.processPrint(new TextAndHeaderPrintable(document, font, PrintUtils.getMainHeader(string3), PrintUtils.getSubHeader()), string2, jComponent, jComponent);
        syntaxTextPane.cleanup();
    }

    private static MessageFormat getMainHeader(String string) {
        return new MessageFormat(string);
    }

    private static MessageFormat getSubHeader() {
        Object[] objectArray = new Object[]{new Date()};
        return new MessageFormat(MessageFormat.format(MultiHeaderUtils.getDateAndTimeHeaderText(), objectArray));
    }

    private static class TextAndHeaderPrintable
    implements Printable {
        private TextPrintable iTextPrintable;
        private MessageFormat iHeaderFormat;
        private MessageFormat iSubHeaderFormat;
        private Font iFont;
        private boolean iSetPaper;
        private PageFormat iShortPage;

        TextAndHeaderPrintable(Document document, Font font, MessageFormat messageFormat, MessageFormat messageFormat2) {
            this.iTextPrintable = new TextPrintable(document, document.getStartPosition().getOffset(), document.getEndPosition().getOffset(), null);
            this.iHeaderFormat = messageFormat;
            this.iSubHeaderFormat = messageFormat2;
            this.iFont = FontUtils.getPrinterFont((Font)font);
            this.iSetPaper = false;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setFont(this.iFont);
            if (!this.iSetPaper) {
                this.iShortPage = (PageFormat)pageFormat.clone();
                Paper paper = this.iShortPage.getPaper();
                int n2 = pageFormat.getOrientation();
                double d = n2 == 1 ? pageFormat.getImageableWidth() : pageFormat.getImageableHeight() - 40.0;
                double d2 = n2 == 1 ? pageFormat.getImageableHeight() - 40.0 : pageFormat.getImageableWidth();
                paper.setImageableArea(pageFormat.getImageableX(), pageFormat.getImageableY(), d, d2);
                this.iShortPage.setPaper(paper);
                this.iSetPaper = true;
            }
            graphics2D.translate(0, 40);
            int n3 = this.iTextPrintable.print(graphics, this.iShortPage, n);
            if (n3 == 0) {
                graphics2D.translate(0, -40);
                MultiHeaderUtils.addHeaderToGraphics(graphics2D, pageFormat, this.iHeaderFormat, this.iSubHeaderFormat, n);
            }
            return n3;
        }
    }

    private static class MColorCodeKit
    extends MKit {
        private MColorCodeKit() {
        }

        @Override
        public String getContentType() {
            return MLanguage.INSTANCE.getMimeType();
        }
    }

    private static class PageSetupThread
    implements Runnable {
        private String fTitle;

        private PageSetupThread(String string) {
            this.fTitle = string;
        }

        @Override
        public void run() {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PrintSettings printSettings = PrintSettings.getInstance();
            PrintRequestAttributeSet printRequestAttributeSet = printSettings.getLastPrintRequestAttributes(this.fTitle);
            PrintService printService = printSettings.getLastSelectedPrinter();
            try {
                if (printService != null) {
                    printerJob.setPrintService(printService);
                }
            }
            catch (PrinterException printerException) {
                JOptionPane.showMessageDialog(null, printerException, PrintUtils.getResource("printing.error.unsupported"), 0);
            }
            PageFormat pageFormat = printerJob.pageDialog(printRequestAttributeSet);
            if (pageFormat != null && printService != null) {
                printSettings.setLastSelectedPrinter(printerJob.getPrintService());
                printSettings.setLastPrintRequestAttributes(printRequestAttributeSet);
            }
        }
    }
}

