/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.tooltip;

import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import com.mathworks.mwswing.TransparentWindowFactory;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.tooltip.CalloutRectangularBalloonShape;
import com.mathworks.widgets.tooltip.MBalloonTip;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class BalloonToolTip {
    private static final boolean ALWAYS_FOCUSABLE_DEFAULT = false;
    private static final String ALWAYS_FOCUSABLE_PREFERENCE_KEY = "BalloonToolTip.alwaysFocusable";
    public static final int SUGGESTED_INSET_SPACING = 3;
    public static final List<ArrowDirection> EAST_WEST;
    public static final List<ArrowDirection> WEST_EAST;
    public static final List<ArrowDirection> NORTH_SOUTH;
    public static final List<ArrowDirection> SOUTH_NORTH;
    private static final int DEFAULT_ARROW_HEIGHT = 10;
    static final int LINE_WIDTH = 1;
    private static Rectangle sScreenBounds;
    private final CalloutRectangularBalloonShape fShape;
    private BalloonTip fTip;
    private final JDialog fDialog;
    private final Point fArrowLocation;
    private final Point fCornerBoundary;
    private final int fArrowSize;
    private final int fInsetGap;
    private boolean fDontCancel;

    public BalloonToolTip(Frame frame, Component component, List<ArrowDirection> list, Dimension dimension, Rectangle rectangle, Point point) {
        this(TransparentWindowFactory.isTransparencySupported(), component, list, TransparentWindowFactory.createTransparentDialog((Frame)frame, (boolean)false), dimension, rectangle, point, null);
    }

    public BalloonToolTip(Frame frame, Component component, List<ArrowDirection> list, Dimension dimension, Rectangle rectangle) {
        this(frame, component, list, dimension, rectangle, null);
    }

    public BalloonToolTip(Dialog dialog, Component component, List<ArrowDirection> list, Dimension dimension, Rectangle rectangle, Point point) {
        this(TransparentWindowFactory.isTransparencySupported(), component, list, TransparentWindowFactory.createTransparentDialog((Dialog)dialog, (boolean)false), dimension, rectangle, point, null);
    }

    public BalloonToolTip(Dialog dialog, Component component, List<ArrowDirection> list, Dimension dimension, Rectangle rectangle) {
        this(dialog, component, list, dimension, rectangle, null);
    }

    public BalloonToolTip(Frame frame, Component component, List<ArrowDirection> list, Dimension dimension, Rectangle rectangle, Point point, boolean bl) {
        this(TransparentWindowFactory.isTransparencySupported() || bl, component, list, TransparentWindowFactory.createTransparentDialog((Frame)frame, (boolean)bl), dimension, rectangle, point, null);
    }

    private BalloonToolTip(boolean bl, Component component, List<ArrowDirection> list, JDialog jDialog, Dimension dimension, Rectangle rectangle, Point point, BalloonTip balloonTip) {
        this.fDialog = jDialog;
        this.fDialog.setFocusableWindowState(BalloonToolTip.isAlwaysFocusable());
        this.fArrowSize = bl ? 10 : 0;
        this.fInsetGap = Math.max(this.fArrowSize, 1);
        this.fCornerBoundary = point;
        this.fShape = this.makeShape(list, component.getPreferredSize(), dimension, rectangle);
        this.fArrowLocation = this.fShape.getArrowDirection().getArrowLocation(rectangle);
        this.fTip = balloonTip != null ? balloonTip : this.createTip(component);
        this.sizeAndPlaceTip(component);
    }

    public static BalloonToolTip specialFactoryForJames(JDialog jDialog, Component component, List<ArrowDirection> list, Dimension dimension, Rectangle rectangle, BalloonTip balloonTip) {
        return new BalloonToolTip(PlatformInfo.isIntelMac() || PlatformInfo.isWindows(), component, list, jDialog, dimension, rectangle, null, balloonTip);
    }

    private MBalloonTip createTip(Component component) {
        final MBalloonTip mBalloonTip = new MBalloonTip(component);
        mBalloonTip.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                BalloonToolTip.this.popupDismissed(mBalloonTip, this);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        mBalloonTip.setShadowStyle(null);
        mBalloonTip.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return mBalloonTip;
    }

    private void popupDismissed(MBalloonTip mBalloonTip, PopupMenuListener popupMenuListener) {
        mBalloonTip.removePopupMenuListener(popupMenuListener);
        if (!this.fDontCancel) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (BalloonToolTip.this.fDialog.isVisible()) {
                        BalloonToolTip.this.cleanup();
                    }
                }
            });
        }
    }

    public Rectangle getBounds() {
        return this.fDialog.getBounds();
    }

    private CalloutRectangularBalloonShape makeShape(List<ArrowDirection> list, Dimension dimension, Dimension dimension2, Rectangle rectangle) {
        ArrowDirection arrowDirection = null;
        for (ArrowDirection arrowDirection2 : list) {
            Point point;
            CalloutRectangularBalloonShape calloutRectangularBalloonShape = new CalloutRectangularBalloonShape(arrowDirection2, this.fInsetGap, this.fArrowSize);
            Point point2 = this.getPreferredDialogLocation(calloutRectangularBalloonShape, dimension2, point = arrowDirection2.getArrowLocation(rectangle));
            if (BalloonToolTip.fitsOnSingleScreen(point2, dimension2)) {
                return calloutRectangularBalloonShape;
            }
            Point point3 = this.getPreferredDialogLocation(calloutRectangularBalloonShape, dimension, point);
            if (arrowDirection != null || !BalloonToolTip.fitsOnSingleScreen(point3, dimension)) continue;
            arrowDirection = arrowDirection2;
        }
        if (arrowDirection != null) {
            return new CalloutRectangularBalloonShape(arrowDirection, this.fInsetGap, this.fArrowSize);
        }
        return new CalloutRectangularBalloonShape(list.get(0), this.fInsetGap, this.fArrowSize);
    }

    private static boolean fitsOnSingleScreen(Point point, Dimension dimension) {
        return sScreenBounds == null ? WindowUtils.isEntirelyOnSingleScreen((Rectangle)new Rectangle(point, dimension)) : sScreenBounds.contains(point.x, point.y, dimension.width, dimension.height);
    }

    public BalloonShape getShape() {
        return this.fShape;
    }

    private Dimension getPreferredDialogSize() {
        assert (this.fTip.isShowing()) : "Only call this method if there is a valid tip";
        return this.fTip.getBalloonPreferredSize();
    }

    public void show() {
        assert (SwingUtilities.isEventDispatchThread()) : "only show the BalloonToolTip on the EDT";
        if (!BalloonToolTip.fitsOnSingleScreen(this.fDialog.getLocation(), this.fDialog.getSize())) {
            this.forceDialogToBeOnScreen();
        }
        this.fDialog.setVisible(true);
        Dimension dimension = this.fTip.getBalloonPreferredSize();
        Point point = this.getShape().getHotSpot(dimension);
        this.fTip.show((JComponent)this.fDialog.getContentPane(), point.x, point.y);
    }

    private void forceDialogToBeOnScreen() {
        if (this.fShape.getArrowDirection().equals((Object)ArrowDirection.SOUTH)) {
            double d = sScreenBounds == null ? Toolkit.getDefaultToolkit().getScreenSize().getWidth() : (double)BalloonToolTip.sScreenBounds.width;
            this.setArrowSlide((double)this.fDialog.getLocation().x / d);
        }
        WindowUtils.ensureOnSingleScreen((Window)this.fDialog);
    }

    public void setNewContent(Component component) {
        this.setNewContent(component, false);
    }

    public void setNewContent(Component component, boolean bl) {
        this.setNewContent(component, bl, true);
    }

    public void setNewContent(Component component, boolean bl, boolean bl2) {
        assert (SwingUtilities.isEventDispatchThread()) : "only update the BalloonToolTip on the EDT";
        Point point = this.fDialog.getLocation();
        int n = this.fDialog.getSize().height;
        if (!bl) {
            Dimension dimension = component.getPreferredSize();
            dimension.width = this.getContent().getPreferredSize().width;
            component.setPreferredSize(dimension);
        }
        this.fDontCancel = true;
        boolean bl3 = this.fDialog.getFocusableWindowState();
        this.fDialog.setFocusableWindowState(false);
        this.fTip.hide();
        this.fTip = this.createTip(component);
        this.setDialogSizeToFitContent();
        if (this.fShape.getArrowDirection() == ArrowDirection.NORTH || !BalloonToolTip.fitsOnSingleScreen(point, this.fDialog.getSize())) {
            point.y -= this.fDialog.getSize().height - n;
            this.fDialog.setLocation(point);
        }
        if (bl2) {
            this.show();
        }
        this.fDialog.setFocusableWindowState(bl3);
        this.fDontCancel = false;
    }

    private void sizeAndPlaceTip(Component component) {
        this.setDialogSizeToFitContent();
        Dimension dimension = component.getPreferredSize();
        this.fDialog.setLocation(this.getPreferredDialogLocation(this.fShape, dimension, this.fArrowLocation));
    }

    private void setDialogSizeToFitContent() {
        this.fTip.setBalloonShape((BalloonShape)this.fShape);
        Dimension dimension = this.fTip.getBalloonPreferredSize();
        this.fDialog.setSize(dimension);
    }

    public void setFocusableWindowState(boolean bl) {
        this.fDialog.setFocusableWindowState(bl || BalloonToolTip.isAlwaysFocusable());
    }

    public Point getPreferredDialogLocation(CalloutRectangularBalloonShape calloutRectangularBalloonShape, Dimension dimension, Point point) {
        Point point2 = calloutRectangularBalloonShape.getHotSpot(dimension);
        ArrowDirection arrowDirection = calloutRectangularBalloonShape.getArrowDirection();
        int n = point.x - (point2.x == 0 ? 0 : point2.x + arrowDirection.getInsets((int)this.fInsetGap).left);
        int n2 = point.y - (point2.y == 0 ? 0 : point2.y + arrowDirection.getInsets((int)this.fInsetGap).top);
        if (this.fCornerBoundary != null) {
            switch (arrowDirection) {
                case NORTH: 
                case SOUTH: {
                    if (n >= this.fCornerBoundary.x) break;
                    n = this.fCornerBoundary.x - 2 * this.fArrowSize - arrowDirection.getInsets((int)this.fInsetGap).left;
                    break;
                }
                case EAST: 
                case WEST: {
                    if (n2 >= this.fCornerBoundary.y) break;
                    n2 = this.fCornerBoundary.y - 2 * this.fArrowSize - arrowDirection.getInsets((int)this.fInsetGap).top;
                }
            }
        }
        return new Point(n, n2);
    }

    public void setArrowSlide(double d) {
        Component component = this.fTip.getContent();
        if (this.fTip == null) {
            this.fTip = this.createTip(component);
        }
        this.fShape.setVertexFactor(d);
        this.sizeAndPlaceTip(component);
    }

    public void hide() {
        this.fDialog.setVisible(false);
    }

    public boolean isShowing() {
        return this.fTip.isShowing();
    }

    private ArrowDirection getArrowDirection() {
        return this.fShape.getArrowDirection();
    }

    public JDialog getDialog() {
        return this.fDialog;
    }

    public Component getContent() {
        return this.fTip.getContent();
    }

    public BalloonTip getBalloon() {
        return this.fTip;
    }

    public void cleanup() {
        assert (this.fDialog != null) : "BalloonTooLTip should only be cleaned up once.";
        assert (SwingUtilities.isEventDispatchThread()) : "BalloonToolTip cleanup should only be called from the EDT";
        if (this.fTip.isVisible()) {
            this.fTip.hide();
        }
        this.fDialog.setVisible(false);
        this.fDialog.dispose();
    }

    private static void setScreenBounds(Rectangle rectangle) {
        sScreenBounds = rectangle;
    }

    private Point getArrowLocation() {
        return this.fArrowLocation;
    }

    public static void setAlwaysFocusable(boolean bl) {
        Prefs.setBooleanPref((String)ALWAYS_FOCUSABLE_PREFERENCE_KEY, (boolean)bl);
    }

    public static boolean isAlwaysFocusable() {
        return Prefs.getBooleanPref((String)ALWAYS_FOCUSABLE_PREFERENCE_KEY, (boolean)false);
    }

    static {
        ArrayList<ArrowDirection> arrayList = new ArrayList<ArrowDirection>(2);
        arrayList.add(ArrowDirection.EAST);
        arrayList.add(ArrowDirection.WEST);
        EAST_WEST = Collections.unmodifiableList(arrayList);
        ArrayList<ArrowDirection> arrayList2 = new ArrayList<ArrowDirection>(2);
        arrayList2.add(ArrowDirection.WEST);
        arrayList2.add(ArrowDirection.EAST);
        WEST_EAST = Collections.unmodifiableList(arrayList2);
        ArrayList<ArrowDirection> arrayList3 = new ArrayList<ArrowDirection>(2);
        arrayList3.add(ArrowDirection.NORTH);
        arrayList3.add(ArrowDirection.SOUTH);
        NORTH_SOUTH = Collections.unmodifiableList(arrayList3);
        ArrayList<ArrowDirection> arrayList4 = new ArrayList<ArrowDirection>(2);
        arrayList4.add(ArrowDirection.SOUTH);
        arrayList4.add(ArrowDirection.NORTH);
        SOUTH_NORTH = Collections.unmodifiableList(arrayList4);
        sScreenBounds = null;
    }

    public static enum ArrowDirection {
        NORTH{

            @Override
            public Point getArrowLocation(Rectangle rectangle) {
                int n = rectangle.y - 1;
                int n2 = rectangle.x + (int)Math.floor((double)rectangle.width * 0.5);
                return new Point(n2, n);
            }

            @Override
            public Shape getShape(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
                return new Polygon(new int[]{n, n, n + n6 - n3, n + n6, n + n6 + n3, n + n4 + 1, n + n4 + 1}, new int[]{n2, n2 + n5 + 1, n2 + n5 + 1, n2 + n5 + n3 + 1, n2 + n5 + 1, n2 + n5 + 1, n2}, 7);
            }

            @Override
            public Point getHotSpot(Dimension dimension, int n, double d) {
                int n2 = (int)((double)dimension.width * d);
                int n3 = dimension.height + this.getInsets((int)n).bottom;
                return new Point(n2, n3);
            }

            @Override
            public Insets getInsets(int n) {
                return new Insets(1, 1, n, 1);
            }
        }
        ,
        EAST{

            @Override
            public Shape getShape(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
                return new Polygon(new int[]{n, n, 0, n, n, n + n4 + 1, n + n4 + 1}, new int[]{n2, n2 + n7 - n3, n2 + n7, n2 + n7 + n3, n2 + n5 + 1, n2 + n5 + 1, n2}, 7);
            }

            @Override
            public Point getArrowLocation(Rectangle rectangle) {
                int n = rectangle.y + (int)Math.floor((double)rectangle.height * 0.5);
                int n2 = rectangle.x + rectangle.width + 1;
                return new Point(n2, n);
            }

            @Override
            public Point getHotSpot(Dimension dimension, int n, double d) {
                int n2 = (int)((double)dimension.height * d);
                int n3 = 0;
                return new Point(n3, n2);
            }

            @Override
            public Insets getInsets(int n) {
                return new Insets(1, n, 1, 1);
            }
        }
        ,
        SOUTH{

            @Override
            public Shape getShape(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
                return new Polygon(new int[]{n, n, n + n4 + 1, n + n4 + 1, n + n6 + n3, n + n6, n + n6 - n3}, new int[]{n2, n2 + n5 + 1, n2 + n5 + 1, n2, n2, 0, n2}, 7);
            }

            @Override
            public Point getArrowLocation(Rectangle rectangle) {
                int n = rectangle.x + (int)Math.floor((double)rectangle.width * 0.5);
                int n2 = rectangle.y + rectangle.height;
                return new Point(n, n2);
            }

            @Override
            public Point getHotSpot(Dimension dimension, int n, double d) {
                int n2 = (int)((double)dimension.width * d);
                int n3 = 0;
                return new Point(n2, n3);
            }

            @Override
            public Insets getInsets(int n) {
                return new Insets(n, 1, 1, 1);
            }
        }
        ,
        WEST{

            @Override
            public Shape getShape(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
                return new Polygon(new int[]{n, n, n + n4 + 1, n + n4 + 1, n + n4 + n3 + 1, n + n4 + 1, n + n4 + 1}, new int[]{n2, n2 + n5 + 1, n2 + n5 + 1, n2 + n7 + n3, n2 + n7, n2 + n7 - n3, n2}, 7);
            }

            @Override
            public Point getArrowLocation(Rectangle rectangle) {
                int n = rectangle.y + (int)Math.floor((double)rectangle.height * 0.5);
                int n2 = rectangle.x - 1;
                return new Point(n2, n);
            }

            @Override
            public Point getHotSpot(Dimension dimension, int n, double d) {
                int n2 = dimension.width + this.getInsets((int)n).right;
                int n3 = (int)((double)dimension.height * d);
                return new Point(n2, n3);
            }

            @Override
            public Insets getInsets(int n) {
                return new Insets(1, 1, 1, n);
            }
        };

        private static final int NUM_VERTICES = 7;

        public abstract Insets getInsets(int var1);

        public abstract Point getHotSpot(Dimension var1, int var2, double var3);

        public abstract Point getArrowLocation(Rectangle var1);

        public abstract Shape getShape(int var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }
}

