/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.SearchResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ListSearchResults<T>
implements SearchResults<T> {
    private final List<T> fResults = new ArrayList<T>();
    private final int fTotalResults;
    private final int fStart;

    public ListSearchResults(Collection<T> results) {
        this(results, results == null ? 0 : results.size(), 0);
    }

    public ListSearchResults(Collection<T> results, int totalResults, int start) {
        if (results != null) {
            this.fResults.addAll(results);
        }
        this.fTotalResults = totalResults;
        this.fStart = start;
    }

    @Override
    public int getFullResultCount() {
        return this.fTotalResults;
    }

    @Override
    public int getStart() {
        return this.fStart;
    }

    @Override
    public int getNumIncluded() {
        return this.fResults.size();
    }

    @Override
    public T getResult(int resultNum) {
        return this.fResults.get(resultNum - this.fStart);
    }

    @Override
    public Iterator<T> iterator() {
        return this.fResults.iterator();
    }
}

