/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.SearchField;

public class WeightedSearchField<T extends SearchField>
implements SearchField<T> {
    private SearchField<T> fField;
    private float fWeight;
    private BooleanSearchOperator fOperator;

    public WeightedSearchField(SearchField<T> field) {
        this(field, 1.0f, BooleanSearchOperator.SHOULD_OCCUR);
    }

    public WeightedSearchField(SearchField<T> field, float weight) {
        this(field, weight, BooleanSearchOperator.SHOULD_OCCUR);
    }

    public WeightedSearchField(SearchField<T> field, BooleanSearchOperator operator) {
        this(field, 1.0f, operator);
    }

    public WeightedSearchField(SearchField<T> field, float weight, BooleanSearchOperator operator) {
        this.fField = field;
        this.fWeight = weight;
        this.fOperator = operator;
    }

    @Override
    public String getFieldName() {
        return this.fField.getFieldName();
    }

    @Override
    public boolean isIndexed() {
        return this.fField.isIndexed();
    }

    @Override
    public boolean isStored() {
        return this.fField.isStored();
    }

    @Override
    public boolean isAnalyzed() {
        return this.fField.isAnalyzed();
    }

    @Override
    public float getWeight() {
        return this.fWeight;
    }

    @Override
    public BooleanSearchOperator getBooleanOperator() {
        return this.fOperator;
    }

    @Override
    public T getSearchField() {
        return this.fField.getSearchField();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.fOperator) {
            case MUST_OCCUR: {
                sb.append("+(");
                break;
            }
            case MUST_NOT_OCCUR: {
                sb.append("-(");
                break;
            }
            case SHOULD_OCCUR: {
                sb.append("(");
            }
        }
        sb.append(this.fField.toString()).append(':').append(this.fWeight).append(')');
        return sb.toString();
    }
}

