/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.TimedConnection;
import com.sun.jini.jeri.internal.http.TimedMap;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.security.AccessController;

public class ConnectionTimer {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private final TimeoutMap timeouts;

    public ConnectionTimer(long l) {
        this.timeouts = new TimeoutMap(l);
    }

    public void scheduleTimeout(TimedConnection timedConnection, boolean bl) {
        if (timedConnection == null) {
            throw new NullPointerException();
        }
        this.timeouts.put(timedConnection, new Boolean(bl));
    }

    public boolean cancelTimeout(TimedConnection timedConnection) {
        if (timedConnection == null) {
            throw new NullPointerException();
        }
        return this.timeouts.remove(timedConnection) != null;
    }

    private static class TimeoutMap
    extends TimedMap {
        TimeoutMap(long l) {
            super(systemThreadPool, l);
        }

        void evicted(Object object, Object object2) {
            boolean bl = (Boolean)object2;
            ((TimedConnection)object).shutdown(bl);
        }
    }
}

