/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.RelativeTimeConstraint;

public final class DelegationRelativeTime
implements RelativeTimeConstraint,
Serializable {
    private static final long serialVersionUID = 7148935984332761810L;
    private final long minStart;
    private final long maxStart;
    private final long minStop;
    private final long maxStop;

    public DelegationRelativeTime(long l, long l2, long l3, long l4) {
        if (l > l2 || l2 > l3 || l3 > l4 || l3 < 0L) {
            throw new IllegalArgumentException("invalid durations");
        }
        this.minStart = l;
        this.maxStart = l2;
        this.minStop = l3;
        this.maxStop = l4;
    }

    public long getMinStart() {
        return this.minStart;
    }

    public long getMaxStart() {
        return this.maxStart;
    }

    public long getMinStop() {
        return this.minStop;
    }

    public long getMaxStop() {
        return this.maxStop;
    }

    public InvocationConstraint makeAbsolute(long l) {
        return new DelegationAbsoluteTime(DelegationRelativeTime.add(this.minStart, l), DelegationRelativeTime.add(this.maxStart, l), DelegationRelativeTime.add(this.minStop, l), DelegationRelativeTime.add(this.maxStop, l));
    }

    private static long add(long l, long l2) {
        long l3 = l2 + l;
        if (l3 >= 0L && l2 < 0L && l < 0L) {
            l3 = Long.MIN_VALUE;
        } else if (l3 < 0L && l2 > 0L && l > 0L) {
            l3 = Long.MAX_VALUE;
        }
        return l3;
    }

    public int hashCode() {
        return (int)((long)DelegationRelativeTime.class.hashCode() + this.minStart + this.maxStart + this.minStop + this.maxStop);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DelegationRelativeTime)) {
            return false;
        }
        DelegationRelativeTime delegationRelativeTime = (DelegationRelativeTime)object;
        return this.minStart == delegationRelativeTime.minStart && this.maxStart == delegationRelativeTime.maxStart && this.minStop == delegationRelativeTime.minStop && this.maxStop == delegationRelativeTime.maxStop;
    }

    public String toString() {
        String string = "DelegationRelativeTime[start: ";
        string = this.minStart == this.maxStart ? string + this.minStart + ", stop: " : string + "[" + this.minStart + ", " + this.maxStart + "], stop: ";
        string = this.minStop == this.maxStop ? string + this.minStop + "]" : string + "[" + this.minStop + ", " + this.maxStop + "]]";
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.minStart > this.maxStart || this.maxStart > this.minStop || this.minStop > this.maxStop || this.minStop < 0L) {
            throw new InvalidObjectException("invalid durations");
        }
    }
}

