/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.plaf.metal.MetalLookAndFeel;

class MetalIcons
implements Serializable {
    private static Icon blueFolderIcon;
    private static Icon blueFileIcon;
    private static Icon orangeFolderIcon;
    private static Icon orangeFileIcon;
    private static Icon grayFolderIcon;
    private static Icon grayFileIcon;
    private static Icon unusableFolderIcon;
    private static Icon unusableFileIcon;
    private static Color orangeDarkShadowColor;
    private static Color orangeColor;
    private static Color orangeShadowColor;
    private static Color orangeInfoColor;
    private static Color orangeHighlightColor;
    private static Color grayDarkShadowColor;
    private static Color grayColor;
    private static Color grayShadowColor;
    private static Color grayInfoColor;
    private static Color grayHighlightColor;
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;
    private static final Dimension folderIcon16Size;
    private static final Dimension fileIcon16Size;

    MetalIcons() {
    }

    public static Icon getBlueFolderIcon() {
        if (blueFolderIcon == null) {
            blueFolderIcon = new BlueFolderIcon();
        }
        return blueFolderIcon;
    }

    public static Icon getBlueFileIcon() {
        if (blueFileIcon == null) {
            blueFileIcon = new BlueFileIcon();
        }
        return blueFileIcon;
    }

    public static Icon getOrangeFolderIcon() {
        if (orangeFolderIcon == null) {
            orangeFolderIcon = new OrangeFolderIcon();
        }
        return orangeFolderIcon;
    }

    public static Icon getOrangeFileIcon() {
        if (orangeFileIcon == null) {
            orangeFileIcon = new OrangeFileIcon();
        }
        return orangeFileIcon;
    }

    public static Icon getGrayFolderIcon() {
        if (grayFolderIcon == null) {
            grayFolderIcon = new GrayFolderIcon();
        }
        return grayFolderIcon;
    }

    public static Icon getGrayFileIcon() {
        if (grayFileIcon == null) {
            grayFileIcon = new GrayFileIcon();
        }
        return grayFileIcon;
    }

    public static Icon getUnusableFolderIcon() {
        if (unusableFolderIcon == null) {
            unusableFolderIcon = new UnusableFolderIcon();
        }
        return unusableFolderIcon;
    }

    public static Icon getUnusableFileIcon() {
        if (unusableFileIcon == null) {
            unusableFileIcon = new UnusableFileIcon();
        }
        return unusableFileIcon;
    }

    static {
        orangeDarkShadowColor = new Color(204, 153, 102);
        orangeColor = new Color(255, 153, 51);
        orangeShadowColor = new Color(204, 153, 102);
        orangeInfoColor = new Color(153, 0, 51);
        orangeHighlightColor = new Color(255, 255, 51);
        grayDarkShadowColor = new Color(153, 153, 153);
        grayColor = new Color(187, 187, 187);
        grayShadowColor = new Color(170, 170, 170);
        grayInfoColor = new Color(136, 136, 136);
        grayHighlightColor = new Color(221, 221, 221);
        folderIcon16Size = new Dimension(16, 16);
        fileIcon16Size = new Dimension(16, 16);
    }

    static class TreeLeafIcon
    extends FileIcon16 {
        TreeLeafIcon() {
        }

        public int getShift() {
            return 2;
        }

        public int getAdditionalHeight() {
            return 4;
        }
    }

    private static abstract class FileIcon16
    implements Serializable {
        private FileIcon16() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2, Color color, Color color2, Color color3) {
            graphics.translate(n, n2 + this.getShift());
            int n3 = fileIcon16Size.width - 1;
            int n4 = fileIcon16Size.height - 1;
            graphics.setColor(color);
            graphics.fillRect(4, 2, 9, 12);
            graphics.setColor(color2);
            graphics.drawLine(2, 0, 2, n4);
            graphics.drawLine(2, 0, n3 - 4, 0);
            graphics.drawLine(2, n4, n3 - 1, n4);
            graphics.drawLine(n3 - 1, 6, n3 - 1, n4);
            graphics.drawLine(n3 - 6, 2, n3 - 2, 6);
            graphics.drawLine(n3 - 5, 1, n3 - 4, 1);
            graphics.drawLine(n3 - 3, 2, n3 - 3, 3);
            graphics.drawLine(n3 - 2, 4, n3 - 2, 5);
            graphics.setColor(color3);
            graphics.drawLine(3, 1, 3, n4 - 1);
            graphics.drawLine(3, 1, n3 - 6, 1);
            graphics.drawLine(n3 - 2, 7, n3 - 2, n4 - 1);
            graphics.drawLine(n3 - 5, 2, n3 - 3, 4);
            graphics.drawLine(3, n4 - 1, n3 - 2, n4 - 1);
            graphics.translate(-n, -(n2 + this.getShift()));
        }

        public void drawCross(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2 + this.getShift());
            int n3 = folderIcon16Size.width - 1;
            int n4 = folderIcon16Size.height - 1;
            Color color = Color.red;
            graphics.setColor(color);
            graphics.drawLine(1, 1, n3 - 1, n4 - 1);
            graphics.drawLine(1, n4 - 1, n3 - 1, 1);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return fileIcon16Size.width;
        }

        public int getIconHeight() {
            return fileIcon16Size.height + this.getAdditionalHeight();
        }
    }

    static class UnusableFileIcon
    extends FileIcon16
    implements Icon {
        UnusableFileIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2, grayHighlightColor, grayInfoColor, grayColor);
            super.drawCross(component, graphics, n, n2);
        }

        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class GrayFileIcon
    extends FileIcon16
    implements Icon {
        GrayFileIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2, grayHighlightColor, grayInfoColor, grayColor);
        }

        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class OrangeFileIcon
    extends FileIcon16
    implements Icon {
        OrangeFileIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2, orangeHighlightColor, orangeInfoColor, orangeColor);
        }

        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class BlueFileIcon
    extends FileIcon16
    implements Icon {
        BlueFileIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControl());
        }

        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    private static abstract class FolderIcon16
    implements Serializable {
        private FolderIcon16() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2, Color color, Color color2, Color color3, Color color4, Color color5) {
            graphics.translate(n, n2 + this.getShift());
            int n3 = folderIcon16Size.width - 1;
            int n4 = folderIcon16Size.height - 1;
            graphics.setColor(color);
            graphics.drawLine(n3 - 5, 3, n3, 3);
            graphics.drawLine(n3 - 6, 4, n3, 4);
            graphics.setColor(color2);
            graphics.fillRect(2, 7, 13, 8);
            graphics.setColor(color3);
            graphics.drawLine(n3 - 6, 5, n3 - 1, 5);
            graphics.setColor(color4);
            graphics.drawLine(0, 6, 0, n4);
            graphics.drawLine(1, 5, n3 - 7, 5);
            graphics.drawLine(n3 - 6, 6, n3 - 1, 6);
            graphics.drawLine(n3, 5, n3, n4);
            graphics.drawLine(0, n4, n3, n4);
            graphics.setColor(color5);
            graphics.drawLine(1, 6, 1, n4 - 1);
            graphics.drawLine(1, 6, n3 - 7, 6);
            graphics.drawLine(n3 - 6, 7, n3 - 1, 7);
            graphics.translate(-n, -(n2 + this.getShift()));
        }

        public void drawCross(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2 + this.getShift());
            int n3 = folderIcon16Size.width - 1;
            int n4 = folderIcon16Size.height - 1;
            Color color = Color.red;
            graphics.setColor(color);
            graphics.drawLine(2, 2, n3, n4);
            graphics.drawLine(2, n4, n3, 2);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return folderIcon16Size.width;
        }

        public int getIconHeight() {
            return folderIcon16Size.height + this.getAdditionalHeight();
        }
    }

    static class UnusableFolderIcon
    extends FolderIcon16
    implements Icon {
        UnusableFolderIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2, grayDarkShadowColor, grayColor, grayShadowColor, grayInfoColor, grayHighlightColor);
            super.drawCross(component, graphics, n, n2);
        }

        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class GrayFolderIcon
    extends FolderIcon16
    implements Icon {
        GrayFolderIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2, grayDarkShadowColor, grayColor, grayShadowColor, grayInfoColor, grayHighlightColor);
        }

        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class OrangeFolderIcon
    extends FolderIcon16
    implements Icon {
        OrangeFolderIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2, orangeDarkShadowColor, orangeColor, orangeShadowColor, orangeInfoColor, orangeHighlightColor);
        }

        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    static class BlueFolderIcon
    extends FolderIcon16
    implements Icon {
        BlueFolderIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2, MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControl(), MetalLookAndFeel.getPrimaryControlShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight());
        }

        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }
}

