/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.assistedinject;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.ImmutableList;
import com.google.inject.internal.ImmutableMap;
import com.google.inject.internal.Iterables;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Preconditions;
import com.google.inject.spi.Message;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FactoryProvider2<F>
implements InvocationHandler,
Provider<F> {
    static final Assisted DEFAULT_ANNOTATION = new Assisted(){

        @Override
        public String value() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Assisted.class;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Assisted && ((Assisted)o).value().equals("");
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ "".hashCode();
        }

        @Override
        public String toString() {
            return "@" + Assisted.class.getName() + "(value=)";
        }
    };
    private final Key<?> producedType;
    private final ImmutableMap<Method, Key<?>> returnTypesByMethod;
    private final ImmutableMap<Method, ImmutableList<Key<?>>> paramTypes;
    private Injector injector;
    private final F factory;

    FactoryProvider2(TypeLiteral<F> factoryType, Key<?> producedType) {
        this.producedType = producedType;
        Errors errors = new Errors();
        Class factoryRawType = factoryType.getRawType();
        try {
            ImmutableMap.Builder returnTypesBuilder = ImmutableMap.builder();
            ImmutableMap.Builder paramTypesBuilder = ImmutableMap.builder();
            for (Method method : factoryRawType.getMethods()) {
                Key returnType = Annotations.getKey((TypeLiteral)factoryType.getReturnType(method), (Member)method, (Annotation[])method.getAnnotations(), (Errors)errors);
                returnTypesBuilder.put((Object)method, (Object)returnType);
                List params = factoryType.getParameterTypes((Member)method);
                Annotation[][] paramAnnotations = method.getParameterAnnotations();
                int p = 0;
                ArrayList keys = Lists.newArrayList();
                for (TypeLiteral param : params) {
                    Key paramKey = Annotations.getKey((TypeLiteral)param, (Member)method, (Annotation[])paramAnnotations[p++], (Errors)errors);
                    keys.add(this.assistKey(method, paramKey, errors));
                }
                paramTypesBuilder.put((Object)method, (Object)ImmutableList.copyOf((Iterable)keys));
            }
            this.returnTypesByMethod = returnTypesBuilder.build();
            this.paramTypes = paramTypesBuilder.build();
        }
        catch (ErrorsException e) {
            throw new ConfigurationException((Iterable)e.getErrors().getMessages());
        }
        this.factory = factoryRawType.cast(Proxy.newProxyInstance(factoryRawType.getClassLoader(), new Class[]{factoryRawType}, (InvocationHandler)this));
    }

    public F get() {
        return this.factory;
    }

    private <T> Key<T> assistKey(Method method, Key<T> key, Errors errors) throws ErrorsException {
        if (key.getAnnotationType() == null) {
            return Key.get((TypeLiteral)key.getTypeLiteral(), (Annotation)DEFAULT_ANNOTATION);
        }
        if (key.getAnnotationType() == Assisted.class) {
            return key;
        }
        errors.withSource((Object)method).addMessage("Only @Assisted is allowed for factory parameters, but found @%s", new Object[]{key.getAnnotationType()});
        throw errors.toException();
    }

    @Inject
    void initialize(Injector injector) {
        if (this.injector != null) {
            throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message(FactoryProvider2.class, "Factories.create() factories may only be used in one Injector!")));
        }
        this.injector = injector;
        for (Method method : this.returnTypesByMethod.keySet()) {
            Object[] args = new Object[method.getParameterTypes().length];
            Arrays.fill(args, "dummy object for validating Factories");
            this.getBindingFromNewInjector(method, args);
        }
    }

    public Binding<?> getBindingFromNewInjector(final Method method, final Object[] args) {
        Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"Factories.create() factories cannot be used until they're initialized by Guice.");
        final Key returnType = (Key)this.returnTypesByMethod.get((Object)method);
        AbstractModule assistedModule = new AbstractModule(){

            protected void configure() {
                Binder binder = this.binder().withSource((Object)method);
                int p = 0;
                for (Key paramKey : (ImmutableList)FactoryProvider2.this.paramTypes.get((Object)method)) {
                    binder.bind(paramKey).toProvider(Providers.of((Object)args[p++]));
                }
                if (FactoryProvider2.this.producedType != null && !returnType.equals((Object)FactoryProvider2.this.producedType)) {
                    binder.bind(returnType).to(FactoryProvider2.this.producedType);
                } else {
                    binder.bind(returnType);
                }
            }
        };
        Injector forCreate = this.injector.createChildInjector(new Module[]{assistedModule});
        return forCreate.getBinding(returnType);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        Provider provider = this.getBindingFromNewInjector(method, args).getProvider();
        try {
            return provider.get();
        }
        catch (ProvisionException e) {
            Message onlyError;
            Throwable cause;
            if (e.getErrorMessages().size() == 1 && (cause = (onlyError = (Message)Iterables.getOnlyElement((Iterable)e.getErrorMessages())).getCause()) != null && FactoryProvider2.canRethrow(method, cause)) {
                throw cause;
            }
            throw e;
        }
    }

    public String toString() {
        return this.factory.getClass().getInterfaces()[0].getName() + " for " + this.producedType.getTypeLiteral();
    }

    public boolean equals(Object o) {
        return o == this || o == this.factory;
    }

    static boolean canRethrow(Method invoked, Throwable thrown) {
        if (thrown instanceof Error || thrown instanceof RuntimeException) {
            return true;
        }
        for (Class<?> declared : invoked.getExceptionTypes()) {
            if (!declared.isInstance(thrown)) continue;
            return true;
        }
        return false;
    }
}

