/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.ProjectComponentWithSelection;
import com.mathworks.project.api.SectionComponentWithPropertySupport;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.SectionPanel;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.FileSetEditorGroup;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectSectionDefinition;
import com.mathworks.project.impl.settingsui.ParamSetPanel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class SectionedProjectTab
implements ProjectComponent {
    private final SectionPanel fPanel;
    private final FileSetEditorGroup fFileSetGroup = new FileSetEditorGroup();
    private final PropertyChangeListener fHeaderChangeListener;
    private final List<ProjectComponent> fCustomComponents;
    private final Map<ProjectComponent, String> fCustomComponentSectionKeys;

    public SectionedProjectTab(Project project, List<ProjectSectionDefinition> list) {
        this(project, list, false);
    }

    public SectionedProjectTab(Project project, List<ProjectSectionDefinition> list, boolean bl) {
        this.fPanel = new SectionPanel(bl, project.getConfiguration());
        this.fCustomComponents = new ArrayList<ProjectComponent>();
        this.fCustomComponentSectionKeys = new HashMap<ProjectComponent, String>();
        this.fHeaderChangeListener = new PropertyChangeListener(){

            private String getSectionKey(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() instanceof FileSetEditor) {
                    return ((FileSetEditor)propertyChangeEvent.getSource()).getFileSet().getDefinition().getKey();
                }
                if (!(propertyChangeEvent.getSource() instanceof ProjectComponent) || !SectionedProjectTab.this.fCustomComponentSectionKeys.containsKey((ProjectComponent)propertyChangeEvent.getSource())) {
                    throw new IllegalStateException("Custom ProjectComponent fired a PropertyChangeEvent with unrecognized source; be sure to pass 'this' to the PropertyChangeSupport constructor.");
                }
                return (String)SectionedProjectTab.this.fCustomComponentSectionKeys.get((ProjectComponent)propertyChangeEvent.getSource());
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = this.getSectionKey(propertyChangeEvent);
                if (propertyChangeEvent.getPropertyName().equals("header-text")) {
                    SectionedProjectTab.this.fPanel.setDisplayName(string, (String)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getPropertyName().equals("header-tooltip")) {
                    SectionedProjectTab.this.fPanel.setToolTip(string, (String)propertyChangeEvent.getNewValue());
                }
            }
        };
        String string = project.getConfiguration().getTarget().getHelpMapPath();
        for (ProjectSectionDefinition projectSectionDefinition : list) {
            Object object;
            Object object2;
            if (projectSectionDefinition.getImplementationClassName() != null) {
                try {
                    object2 = Class.forName(projectSectionDefinition.getImplementationClassName());
                    object = ((Class)object2).getConstructor(WritableConfiguration.class);
                    ProjectComponent projectComponent = (ProjectComponent)((Constructor)object).newInstance(project.getConfiguration());
                    this.fCustomComponents.add(projectComponent);
                    this.fCustomComponentSectionKeys.put(projectComponent, projectSectionDefinition.getKey());
                    this.fPanel.addSection(projectSectionDefinition.getKey(), projectSectionDefinition.getName(), string, projectSectionDefinition.getHelpKey(), projectComponent instanceof FileSetEditor ? (FileSetEditor)projectComponent : null, projectComponent.getComponent());
                    if (projectComponent instanceof ProjectComponentWithSelection) {
                        this.fFileSetGroup.addPeer((ProjectComponentWithSelection)projectComponent);
                    }
                    if (!(projectComponent instanceof SectionComponentWithPropertySupport)) continue;
                    ((SectionComponentWithPropertySupport)projectComponent).addPropertyChangeListener(this.fHeaderChangeListener);
                    this.fPanel.setToolTip(projectSectionDefinition.getKey(), ((SectionComponentWithPropertySupport)projectComponent).getHeaderToolTipText());
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
            if (projectSectionDefinition.getFileSetKey() != null) {
                object2 = project.getConfiguration().getFileSet(projectSectionDefinition.getFileSetKey());
                object = new FileSetEditor(project, (FileSetInstance)object2, this.fFileSetGroup, true, projectSectionDefinition.showLinks());
                this.fPanel.addSection(projectSectionDefinition.getFileSetKey(), ((FileSetEditor)object).getHeaderText(), string, projectSectionDefinition.getHelpKey() != null ? projectSectionDefinition.getHelpKey() : ((FileSetInstance)object2).getDefinition().getHelpKey(), (FileSetEditor)object, ((FileSetEditor)object).getComponent());
                this.fPanel.setToolTip(projectSectionDefinition.getFileSetKey(), ((FileSetEditor)object).getHeaderToolTipText());
                ((FileSetEditor)object).addPropertyChangeListener(this.fHeaderChangeListener);
                continue;
            }
            if (projectSectionDefinition.getParamSetKey() != null) {
                object2 = project.getConfiguration().getTarget().getParamSet(projectSectionDefinition.getParamSetKey());
                object = new ParamSetPanel(project, (ParamSet)object2, true, true, projectSectionDefinition.getParamKeys());
                this.fPanel.addSection(((ParamSet)object2).getKey(), ((ParamSet)object2).getName(), string, projectSectionDefinition.getHelpKey() != null ? projectSectionDefinition.getHelpKey() : ((ParamSet)object2).getHelpTopicKey(), null, ((ParamSetPanel)object).getComponent());
                this.fCustomComponents.add((ProjectComponent)object);
                continue;
            }
            object2 = ParamSetPanel.create(project, projectSectionDefinition.getParamKeys());
            this.fPanel.addSection(projectSectionDefinition.getKey(), projectSectionDefinition.getName(), string, projectSectionDefinition.getHelpKey(), null, ((ParamSetPanel)object2).getComponent());
            this.fCustomComponents.add((ProjectComponent)object2);
        }
    }

    public void addSectionWithoutHeader(Component component) {
        this.fPanel.addSection("__" + component.toString(), null, null, null, null, component);
    }

    public JComponent getComponent() {
        return this.fPanel.getComponent();
    }

    public void dispose() {
        for (FileSetEditor fileSetEditor : this.fFileSetGroup.getEditors()) {
            fileSetEditor.removePropertyChangeListener(this.fHeaderChangeListener);
            fileSetEditor.dispose();
        }
        this.fFileSetGroup.removeAll();
        this.fFileSetGroup.destroy();
        for (ProjectComponent projectComponent : this.fCustomComponents) {
            if (projectComponent instanceof SectionComponentWithPropertySupport) {
                ((SectionComponentWithPropertySupport)projectComponent).removePropertyChangeListener(this.fHeaderChangeListener);
            }
            projectComponent.dispose();
        }
        this.fPanel.dispose();
    }

    public FileSetEditorGroup getFileSetGroup() {
        return this.fFileSetGroup;
    }

    public FileSetEditor getFileSetEditor(String string) {
        for (FileSetEditor fileSetEditor : this.fFileSetGroup.getEditors()) {
            if (!fileSetEditor.getFileSet().getDefinition().getKey().equals(string)) continue;
            return fileSetEditor;
        }
        return null;
    }

    public FileSetEditor getLastEditor() {
        List<FileSetEditor> list = this.fFileSetGroup.getEditors();
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }
}

