/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.settingsui.DefaultSettingsPanelBuilder;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.project.impl.settingsui.SettingComponentDefinition;
import com.mathworks.project.impl.settingsui.SettingsPanelBuilder;
import com.mathworks.project.impl.settingsui.SettingsPanelBuilderFactory;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.tree.TreeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public final class ParamSetPanel
implements ProjectComponent {
    private final Project fProject;
    private final ParamSet fSet;
    private Component fComponent;
    private final List<PanelComponent> fPanelComponents;
    private final List<ProjectComponent> fBatchComponents;
    private final ParameterRunnable<ProjectComponent> fBatchComponentRegistry;
    private final PropertyChangeListener fConfigurationListener;
    private final boolean fForceDefaultBuilder;
    private final ParamWidgetBinder fWidgetBinder;
    private int fStringGroupCount;
    private boolean fSuppressBottomPadding;
    private static final String UNNAMED_PARAM_SET_KEY = "__unnamed";

    public static ParamSetPanel create(Project project, List<String> list) {
        return ParamSetPanel.create(project, list, true, true);
    }

    public static ParamSetPanel create(Project project, List<String> list, boolean bl, boolean bl2) {
        Target target = project.getConfiguration().getTarget();
        ArrayList<Param> arrayList = new ArrayList<Param>();
        HashMap<Param, String> hashMap = new HashMap<Param, String>();
        HashMap<Param, Set<Param>> hashMap2 = new HashMap<Param, Set<Param>>();
        HashMap<String, Param> hashMap3 = new HashMap<String, Param>();
        HashMap<Param, ParamSet> hashMap4 = new HashMap<Param, ParamSet>();
        for (ParamSet object : target.getParamSets()) {
            for (Param param : object.getParams()) {
                hashMap3.put(param.getKey(), param);
                hashMap4.put(param, object);
            }
        }
        for (String string : list) {
            Param param = (Param)hashMap3.get(string);
            if (param == null) {
                throw new IllegalArgumentException("Unrecognized param key: '" + string + "'");
            }
            arrayList.add(param);
            Set<Param> set = ((ParamSet)hashMap4.get(param)).getStringGroup(param);
            if (set == null) continue;
            hashMap2.put(param, set);
        }
        ParamSet paramSet = new ParamSet(UNNAMED_PARAM_SET_KEY, UNNAMED_PARAM_SET_KEY, "", null, null, null, null, arrayList, hashMap, new HashMap<Param, String>(), hashMap2, new HashSet<String>());
        return new ParamSetPanel(project, paramSet, bl, bl2);
    }

    public ParamSetPanel(Project project, ParamSet paramSet, boolean bl, boolean bl2) {
        this(project, paramSet, bl, bl2, new ArrayList<String>(0));
    }

    public ParamSetPanel(Project project, ParamSet paramSet, boolean bl, boolean bl2, List<String> list) {
        this.fProject = project;
        this.fSet = paramSet;
        this.fWidgetBinder = new ParamWidgetBinder(this.fProject, bl);
        this.fPanelComponents = new ArrayList<PanelComponent>();
        this.fBatchComponents = new ArrayList<ProjectComponent>();
        this.fForceDefaultBuilder = bl2;
        this.fBatchComponentRegistry = new ParameterRunnable<ProjectComponent>(){

            public void run(ProjectComponent projectComponent) {
                ParamSetPanel.this.fBatchComponents.add(projectComponent);
            }
        };
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Param param;
                if (Configuration.isParamVisibilityChange(propertyChangeEvent) && (param = ParamSetPanel.this.fProject.getConfiguration().getParamWithAffectedState(propertyChangeEvent)) != null) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            for (PanelComponent panelComponent : ParamSetPanel.this.fPanelComponents) {
                                if (!panelComponent.hasParam(param)) continue;
                                panelComponent.rebuildAndFocusSoon();
                            }
                        }
                    });
                }
            }
        };
        this.fProject.addPropertyChangeListener(this.fConfigurationListener);
        if (paramSet.getPanelClassName() != null) {
            try {
                Class<?> clazz = Class.forName(paramSet.getPanelClassName());
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    Class<?>[] classArray = constructor.getParameterTypes();
                    if (classArray.length != 1 || classArray[0] != ReadableConfiguration.class && classArray[0] != WritableConfiguration.class) continue;
                    ProjectComponent projectComponent = (ProjectComponent)constructor.newInstance(this.fProject.getConfiguration());
                    this.fBatchComponents.add(projectComponent);
                    this.fComponent = projectComponent.getComponent();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Could not instantiate custom param-set panel: " + paramSet.getPanelClassName() + ". Please make sure it is public and has a public constructor with the appropriate argument type.", illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("Custom param-set panel does not exist: " + paramSet.getPanelClassName(), classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalStateException("Could not instantiate custom param-set panel: " + paramSet.getPanelClassName() + ". Please make sure it is public and has a public constructor with the appropriate argument type.", instantiationException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException("Constructor threw exception for custom param-set panel: " + paramSet.getPanelClassName(), invocationTargetException.getTargetException());
            }
        } else {
            Map<String, List<Param>> map = paramSet.getSubsets();
            this.fComponent = map == null ? new PanelComponent(bl, ParamSetPanel.filterParams(this.fProject.getConfiguration().getTarget(), this.fSet.getParams(), list)) : this.layoutSubsetSelectionPanel(map, list);
        }
    }

    public void setSuppressBottomPadding(boolean bl) {
        this.fSuppressBottomPadding = bl;
        for (PanelComponent panelComponent : this.fPanelComponents) {
            panelComponent.rebuild();
            panelComponent.requestFocus();
        }
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ParamSetPanel.this.fWidgetBinder.dispose();
                ParamSetPanel.this.fProject.removePropertyChangeListener(ParamSetPanel.this.fConfigurationListener);
                for (ProjectComponent projectComponent : ParamSetPanel.this.fBatchComponents) {
                    projectComponent.dispose();
                }
                ParamSetPanel.this.fBatchComponents.clear();
            }
        });
    }

    public ParamSet getParamSet() {
        return this.fSet;
    }

    private MJPanel layoutSubsetSelectionPanel(Map<String, List<Param>> map, List<String> list) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("3dlu, d, 3dlu, fill:d:grow, 3dlu", "3dlu, fill:d:grow, 3dlu"));
        mJPanel.setOpaque(false);
        final MJList mJList = new MJList(map.keySet().toArray());
        final LinkedHashMap<String, PanelComponent> linkedHashMap = new LinkedHashMap<String, PanelComponent>();
        CellConstraints cellConstraints = new CellConstraints();
        for (String string : map.keySet()) {
            linkedHashMap.put(string, new PanelComponent(true, ParamSetPanel.filterParams(this.fProject.getConfiguration().getTarget(), map.get(string), list)));
        }
        Iterator<String> iterator = new MJPanel(new BorderLayout(0, 0)){

            public Dimension getPreferredSize() {
                MJPanel mJPanel = (MJPanel)linkedHashMap.get(mJList.getSelectedValue());
                if (mJPanel == null) {
                    return super.getPreferredSize();
                }
                return mJPanel.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        iterator.setOpaque(false);
        mJList.addListSelectionListener(new ListSelectionListener((MJPanel)iterator, linkedHashMap, mJList){
            final /* synthetic */ MJPanel val$subsetContainer;
            final /* synthetic */ Map val$subsetPanels;
            final /* synthetic */ MJList val$subsetList;
            {
                this.val$subsetContainer = mJPanel;
                this.val$subsetPanels = map;
                this.val$subsetList = mJList;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.val$subsetContainer.removeAll();
                this.val$subsetContainer.add((Component)this.val$subsetPanels.get(this.val$subsetList.getSelectedValue()));
                this.val$subsetContainer.revalidate();
                this.val$subsetContainer.repaint();
            }
        });
        iterator.add((Component)linkedHashMap.values().iterator().next());
        mJPanel.add((Component)new MJScrollPane((Component)mJList), (Object)cellConstraints.xy(2, 2));
        mJPanel.add(iterator, (Object)cellConstraints.xy(4, 2));
        mJList.setSelectedIndex(0);
        return mJPanel;
    }

    private MJPanel layoutStringGroupPanel(Set<Param> set) {
        Param param2;
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("fill:d, 3dlu, fill:d:grow", "fill:d, 3dlu, fill:d:grow"));
        final MJComboBox mJComboBox = new MJComboBox();
        for (Param param2 : set) {
            mJComboBox.addItem((Object)param2);
        }
        mJComboBox.setName("selector.stringgroup." + ++this.fStringGroupCount);
        final MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        param2 = new MJLabel();
        ItemListener itemListener = new ItemListener((MJLabel)param2){
            final /* synthetic */ MJLabel val$selectorLabel;
            {
                this.val$selectorLabel = mJLabel;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Param param = (Param)mJComboBox.getSelectedItem();
                Component component = ParamSetPanel.this.fWidgetBinder.get(param).getComponent();
                mJPanel2.removeAll();
                mJPanel2.revalidate();
                mJPanel2.repaint();
                mJPanel2.add(component);
                JTextComponent jTextComponent = (JTextComponent)TreeUtils.findComponent((Component)component, JTextComponent.class);
                if (jTextComponent != null) {
                    jTextComponent.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                }
                if (param.getDescription() != null) {
                    this.val$selectorLabel.setText("(" + param.getDescription() + ")");
                } else {
                    this.val$selectorLabel.setText("");
                }
                if (ParamSetPanel.this.fComponent != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ParamSetPanel.this.fComponent instanceof JComponent) {
                                ((JComponent)ParamSetPanel.this.fComponent).revalidate();
                            }
                            ParamSetPanel.this.fComponent.repaint();
                        }
                    });
                }
            }
        };
        mJComboBox.addItemListener(itemListener);
        itemListener.itemStateChanged(null);
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.setOpaque(false);
        mJPanel.add((Component)mJComboBox, (Object)cellConstraints.xy(1, 1));
        mJPanel.add((Component)((Object)param2), (Object)cellConstraints.xy(3, 1));
        mJPanel.add((Component)mJPanel2, (Object)cellConstraints.xyw(1, 3, 3));
        return mJPanel;
    }

    private static List<Param> filterParams(Target target, List<Param> list, List<String> list2) {
        if (list2 == null || list2.isEmpty()) {
            return list;
        }
        ArrayList<Param> arrayList = new ArrayList<Param>();
        for (String string : list2) {
            Param param = target.getParam(string);
            if (!list.contains(param)) continue;
            arrayList.add(param);
        }
        return arrayList;
    }

    private class PanelComponent
    extends MJPanel
    implements Scrollable {
        private final List<Param> iParams;
        private final boolean iInline;
        private final RequestFilter iRebuild;
        private Component iFirstComponent;
        private Integer fBlockIncrement;
        private Integer fUnitIncrement;

        PanelComponent(boolean bl, List<Param> list) {
            this.setLayout(new BorderLayout(0, 0));
            this.setOpaque(false);
            this.iInline = bl;
            this.iParams = new ArrayList<Param>(list);
            this.iRebuild = new RequestFilter(new Runnable(){

                @Override
                public void run() {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PanelComponent.this.rebuild();
                            PanelComponent.this.requestFocus();
                        }
                    });
                }
            }, 250);
            ParamSetPanel.this.fPanelComponents.add(this);
            this.rebuild();
        }

        public void requestFocus() {
            if (this.iFirstComponent != null) {
                this.iFirstComponent.requestFocus();
            }
        }

        boolean hasParam(Param param) {
            return this.iParams.contains(param);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            if (this.fUnitIncrement == null) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                this.fUnitIncrement = fontMetrics.getAscent() + fontMetrics.getDescent();
            }
            return this.fUnitIncrement;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            if (this.fBlockIncrement == null) {
                this.fBlockIncrement = rectangle.height - this.getScrollableUnitIncrement(rectangle, n, n2);
            }
            return this.fBlockIncrement;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        void rebuildAndFocusSoon() {
            this.iRebuild.request();
        }

        void rebuild() {
            Object object;
            ParamSetPanel.this.fStringGroupCount = 0;
            this.removeAll();
            SettingsPanelBuilder settingsPanelBuilder = ParamSetPanel.this.fForceDefaultBuilder ? new DefaultSettingsPanelBuilder(this.iInline) : SettingsPanelBuilderFactory.createSettingsPanelBuilder(ParamSetPanel.this.fProject, this.iInline, (ParameterRunnable<ProjectComponent>)ParamSetPanel.this.fBatchComponentRegistry);
            ArrayList<Param> arrayList = new ArrayList<Param>(this.iParams);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (ParamSetPanel.this.fProject.getConfiguration().isParamVisible(((Param)iterator.next()).getKey())) continue;
                iterator.remove();
            }
            boolean bl = true;
            for (Param object2 : arrayList) {
                if (ParamSetPanel.this.fWidgetBinder.hasWidget(object2)) continue;
                Component component = ParamSetPanel.this.fWidgetBinder.createAndRegister(object2);
                if (object2.getType() == ParamType.ENUM && this.iInline && (object = (JComboBox)TreeUtils.findComponent((Component)component, JComboBox.class)) != null) {
                    ((JComponent)object).setMinimumSize(new Dimension(0, 0));
                    ((JComponent)object).setPreferredSize(new Dimension(10, (int)((JComponent)object).getPreferredSize().getHeight()));
                }
                if ((object = TreeUtils.findComponent((Component)component, JScrollPane.class)) == null || TreeUtils.findComponent((Component)component, JTextArea.class) != null || TreeUtils.findComponent((Component)component, JEditorPane.class) != null) continue;
                bl = false;
            }
            HashSet hashSet = new HashSet();
            for (Param param : arrayList) {
                object = ParamSetPanel.this.fWidgetBinder.get(param);
                if (object.getComponent().getParent() != null) {
                    object.getComponent().getParent().remove(object.getComponent());
                }
                boolean bl2 = true;
                if (!ParamSetPanel.this.fProject.getConfiguration().isParamEnabled(param.getKey())) {
                    bl2 = false;
                    object.setEnabled(false);
                }
                if (bl2 && (this.iFirstComponent == null || object.getComponent().hasFocus())) {
                    this.iFirstComponent = object.getComponent();
                }
                ParamSetPanel.this.fWidgetBinder.register(param, (ParamWidget)object);
                String string = ParamSetPanel.this.fSet.getCategoryName(param);
                Set<Param> set = ParamSetPanel.this.fSet.getStringGroup(param);
                if (set != null && hashSet.contains(set)) continue;
                if (string == null ^ settingsPanelBuilder.getCurrentCategoryName() == null || string != null && !settingsPanelBuilder.getCurrentCategoryName().equals(string)) {
                    if (string != null) {
                        settingsPanelBuilder.startCategory(string);
                    } else {
                        settingsPanelBuilder.endCategory();
                    }
                }
                if (set != null) {
                    settingsPanelBuilder.addComponent((Component)ParamSetPanel.this.layoutStringGroupPanel(set), false);
                    hashSet.add(set);
                    continue;
                }
                if (object.isExternalLabelRequired()) {
                    settingsPanelBuilder.addComponent(new SettingComponentDefinition(param, param.getName(), param.getDescription(), settingsPanelBuilder.getCurrentCategoryName(), object.getComponent()));
                    continue;
                }
                settingsPanelBuilder.addComponent(new SettingComponentDefinition(param, null, param.getDescription(), settingsPanelBuilder.getCurrentCategoryName(), object.getComponent()));
            }
            if (settingsPanelBuilder.getCurrentCategoryName() != null) {
                settingsPanelBuilder.endCategory();
            }
            if (bl && !ParamSetPanel.this.fSuppressBottomPadding) {
                settingsPanelBuilder.addPadding();
            }
            this.add(settingsPanelBuilder.getComponent());
            this.revalidate();
            this.repaint();
        }
    }
}

