/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ReturnRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class ParamValuePopup {
    private final String fNamePrefix;
    private ReturnRunnable<Window> fParentCallback;
    private ReturnRunnable<Component> fContentCallback;
    private ReturnRunnable<Point> fAnchorCallback;
    private ReturnRunnable<Integer> fWidthCallback;
    private Runnable fCommitCallback;
    private Runnable fCancelCallback;
    private Runnable fHideCallback;
    private ParameterRunnable<JComponent> fPreShowCallback;
    private Window fLastKnownParent;
    private final ComponentListener fParentWindowListener;
    private final ComponentListener fPopupWindowListener;
    private static Set<ParamValuePopup> sPopupOwners = new HashSet<ParamValuePopup>();
    private static Map<Window, MJDialog> sPopupsByParentWindow = new WeakHashMap<Window, MJDialog>();

    public ParamValuePopup(String string) {
        this.fNamePrefix = string;
        this.fParentWindowListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                ParamValuePopup.this.adjustPopupSizeAndPosition();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ParamValuePopup.this.adjustPopupSizeAndPosition();
            }
        };
        this.fPopupWindowListener = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                if (ParamValuePopup.this.fHideCallback != null) {
                    ParamValuePopup.this.fHideCallback.run();
                }
            }
        };
    }

    public void setParentCallback(ReturnRunnable<Window> returnRunnable) {
        this.fParentCallback = returnRunnable;
    }

    public void setContentCallback(ReturnRunnable<Component> returnRunnable) {
        this.fContentCallback = returnRunnable;
    }

    public void setAnchorCallback(ReturnRunnable<Point> returnRunnable) {
        this.fAnchorCallback = returnRunnable;
    }

    public void setWidthCallback(ReturnRunnable<Integer> returnRunnable) {
        this.fWidthCallback = returnRunnable;
    }

    public void setCommitCallback(Runnable runnable) {
        this.fCommitCallback = runnable;
    }

    public void setCancelCallback(Runnable runnable) {
        this.fCancelCallback = runnable;
    }

    public void setHideCallback(Runnable runnable) {
        this.fHideCallback = runnable;
    }

    public void setPreShowCallback(ParameterRunnable<JComponent> parameterRunnable) {
        this.fPreShowCallback = parameterRunnable;
    }

    public void show() {
        MJPanel mJPanel;
        JPanel jPanel;
        assert (this.fParentCallback != null && this.fContentCallback != null && this.fAnchorCallback != null && this.fWidthCallback != null);
        MJDialog mJDialog = this.getPopup();
        sPopupOwners.add(this);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(3, 3));
        MJAbstractAction mJAbstractAction = new MJAbstractAction(BuiltInResources.getString("button.cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                ParamValuePopup.this.close();
                if (ParamValuePopup.this.fCancelCallback != null) {
                    ParamValuePopup.this.fCancelCallback.run();
                }
            }
        };
        mJAbstractAction.setTip(null);
        MJButton mJButton = new MJButton(BuiltInResources.getString("button.ok"));
        mJButton.setName(this.fNamePrefix + ".ok");
        MJButton mJButton2 = new MJButton((Action)mJAbstractAction);
        mJButton2.setName(this.fNamePrefix + ".cancel");
        if (PlatformInfo.isMacintosh()) {
            mJButton.putClientProperty((Object)"JButton.buttonType", (Object)"gradient");
            mJButton2.putClientProperty((Object)"JButton.buttonType", (Object)"gradient");
            mJButton.setText(BuiltInResources.getString("button.done"));
            jPanel = new MJPanel((LayoutManager)new FormLayout("fill:0dlu:grow, fill:d, fill:d", "fill:d"));
            mJPanel = new CellConstraints();
            jPanel.add((Component)mJButton2, mJPanel.xy(2, 1));
            jPanel.add((Component)mJButton, mJPanel.xy(3, 1));
        } else {
            jPanel = ButtonBarFactory.buildOKCancelBar((JButton)mJButton, (JButton)mJButton2);
        }
        mJPanel2.add((Component)this.fContentCallback.run(), (Object)"Center");
        mJPanel2.add((Component)jPanel, (Object)"South");
        mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJDialog.setContentPane((Container)mJPanel);
        if (this.fPreShowCallback != null) {
            this.fPreShowCallback.run((Object)mJPanel);
        }
        mJPanel.add((Component)mJPanel2);
        InputMap inputMap = mJPanel.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "close-popup");
        mJPanel.getActionMap().put("close-popup", (Action)mJAbstractAction);
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParamValuePopup.this.close();
                if (ParamValuePopup.this.fCommitCallback != null) {
                    ParamValuePopup.this.fCommitCallback.run();
                }
            }
        });
        mJDialog.setSize(((Integer)this.fWidthCallback.run()).intValue(), (int)mJPanel2.getPreferredSize().getHeight());
        this.adjustPopupSizeAndPosition();
        mJDialog.setVisible(true);
    }

    private MJDialog getPopup() {
        if (this.fParentCallback == null) {
            return null;
        }
        Window window = this.getParent();
        if (window == null) {
            return null;
        }
        MJDialog mJDialog = sPopupsByParentWindow.get(window);
        if (mJDialog == null) {
            mJDialog = window instanceof Frame ? new MJDialog((Frame)window) : new MJDialog((Dialog)window);
            mJDialog.setUndecorated(true);
            sPopupsByParentWindow.put(window, mJDialog);
        }
        mJDialog.setName(this.fNamePrefix + ".menu");
        window.removeComponentListener(this.fParentWindowListener);
        window.addComponentListener(this.fParentWindowListener);
        mJDialog.removeComponentListener(this.fPopupWindowListener);
        mJDialog.addComponentListener(this.fPopupWindowListener);
        return mJDialog;
    }

    private Window getParent() {
        Window window = (Window)this.fParentCallback.run();
        if (window == null) {
            window = this.fLastKnownParent;
        } else {
            this.fLastKnownParent = window;
        }
        return window;
    }

    public void adjustPopupSizeAndPosition() {
        MJDialog mJDialog = this.getPopup();
        if (mJDialog != null) {
            Point point = (Point)this.fAnchorCallback.run();
            int n = (Integer)this.fWidthCallback.run();
            mJDialog.setSize(n, mJDialog.getHeight());
            mJDialog.setLocation((int)point.getX(), (int)point.getY());
        }
    }

    public void close() {
        Window window;
        if (!sPopupOwners.contains(this)) {
            return;
        }
        sPopupOwners.remove(this);
        final MJDialog mJDialog = this.getPopup();
        if (mJDialog != null) {
            mJDialog.setVisible(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mJDialog.removeComponentListener(ParamValuePopup.this.fPopupWindowListener);
                }
            });
        }
        if ((window = this.getParent()) != null) {
            window.removeComponentListener(this.fParentWindowListener);
        }
    }

    public boolean isShowing() {
        return sPopupOwners.contains(this);
    }
}

