/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final String LIST_DELIMITER = ";";

    private StringUtils() {
    }

    public static List<String> delimitedStringToList(String string) {
        return StringUtils.delimitedStringToList(string, LIST_DELIMITER);
    }

    public static List<String> delimitedStringToList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static String listToDelimitedString(List<?> list) {
        return StringUtils.listToDelimitedString(list, LIST_DELIMITER);
    }

    public static String listToDelimitedString(List<?> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : list) {
            String string2 = obj.toString();
            if (obj instanceof File) {
                string2 = ((File)obj).toString();
            }
            if (string2.trim().length() <= 0) continue;
            stringBuilder.append(string2);
            stringBuilder.append(string);
        }
        if (stringBuilder.toString().endsWith(string)) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static boolean matchesWildcardPattern(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string3 = string2;
        if (string3.endsWith(".*")) {
            string3 = string3.substring(0, string3.length() - 2) + "*";
        }
        for (int i = 0; i <= string3.length(); ++i) {
            if (i == string3.length() || string3.charAt(i) == '*') {
                if (stringBuilder2.length() > 0) {
                    stringBuilder.append("\\Q");
                    stringBuilder.append(stringBuilder2.toString());
                    stringBuilder.append("\\E");
                    stringBuilder2.setLength(0);
                }
                if (i >= string3.length() || string3.charAt(i) != '*') continue;
                stringBuilder.append(".*");
                continue;
            }
            stringBuilder2.append(string3.charAt(i));
        }
        return Pattern.compile(stringBuilder.toString(), 34).matcher(string).matches();
    }

    public static String upperCaseToCamelCase(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (int i = 0; i < string.length(); ++i) {
            if (bl2) {
                stringBuilder.append(string.charAt(i));
                bl2 = false;
                continue;
            }
            if (string.charAt(i) == '_') {
                bl2 = true;
                continue;
            }
            stringBuilder.append(Character.toLowerCase(string.charAt(i)));
        }
        String string2 = stringBuilder.toString();
        if (bl && string2.length() > 0) {
            return String.valueOf(string2.charAt(0)).toUpperCase(Locale.ENGLISH) + string2.substring(1);
        }
        if (!bl && string2.length() > 0) {
            return String.valueOf(string2.charAt(0)).toLowerCase(Locale.ENGLISH) + string2.substring(1);
        }
        return string2;
    }

    public static String camelCaseToLowerCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0 && Character.isUpperCase(string.charAt(i))) {
                stringBuilder.append('_');
            }
            stringBuilder.append(Character.toLowerCase(string.charAt(i)));
        }
        return stringBuilder.toString();
    }

    public static String normalizeSpace(String string) {
        return string.trim().replaceAll("\\r[\\s]*", "").replaceAll("\\n[\\s]*", "").replaceAll("[\\s]+", " ");
    }
}

