/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.jgoodies.forms.layout.CellConstraints;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.logui.BuildProgressTextArea;
import com.mathworks.project.impl.workflowui.OutputAreaModel;
import com.mathworks.project.impl.workflowui.OutputTabInstance;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class OutputArea {
    private final MJPanel fComponent = new MJPanel(){

        public void doLayout() {
            Dimension dimension = OutputArea.this.fControlBar.getPreferredSize();
            if (OutputArea.this.fTabbedPane != null) {
                int n = Math.max(0, (int)dimension.getHeight() + 4 - OutputArea.this.getTabHeight());
                OutputArea.this.fTabbedPane.setBounds(0, n, this.getWidth(), this.getHeight() - n);
            } else {
                int n = (int)dimension.getHeight() + 4;
                OutputArea.this.fLogScroller.setBounds(0, n, this.getWidth(), this.getHeight() - n);
            }
            OutputArea.this.fControlBar.setBounds((int)((double)this.getWidth() - dimension.getWidth()), 0, (int)dimension.getWidth(), (int)dimension.getHeight());
        }
    };
    private final MJScrollPane fLogScroller;
    private final Component fControlBar;
    private final BuildProgressTextArea fLog;
    private final PropertyChangeListener fModelListener;
    private final ChangeListener fTabbedPaneListener;
    private MJTabbedPane fTabbedPane;
    private OutputAreaModel fModel;
    private boolean fReactingToModel;

    public OutputArea(Component component) {
        this.fComponent.setLayout(null);
        this.fControlBar = component;
        this.fLog = new BuildProgressTextArea();
        this.fLogScroller = new MJScrollPane(this.fLog.getComponent()){

            public Dimension getPreferredSize() {
                return new Dimension((int)super.getPreferredSize().getWidth(), (int)Math.max(275.0, super.getPreferredSize().getWidth()));
            }
        };
        this.fModelListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("extra-tabs")) {
                    OutputArea.this.refresh();
                } else if (propertyChangeEvent.getPropertyName().equals("selected-tab-index")) {
                    OutputArea.this.fReactingToModel = true;
                    OutputArea.this.fTabbedPane.setSelectedIndex(((Integer)propertyChangeEvent.getNewValue()).intValue());
                    OutputArea.this.fReactingToModel = false;
                }
            }
        };
        this.fTabbedPaneListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!OutputArea.this.fReactingToModel) {
                    OutputArea.this.fModel.setSelectedTabIndex(OutputArea.this.fTabbedPane.getSelectedIndex());
                }
            }
        };
        this.fComponent.add((Component)this.fLogScroller);
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fLog.dispose();
    }

    public OutputAreaModel getModel() {
        return this.fModel;
    }

    public void setModel(OutputAreaModel outputAreaModel) {
        if (this.fTabbedPane != null) {
            this.fTabbedPane.getModel().removeChangeListener(this.fTabbedPaneListener);
            while (this.fTabbedPane.getTabCount() != 0) {
                this.fTabbedPane.removeTabAt(0);
            }
            this.fTabbedPane = null;
        }
        if (this.fModel != null) {
            this.fModel.removePropertyChangeListener(this.fModelListener);
        }
        this.fModel = outputAreaModel;
        this.fModel.addPropertyChangeListener(this.fModelListener);
        this.refresh();
        this.fModel.getLogSource().bind(this.fLog.getDisplay());
    }

    private int getTabHeight() {
        int n = 0;
        if (this.fTabbedPane != null) {
            for (int i = 0; i < this.fTabbedPane.getTabCount(); ++i) {
                n = (int)Math.max((double)n, this.fTabbedPane.getUI().getTabBounds((JTabbedPane)this.fTabbedPane, i).getHeight());
            }
        }
        return n;
    }

    private void refresh() {
        this.fComponent.removeAll();
        if (!this.fModel.hasExtraTabs()) {
            CellConstraints cellConstraints = new CellConstraints();
            this.fComponent.add(this.fControlBar);
            if (this.fModel.isLogSupported()) {
                this.fComponent.add((Component)this.fLogScroller, (Object)cellConstraints);
            }
        } else {
            if (this.fTabbedPane == null) {
                this.fTabbedPane = new MJTabbedPane();
                this.fTabbedPane.setBorder(null);
                this.fTabbedPane.setName("workflow.output.tabs");
                this.fTabbedPane.addTab(BuiltInResources.getString("workflow.output.tab.log"), (Component)this.fLogScroller);
                for (OutputTabInstance outputTabInstance : this.fModel.getExtraTabs()) {
                    this.fTabbedPane.addTab(outputTabInstance.getDefinition().getTitle(), outputTabInstance.getComponent());
                }
                this.fTabbedPane.setSelectedIndex(this.fModel.getSelectedTabIndex());
                this.fTabbedPane.getModel().addChangeListener(this.fTabbedPaneListener);
            }
            this.fComponent.add((Component)this.fTabbedPane);
            this.fComponent.add(this.fControlBar);
            this.fComponent.setComponentZOrder(this.fControlBar, 0);
            this.fComponent.setComponentZOrder((Component)this.fTabbedPane, 1);
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }
}

