/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.tabcompletion;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.tabcompletion.TabCompletion;
import com.mathworks.jmi.tabcompletion.TabCompletionResults;
import com.mathworks.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class TabCompletionImpl
implements TabCompletion {
    private static final int DEFAULT_MAX_RESULTS_BEFORE_WARNING = Integer.MAX_VALUE;
    private final MatlabMCR fMatlab = new MatlabMCR();
    private final ExecutorService fExecutor = Executors.newSingleThreadExecutor();
    private int fMaxResultsBeforeWarning = Integer.MAX_VALUE;

    @Override
    public void setMaxResultsBeforeWarning(int n) {
        this.fMaxResultsBeforeWarning = n;
    }

    @Override
    public Future<TabCompletionResults> getCompletions(final String string) {
        Callable<TabCompletionResults> callable = new Callable<TabCompletionResults>(){
            private TabCompletionResults result;

            @Override
            public TabCompletionResults call() throws Exception {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                TabCompletionImpl.this.fMatlab.whenMatlabReady(new Runnable(){

                    @Override
                    public void run() {
                        result = TabCompletionImpl.this.getCompletionsFromMatlab(string);
                        countDownLatch.countDown();
                    }
                });
                countDownLatch.await();
                return this.result;
            }
        };
        return this.fExecutor.submit(callable);
    }

    private TabCompletionResults getCompletionsFromMatlab(String string) {
        TabCompletionResults tabCompletionResults = null;
        ArrayList<String> arrayList = new ArrayList<String>(256);
        try {
            String[] stringArray;
            do {
                stringArray = this.fMatlab.mtFindAllTabCompletions(string, arrayList.size());
                arrayList.addAll(Arrays.asList(stringArray));
                if (arrayList.size() <= this.fMaxResultsBeforeWarning) continue;
                tabCompletionResults = TabCompletionResults.createTooManyMatchesResult();
                break;
            } while (stringArray.length > 0);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
            tabCompletionResults = TabCompletionResults.createErrorResult();
        }
        return tabCompletionResults != null ? tabCompletionResults : TabCompletionResults.createSuccessfulResult(arrayList);
    }
}

