/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.policy;

import com.sun.jini.collection.WeakIdentityMap;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jini.security.GrantPermission;
import net.jini.security.policy.DynamicPolicy;
import net.jini.security.policy.PolicyInitializationException;

public class DynamicPolicyProvider
extends Policy
implements DynamicPolicy {
    private static final String basePolicyClassProperty = "net.jini.security.policy.DynamicPolicyProvider.basePolicyClass";
    private static final String defaultBasePolicyClass = "net.jini.security.policy.PolicyFileProvider";
    private static final ProtectionDomain sysDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return (class$java$lang$Object == null ? (class$java$lang$Object = DynamicPolicyProvider.class$("java.lang.Object")) : class$java$lang$Object).getProtectionDomain();
        }
    });
    private final Policy basePolicy;
    private final boolean cacheBasePerms;
    private final WeakIdentityMap domainPerms = new WeakIdentityMap();
    private final WeakIdentityMap loaderGrants = new WeakIdentityMap();
    private final Grants globalGrants = new Grants();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$jini$security$policy$DynamicPolicyProvider;

    public DynamicPolicyProvider() throws PolicyInitializationException {
        String string = Security.getProperty(basePolicyClassProperty);
        if (string == null) {
            string = defaultBasePolicyClass;
        }
        try {
            this.basePolicy = (Policy)Class.forName(string).newInstance();
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            throw new PolicyInitializationException("unable to construct base policy", exception);
        }
        this.cacheBasePerms = !(this.basePolicy instanceof DynamicPolicy);
        this.ensureDependenciesResolved();
    }

    public DynamicPolicyProvider(Policy policy) {
        if (policy == null) {
            throw new NullPointerException();
        }
        this.basePolicy = policy;
        this.cacheBasePerms = !(policy instanceof DynamicPolicy);
        this.ensureDependenciesResolved();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = this.basePolicy.getPermissions(codeSource);
        Permission[] permissionArray = this.globalGrants.get(null);
        for (int i = 0; i < permissionArray.length; ++i) {
            Permission permission = permissionArray[i];
            if (permissionCollection.implies(permission)) continue;
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        return this.getDomainPermissions(protectionDomain).getPermissions();
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        return this.getDomainPermissions(protectionDomain).implies(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.basePolicy.refresh();
        if (this.cacheBasePerms) {
            WeakIdentityMap weakIdentityMap = this.domainPerms;
            synchronized (weakIdentityMap) {
                this.domainPerms.clear();
            }
        }
    }

    public boolean grantSupported() {
        return true;
    }

    public void grant(Class clazz, Principal[] principalArray, Permission[] permissionArray) {
        if (clazz != null) {
            DynamicPolicyProvider.checkDomain(clazz);
        }
        if (principalArray != null && principalArray.length > 0) {
            principalArray = (Principal[])principalArray.clone();
            DynamicPolicyProvider.checkNullElements(principalArray);
        }
        if (permissionArray == null || permissionArray.length == 0) {
            return;
        }
        permissionArray = (Permission[])permissionArray.clone();
        DynamicPolicyProvider.checkNullElements(permissionArray);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new GrantPermission(permissionArray));
        }
        Grants grants = clazz != null ? this.getLoaderGrants(DynamicPolicyProvider.getClassLoader(clazz)) : this.globalGrants;
        grants.add(principalArray, permissionArray);
    }

    public Permission[] getGrants(Class clazz, Principal[] principalArray) {
        if (clazz != null) {
            DynamicPolicyProvider.checkDomain(clazz);
        }
        if (principalArray != null && principalArray.length > 0) {
            principalArray = (Principal[])principalArray.clone();
            DynamicPolicyProvider.checkNullElements(principalArray);
        }
        List<Permission> list = Arrays.asList(this.globalGrants.get(principalArray));
        if (clazz != null) {
            list = new ArrayList<Permission>(list);
            list.addAll(Arrays.asList(this.getLoaderGrants(DynamicPolicyProvider.getClassLoader(clazz)).get(principalArray)));
        }
        Permissions permissions = new Permissions();
        Iterator<Permission> iterator = list.iterator();
        while (iterator.hasNext()) {
            Permission permission = iterator.next();
            if (((PermissionCollection)permissions).implies(permission)) continue;
            ((PermissionCollection)permissions).add(permission);
        }
        list = Collections.list(((PermissionCollection)permissions).elements());
        return list.toArray(new Permission[list.size()]);
    }

    private void ensureDependenciesResolved() {
        this.getDomainPermissions(sysDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainPermissions getDomainPermissions(ProtectionDomain protectionDomain) {
        DomainPermissions domainPermissions;
        WeakIdentityMap weakIdentityMap = this.domainPerms;
        synchronized (weakIdentityMap) {
            domainPermissions = (DomainPermissions)this.domainPerms.get(protectionDomain);
        }
        if (domainPermissions == null) {
            domainPermissions = new DomainPermissions(protectionDomain);
            this.globalGrants.register(domainPermissions);
            if (protectionDomain != null) {
                this.getLoaderGrants(protectionDomain.getClassLoader()).register(domainPermissions);
            }
            weakIdentityMap = this.domainPerms;
            synchronized (weakIdentityMap) {
                this.domainPerms.put(protectionDomain, domainPermissions);
            }
        }
        return domainPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grants getLoaderGrants(ClassLoader classLoader) {
        WeakIdentityMap weakIdentityMap = this.loaderGrants;
        synchronized (weakIdentityMap) {
            Grants grants = (Grants)this.loaderGrants.get(classLoader);
            if (grants == null) {
                grants = new Grants();
                this.loaderGrants.put(classLoader, grants);
            }
            return grants;
        }
    }

    private static ClassLoader getClassLoader(final Class clazz) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    private static void checkDomain(final Class clazz) {
        ProtectionDomain protectionDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getProtectionDomain();
            }
        });
        if (protectionDomain != sysDomain && protectionDomain.getClassLoader() == null) {
            throw new UnsupportedOperationException("ungrantable protection domain");
        }
    }

    private static void checkNullElements(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new NullPointerException();
        }
    }

    private static class WeakGroup {
        private final Node head = new Node((Object)null, null);

        private WeakGroup() {
        }

        void add(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.head.next = new Node(object, this.head.next);
        }

        Iterator iterator() {
            return new Iterator(){
                private Node prevNode;
                private Object nextObj;
                {
                    this.prevNode = WeakGroup.this.head;
                    this.nextObj = this.getNext();
                }

                public Object next() {
                    if (this.nextObj == null) {
                        throw new NoSuchElementException();
                    }
                    Object object = this.nextObj;
                    this.nextObj = this.getNext();
                    return object;
                }

                public boolean hasNext() {
                    return this.nextObj != null;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private Object getNext() {
                    Node node = this.prevNode.next;
                    while (node != null) {
                        Object t = node.get();
                        if (t != null) {
                            this.prevNode = node;
                            return t;
                        }
                        this.prevNode.next = node = node.next;
                    }
                    return null;
                }
            };
        }

        private static class Node
        extends WeakReference {
            Node next;

            Node(Object object, Node node) {
                super(object);
                this.next = node;
            }
        }
    }

    private static class Grants {
        private final Map principalGrants = new HashMap();
        private final WeakGroup scope;

        Grants() {
            PrincipalGrants principalGrants = new PrincipalGrants();
            this.principalGrants.put(Collections.EMPTY_SET, principalGrants);
            this.scope = principalGrants.scope;
        }

        synchronized void add(Principal[] principalArray, Permission[] permissionArray) {
            Object object;
            Set<Principal> set = principalArray != null && principalArray.length > 0 ? new HashSet<Principal>(Arrays.asList(principalArray)) : Collections.EMPTY_SET;
            PrincipalGrants principalGrants = (PrincipalGrants)this.principalGrants.get(set);
            if (principalGrants == null) {
                principalGrants = new PrincipalGrants();
                object = this.scope.iterator();
                while (object.hasNext()) {
                    DomainPermissions domainPermissions = (DomainPermissions)object.next();
                    if (!Grants.containsAll(domainPermissions.getPrincipals(), set)) continue;
                    principalGrants.scope.add(domainPermissions);
                }
                this.principalGrants.put(set, principalGrants);
            }
            object = new ArrayList();
            for (int i = 0; i < permissionArray.length; ++i) {
                Permission permission = permissionArray[i];
                if (principalGrants.perms.implies(permission)) continue;
                principalGrants.perms.add(permission);
                ((ArrayList)object).add(permission);
            }
            if (((ArrayList)object).size() > 0) {
                permissionArray = ((ArrayList)object).toArray(new Permission[((ArrayList)object).size()]);
                Iterator iterator = principalGrants.scope.iterator();
                while (iterator.hasNext()) {
                    ((DomainPermissions)iterator.next()).add(permissionArray);
                }
            }
        }

        synchronized Permission[] get(Principal[] principalArray) {
            Set<Principal> set = principalArray != null && principalArray.length > 0 ? new HashSet<Principal>(Arrays.asList(principalArray)) : Collections.EMPTY_SET;
            ArrayList<Permission> arrayList = new ArrayList<Permission>();
            Iterator iterator = this.principalGrants.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!Grants.containsAll(set, (Set)entry.getKey())) continue;
                PrincipalGrants principalGrants = (PrincipalGrants)entry.getValue();
                arrayList.addAll(Collections.list(principalGrants.perms.elements()));
            }
            return arrayList.toArray(new Permission[arrayList.size()]);
        }

        synchronized void register(DomainPermissions domainPermissions) {
            Set set = domainPermissions.getPrincipals();
            Iterator iterator = this.principalGrants.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!Grants.containsAll(set, (Set)entry.getKey())) continue;
                PrincipalGrants principalGrants = (PrincipalGrants)entry.getValue();
                principalGrants.scope.add(domainPermissions);
                ArrayList<Permission> arrayList = Collections.list(principalGrants.perms.elements());
                domainPermissions.add(arrayList.toArray(new Permission[arrayList.size()]));
            }
        }

        private static boolean containsAll(Set set, Set set2) {
            return set.size() >= set2.size() && set.containsAll(set2);
        }

        private static class PrincipalGrants {
            final WeakGroup scope = new WeakGroup();
            final PermissionCollection perms = new Permissions();

            PrincipalGrants() {
            }
        }
    }

    private class DomainPermissions {
        private final ProtectionDomain domain;
        private final Set principals;
        private final PermissionCollection perms;
        private final List grants = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        DomainPermissions(ProtectionDomain protectionDomain) {
            Principal[] principalArray;
            this.domain = protectionDomain;
            this.principals = protectionDomain != null && (principalArray = protectionDomain.getPrincipals()).length > 0 ? new HashSet<Principal>(Arrays.asList(principalArray)) : Collections.EMPTY_SET;
            this.perms = DynamicPolicyProvider.this.cacheBasePerms ? DynamicPolicyProvider.this.basePolicy.getPermissions(protectionDomain) : null;
        }

        Set getPrincipals() {
            return this.principals;
        }

        synchronized void add(Permission[] permissionArray) {
            for (int i = 0; i < permissionArray.length; ++i) {
                Permission permission = permissionArray[i];
                this.grants.add(permission);
                if (this.perms == null) continue;
                this.perms.add(permission);
            }
        }

        synchronized PermissionCollection getPermissions() {
            return this.getPermissions(true);
        }

        synchronized boolean implies(Permission permission) {
            if (this.perms != null) {
                return this.perms.implies(permission);
            }
            if (DynamicPolicyProvider.this.basePolicy.implies(this.domain, permission)) {
                return true;
            }
            if (this.grants.isEmpty()) {
                return false;
            }
            return this.getPermissions(false).implies(permission);
        }

        private PermissionCollection getPermissions(boolean bl) {
            if (!$assertionsDisabled && !Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            PermissionCollection permissionCollection = DynamicPolicyProvider.this.basePolicy.getPermissions(this.domain);
            Iterator iterator = this.grants.iterator();
            while (iterator.hasNext()) {
                Permission permission = (Permission)iterator.next();
                if (bl && permissionCollection.implies(permission)) continue;
                permissionCollection.add(permission);
            }
            return permissionCollection;
        }

        static {
            $assertionsDisabled = !(class$net$jini$security$policy$DynamicPolicyProvider == null ? (class$net$jini$security$policy$DynamicPolicyProvider = DynamicPolicyProvider.class$("net.jini.security.policy.DynamicPolicyProvider")) : class$net$jini$security$policy$DynamicPolicyProvider).desiredAssertionStatus();
        }
    }
}

