/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.utils;

import com.mathworks.hg.peer.WindowsTextMetric;
import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.text.BreakIterator;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class MultilineLabel
extends JComponent
implements SwingConstants {
    private String[] fLines = null;
    private int[] fLineWidths;
    private int fNumberOfLines;
    private int fLineHeight;
    private int fLineAscent;
    private int fMaxLineWidth = -1;
    private int fTotalLineHeight = -1;
    int btnMarginWidth = 1;
    private int fHorizontalAlignment;
    private int fVerticalAlignment;
    private int fTextAlignment;
    private boolean fLineWrap;

    public MultilineLabel() {
        this(null, 0, 0, 1);
    }

    public MultilineLabel(String string) {
        this(string, 0, 0, 1);
    }

    public MultilineLabel(String string, int n) {
        this(string, n, 0, 1);
    }

    public MultilineLabel(String string, int n, int n2) {
        this(string, n, n2, 1);
    }

    public MultilineLabel(String string, int n, int n2, int n3) {
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setBackground(UIManager.getColor("Label.background"));
        this.setFont(UIManager.getFont("Label.font"));
        this.setText(string);
        this.fHorizontalAlignment = n;
        this.fVerticalAlignment = n3;
        this.fTextAlignment = n2;
        this.fLineWrap = true;
    }

    public void setText(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{""};
        }
        this.fNumberOfLines = stringArray.length;
        this.fLines = stringArray;
        this.fLineWidths = new int[this.fNumberOfLines];
        this.recalculateDimension();
        this.repaint();
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.fNumberOfLines = stringTokenizer.countTokens();
        this.fLines = new String[this.fNumberOfLines];
        this.fLineWidths = new int[this.fNumberOfLines];
        for (int i = 0; i < this.fNumberOfLines; ++i) {
            this.fLines[i] = stringTokenizer.nextToken();
        }
        this.recalculateDimension();
        this.repaint();
    }

    private int adjustLeadingMatchNative(Font font) {
        int n = 0;
        if (PlatformInfo.isWindows() && font != null) {
            try {
                WindowsTextMetric windowsTextMetric = new WindowsTextMetric(NativeJava.hWndFromComponent((Component)this), font);
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n2 = fontMetrics.getMaxAscent();
                int n3 = fontMetrics.getMaxDescent();
                int n4 = fontMetrics.getLeading();
                n = n2 + n3 + n4 - windowsTextMetric.tmHeight();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return n;
    }

    private void recalculateDimension() {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.fLineHeight = fontMetrics.getHeight() - this.adjustLeadingMatchNative(font);
        this.fLineAscent = fontMetrics.getAscent();
        this.fMaxLineWidth = 0;
        for (int i = 0; i < this.fNumberOfLines; ++i) {
            this.fLineWidths[i] = fontMetrics.stringWidth(this.fLines[i]);
            this.fMaxLineWidth = Math.max(this.fMaxLineWidth, this.fLineWidths[i]);
        }
        this.fMaxLineWidth += 2 * this.btnMarginWidth;
        this.fTotalLineHeight = this.fNumberOfLines * this.fLineHeight;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.fMaxLineWidth == -1 || this.fTotalLineHeight == -1) {
            this.recalculateDimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this.fMaxLineWidth + insets.left + insets.right, this.fTotalLineHeight + insets.top + insets.bottom);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingHints renderingHints = GraphicsUtils.getAntialiasingRenderingHints();
        if (renderingHints != null) {
            graphics2D.addRenderingHints(renderingHints);
        }
        Dimension dimension = this.getSize();
        if (dimension.width != this.fMaxLineWidth || dimension.height != this.fTotalLineHeight) {
            this.recalculateDimension();
        }
        Insets insets = this.getInsets();
        int n2 = 0;
        if (this.fVerticalAlignment == 1) {
            n2 = insets.top + this.fLineAscent;
        } else if (this.fVerticalAlignment == 0) {
            n2 = insets.top + this.fLineAscent;
            n = dimension.height - insets.top - insets.bottom;
            n2 += (n - this.fTotalLineHeight) / 2;
        } else if (this.fVerticalAlignment == 3) {
            n = dimension.height - insets.bottom;
            n2 = n - this.fTotalLineHeight;
            n2 += this.fLineAscent;
        }
        for (int i = 0; i < this.fNumberOfLines; ++i) {
            int n3 = this.getBidiHorizontalAlignment(this.fHorizontalAlignment);
            int n4 = 0;
            int n5 = dimension.width - insets.left - insets.right;
            boolean bl = true;
            String string = this.fLines[i];
            int n6 = this.fLineWidths[i];
            while (bl) {
                int n7;
                String string2;
                if (this.getLineWrap() && n6 > n5) {
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    int n8 = this.getBreakLocation(new Segment(string.toCharArray(), 0, string.length()), fontMetrics, n4, n5, null, 0);
                    if (n8 > 0) {
                        string2 = string.substring(0, n8);
                        string = string.substring(n8);
                        n6 = fontMetrics.stringWidth(string);
                    } else {
                        string2 = string;
                        bl = false;
                    }
                    n7 = fontMetrics.stringWidth(string2);
                } else {
                    string2 = string;
                    n7 = n6;
                    bl = false;
                }
                if (n3 == 2) {
                    n3 = this.getBidiHorizontalAlignment(this.fTextAlignment);
                    if (n3 == 2) {
                        n4 = insets.left;
                    } else if (n3 == 4) {
                        n4 = this.fMaxLineWidth - n7 + insets.left;
                    } else if (n3 == 0) {
                        n4 = insets.left + (this.fMaxLineWidth - n7) / 2;
                    }
                } else if (n3 == 4) {
                    n3 = this.getBidiHorizontalAlignment(this.fTextAlignment);
                    if (n3 == 2) {
                        n4 = dimension.width - this.fMaxLineWidth - insets.right;
                    } else if (n3 == 4) {
                        n4 = dimension.width - n7 - insets.right;
                    } else if (n3 == 0) {
                        n4 = dimension.width - this.fMaxLineWidth - insets.right + (this.fMaxLineWidth - n7) / 2;
                    }
                } else if (n3 == 0) {
                    n3 = this.getBidiHorizontalAlignment(this.fTextAlignment);
                    int n9 = dimension.width - insets.left - insets.right;
                    if (n3 == 2) {
                        n4 = insets.left + (n9 - this.fMaxLineWidth) / 2;
                    } else if (n3 == 4) {
                        n4 = insets.left + (n9 - this.fMaxLineWidth) / 2 + (this.fMaxLineWidth - n7);
                    } else if (n3 == 0) {
                        n4 = insets.left + (n9 - n7) / 2;
                    }
                }
                n4 += this.btnMarginWidth;
                if (this.isEnabled()) {
                    this.paintEnabledText(graphics2D, string2, n4, n2);
                } else {
                    this.paintDisabledText(graphics2D, string2, n4, n2);
                }
                n2 += this.fLineHeight;
            }
        }
        graphics2D.dispose();
    }

    private int getBreakLocation(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        char[] cArray = segment.array;
        int n4 = segment.offset;
        int n5 = segment.count;
        int n6 = Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3, false);
        if (n6 >= n5) {
            return n5;
        }
        for (int i = n4 + n6; i >= n4; --i) {
            char c = cArray[i];
            if (c < '\u0100') {
                if (!Character.isWhitespace(c)) continue;
                n6 = i - n4 + 1;
                break;
            }
            BreakIterator breakIterator = BreakIterator.getLineInstance();
            breakIterator.setText(segment);
            int n7 = breakIterator.preceding(i + 1);
            if (n7 <= n4) break;
            n6 = n7 - n4;
            break;
        }
        return n6;
    }

    private int getBidiHorizontalAlignment(int n) {
        if (n == 10) {
            n = this.getComponentOrientation().isLeftToRight() ? 2 : 4;
        } else if (n == 11) {
            n = this.getComponentOrientation().isLeftToRight() ? 4 : 2;
        }
        return n;
    }

    public int getVerticalAlignment() {
        return this.fVerticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.fVerticalAlignment = n;
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.fHorizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.fHorizontalAlignment = n;
        this.repaint();
    }

    public int getTextAlignment() {
        return this.fTextAlignment;
    }

    public void setTextAlignment(int n) {
        this.fTextAlignment = n;
        this.repaint();
    }

    public boolean getLineWrap() {
        return this.fLineWrap;
    }

    public void setLineWrap(boolean bl) {
        this.fLineWrap = bl;
        this.repaint();
    }

    private void paintEnabledText(Graphics graphics, String string, int n, int n2) {
        graphics.setColor(this.getForeground());
        graphics.drawString(string, n, n2);
    }

    private void paintDisabledText(Graphics graphics, String string, int n, int n2) {
        Color color = this.getBackground();
        graphics.setColor(color.brighter());
        graphics.drawString(string, n + 1, n2 + 1);
        graphics.setColor(color.darker());
        graphics.drawString(string, n, n2);
    }
}

