/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.project.api.CustomFileSetAction;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.ReadableFileSet;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.toolbox.coder.plugin.AutoInferDialog;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.widgets.text.mcode.MTree;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EntryPointFileSetAction
implements CustomFileSetAction {
    private AutoInferDialog fAutoPopulateDialog;
    private WindowListener fAutoPopulateListener;
    private PropertyChangeListener fPropertyChangeListener;
    private ReadableConfiguration fConfiguration;

    public String getLabel() {
        return CoderResources.getString("link.autoPopulateTypes");
    }

    public String getQeName() {
        return "entrypoint.infer.link";
    }

    public boolean isVisible(ReadableConfiguration readableConfiguration) {
        if (readableConfiguration.getParamAsBoolean("param.UsePreconditions")) {
            return false;
        }
        ReadableFileSet readableFileSet = readableConfiguration.getFileSet("fileset.entrypoints");
        for (File file : readableFileSet.getFiles()) {
            try {
                MTree mTree = MTree.parse((File)file);
                ArrayList<String> arrayList = new ArrayList<String>(0);
                Utilities.getEntryPointInputNames(mTree, arrayList);
                if (arrayList.isEmpty()) continue;
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public void addVisibilityListener(ReadableConfiguration readableConfiguration, final ChangeListener changeListener) {
        this.fConfiguration = readableConfiguration;
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("param.UsePreconditions")) {
                    changeListener.stateChanged(new ChangeEvent(EntryPointFileSetAction.this));
                }
            }
        };
        readableConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void run(WritableConfiguration writableConfiguration) {
        FileSetEditor fileSetEditor = ProjectGUI.getInstance().getCurrentClient().getFileSetEditor("fileset.entrypoints");
        final Frame frame = (Frame)SwingUtilities.windowForComponent(fileSetEditor.getComponent());
        if (writableConfiguration.getFileSet("fileset.entrypoints").getFiles().isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MJOptionPane.showMessageDialog((Component)frame, (Object)CoderResources.getString("msg.autoFill.addfiles"), (String)CoderResources.getString("title.autoPopulateTypes"), (int)0);
                }
            });
        } else {
            this.loadAutoPopulateDialog(writableConfiguration, frame);
        }
    }

    private void loadAutoPopulateDialog(WritableConfiguration writableConfiguration, Frame frame) {
        if (this.fAutoPopulateDialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EntryPointFileSetAction.this.fAutoPopulateDialog.requestFocus();
                }
            });
            return;
        }
        this.fAutoPopulateDialog = new AutoInferDialog(frame, writableConfiguration);
        this.fAutoPopulateDialog.setVisible(true);
        this.fAutoPopulateListener = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                EntryPointFileSetAction.this.disposeAutoPopulateDialog();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                EntryPointFileSetAction.this.disposeAutoPopulateDialog();
            }
        };
        this.fAutoPopulateDialog.addWindowListener(this.fAutoPopulateListener);
    }

    public void dispose() {
        this.disposeAutoPopulateDialog();
        if (this.fPropertyChangeListener != null) {
            this.fConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    private void disposeAutoPopulateDialog() {
        if (this.fAutoPopulateDialog != null) {
            this.fAutoPopulateDialog.removeWindowListener(this.fAutoPopulateListener);
            this.fAutoPopulateDialog.dispose();
            this.fAutoPopulateDialog = null;
        }
    }
}

