/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TestBenchConfig {
    private TestBenchRunMode fRunMode;
    private File fTestBenchFile;
    private List<File> fEntryPointFiles = new ArrayList<File>(0);
    private String fWorkingFolder;
    private String fMexFunctionName;
    private boolean fAutoUnbounded;
    private int fAutoUnboundedThreshold;
    private boolean fAutoBounded;
    private int fAutoBoundedThreshold;

    public TestBenchConfig(TestBenchRunMode testBenchRunMode) {
        this.fRunMode = testBenchRunMode;
    }

    public File getTestBenchFile() {
        return this.fTestBenchFile;
    }

    public void setTestBenchFile(File file) {
        this.fTestBenchFile = file;
    }

    public List<File> getEntryPointFiles() {
        return Collections.unmodifiableList(this.fEntryPointFiles);
    }

    public void setEntryPointFiles(Set<File> set) {
        this.fEntryPointFiles.clear();
        this.fEntryPointFiles.addAll(set);
    }

    public void addEntryPointFile(File file) {
        this.fEntryPointFiles.add(file);
    }

    public boolean isAutoUnbounded() {
        return this.fAutoUnbounded;
    }

    public void setAutoUnbounded(boolean bl) {
        this.fAutoUnbounded = bl;
    }

    public int getAutoUnboundedThreshold() {
        return this.fAutoUnboundedThreshold;
    }

    public void setAutoUnboundedThreshold(int n) {
        this.fAutoUnboundedThreshold = n;
    }

    public void setAutoUnboundedThreshold(String string) {
        try {
            this.setAutoUnboundedThreshold(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.setAutoUnbounded(false);
            this.setAutoUnboundedThreshold(1024);
        }
    }

    public boolean isAutoBounded() {
        return this.fAutoBounded;
    }

    public void setAutoBounded(boolean bl) {
        this.fAutoBounded = bl;
    }

    public int getAutoBoundedThreshold() {
        return this.fAutoBoundedThreshold;
    }

    public void setAutoBoundedThreshold(int n) {
        this.fAutoBoundedThreshold = n;
    }

    public void setAutoBoundedThreshold(String string) {
        try {
            this.setAutoBoundedThreshold(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.setAutoBounded(false);
            this.setAutoBoundedThreshold(1024);
        }
    }

    public String getWorkingFolder() {
        return this.fWorkingFolder;
    }

    public void setWorkingFolder(String string) {
        this.fWorkingFolder = string;
    }

    public String getMexFunctionName() {
        return this.fMexFunctionName;
    }

    public void setMexFunctionName(String string) {
        this.fMexFunctionName = string;
    }

    public TestBenchRunMode getRunMode() {
        return this.fRunMode;
    }

    public void setRunMode(TestBenchRunMode testBenchRunMode) {
        this.fRunMode = testBenchRunMode;
    }
}

