/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.project.api.XmlWriter;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.fixedpoint.FimathPanel;

public class IDPFimath {
    private static final String ROUNDING_METHOD_NAME = "RoundingMethod";
    private static final String OVERFLOW_ACTION_NAME = "OverflowAction";
    private static final String PRODUCT_MODE_NAME = "ProductMode";
    private static final String PRODUCT_WORDLENGTH_NAME = "ProductWordLength";
    private static final String PRODUCT_FRACTIONLENGTH_NAME = "ProductFractionLength";
    private static final String SUM_MODE_NAME = "SumMode";
    private static final String SUM_WORDLENGTH_NAME = "SumWordLength";
    private static final String SUM_FRACTIONLENGTH_NAME = "SumFractionLength";
    private static final String CAST_BEFORE_SUM_NAME = "CastBeforeSum";
    private FimathPanel.RoundingMethod fRoundingMethod = FimathPanel.ROUNDING_ENUM_DEFAULT;
    private FimathPanel.OverflowAction fOverflowAction = FimathPanel.OVERFLOW_ENUM_DEFAULT;
    private FimathPanel.PrecisionMode fProductMode = FimathPanel.PRECISION_ENUM_DEFAULT;
    private FimathPanel.PrecisionMode fSumMode = FimathPanel.PRECISION_ENUM_DEFAULT;
    private Boolean fCastBeforeSum = true;
    private Integer fProductWordLength = Integer.decode("32");
    private Integer fProductFractionLength = Integer.decode("30");
    private Integer fSumWordLength = Integer.decode("32");
    private Integer fSumFractionLength = Integer.decode("30");
    private Boolean fFimathIsLocal = false;

    public IDPFimath() {
    }

    public IDPFimath(IDPFimath iDPFimath) {
        this.fRoundingMethod = iDPFimath.fRoundingMethod;
        this.fOverflowAction = iDPFimath.fOverflowAction;
        this.fProductMode = iDPFimath.fProductMode;
        this.fSumMode = iDPFimath.fSumMode;
        this.fCastBeforeSum = iDPFimath.fCastBeforeSum;
        this.fProductWordLength = iDPFimath.fProductWordLength;
        this.fProductFractionLength = iDPFimath.fProductFractionLength;
        this.fSumWordLength = iDPFimath.fSumWordLength;
        this.fSumFractionLength = iDPFimath.fSumFractionLength;
        this.fFimathIsLocal = iDPFimath.fFimathIsLocal;
    }

    public Boolean getFimathIsLocal() {
        return this.fFimathIsLocal;
    }

    public void setFimathIsLocal(Boolean bl) {
        this.fFimathIsLocal = bl;
    }

    public FimathPanel.RoundingMethod getRoundingMethod() {
        return this.fRoundingMethod;
    }

    public void setRoundingMethod(FimathPanel.RoundingMethod roundingMethod) {
        this.fRoundingMethod = roundingMethod;
    }

    public void setRoundingMethod(String string) {
        this.setRoundingMethod(Utilities.getEnumeration(string, FimathPanel.RoundingMethod.values()));
    }

    public FimathPanel.OverflowAction getOverflowAction() {
        return this.fOverflowAction;
    }

    public void setOverflowAction(FimathPanel.OverflowAction overflowAction) {
        this.fOverflowAction = overflowAction;
    }

    public void setOverflowAction(String string) {
        this.setOverflowAction(Utilities.getEnumeration(string, FimathPanel.OverflowAction.values()));
    }

    public FimathPanel.PrecisionMode getProductMode() {
        return this.fProductMode;
    }

    public void setProductMode(FimathPanel.PrecisionMode precisionMode) {
        this.fProductMode = precisionMode;
    }

    public void setProductMode(String string) {
        this.setProductMode(Utilities.getEnumeration(string, FimathPanel.PrecisionMode.values()));
    }

    public FimathPanel.PrecisionMode getSumMode() {
        return this.fSumMode;
    }

    public void setSumMode(FimathPanel.PrecisionMode precisionMode) {
        this.fSumMode = precisionMode;
    }

    public void setSumMode(String string) {
        this.setSumMode(Utilities.getEnumeration(string, FimathPanel.PrecisionMode.values()));
    }

    public Boolean getCastBeforeSum() {
        return this.fCastBeforeSum;
    }

    public void setCastBeforeSum(Boolean bl) {
        this.fCastBeforeSum = bl;
    }

    public void setCastBeforeSum(String string) {
        this.setCastBeforeSum(Boolean.parseBoolean(string));
    }

    public Integer getProductWordLength() {
        return this.fProductWordLength;
    }

    public void setProductWordLength(Integer n) {
        this.fProductWordLength = n;
    }

    public void setProductWordLength(String string) {
        this.setProductWordLength(Integer.decode(string));
    }

    public Integer getProductFractionLength() {
        return this.fProductFractionLength;
    }

    public void setProductFractionLength(Integer n) {
        this.fProductFractionLength = n;
    }

    public void setProductFractionLength(String string) {
        this.setProductFractionLength(Integer.decode(string));
    }

    public Integer getSumWordLength() {
        return this.fSumWordLength;
    }

    public void setSumWordLength(Integer n) {
        this.fSumWordLength = n;
    }

    public void setSumWordLength(String string) {
        this.setSumWordLength(Integer.decode(string));
    }

    public Integer getSumFractionLength() {
        return this.fSumFractionLength;
    }

    public void setSumFractionLength(Integer n) {
        this.fSumFractionLength = n;
    }

    public void setSumFractionLength(String string) {
        this.setSumFractionLength(Integer.decode(string));
    }

    void getData(XmlWriter xmlWriter) {
        xmlWriter.writeText(ROUNDING_METHOD_NAME, new Object[]{Utilities.quote(this.fRoundingMethod)});
        xmlWriter.writeText(OVERFLOW_ACTION_NAME, new Object[]{Utilities.quote(this.fOverflowAction)});
        xmlWriter.writeText(PRODUCT_MODE_NAME, new Object[]{Utilities.quote(this.fProductMode)});
        if (!this.fProductMode.equals((Object)FimathPanel.PrecisionMode.FULL_PRECISION)) {
            xmlWriter.writeText(PRODUCT_WORDLENGTH_NAME, new Object[]{this.fProductWordLength});
            if (this.fProductMode.equals((Object)FimathPanel.PrecisionMode.SPECIFY_PRECISION)) {
                xmlWriter.writeText(PRODUCT_FRACTIONLENGTH_NAME, new Object[]{this.fProductFractionLength});
            }
        }
        xmlWriter.writeText(SUM_MODE_NAME, new Object[]{Utilities.quote(this.fSumMode)});
        if (!this.fSumMode.equals((Object)FimathPanel.PrecisionMode.FULL_PRECISION)) {
            xmlWriter.writeText(SUM_WORDLENGTH_NAME, new Object[]{this.fSumWordLength});
            if (this.fSumMode.equals((Object)FimathPanel.PrecisionMode.SPECIFY_PRECISION)) {
                xmlWriter.writeText(SUM_FRACTIONLENGTH_NAME, new Object[]{this.fSumFractionLength});
            }
        }
        xmlWriter.writeText(CAST_BEFORE_SUM_NAME, new Object[]{this.fCastBeforeSum});
    }
}

