/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.FutureEvalResult;
import com.mathworks.mvm.exec.MatlabEvalRequest;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MvmException;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.XmlReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public final class VerifyCodeMatlabCommand
implements Command {
    private String fCode;

    public VerifyCodeMatlabCommand(File file, ReadableConfiguration readableConfiguration, XmlReader xmlReader) {
        this.fCode = xmlReader.readText().replaceAll("\\n", " ").replaceAll("\\r", " ").replaceAll("\\s+", " ");
    }

    public VerifyCodeMatlabCommand(String string) {
        this.fCode = string;
    }

    public void execute(CommandStatus commandStatus) {
        CommandStatusWriter commandStatusWriter = new CommandStatusWriter(commandStatus, false);
        MatlabEvalRequest matlabEvalRequest = new MatlabEvalRequest(this.fCode, (Writer)commandStatusWriter, null);
        MatlabExecutor matlabExecutor = MvmContext.get().getExecutor();
        FutureEvalResult futureEvalResult = matlabExecutor.submit(matlabEvalRequest);
        try {
            futureEvalResult.get();
            commandStatus.finished();
        }
        catch (MvmExecutionException mvmExecutionException) {
            MvmException mvmException = mvmExecutionException.getMvmCause();
            StackTraceElement[] stackTraceElementArray = mvmException.getStackTrace();
            commandStatus.printErrorLine(mvmException.getLocalizedMessage());
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                commandStatus.printErrorLine("\nError in <a href=\"matlab: opentoline('" + stackTraceElement.getFileName() + "'," + stackTraceElement.getLineNumber() + ",0)\">" + (stackTraceElement.getClassName().isEmpty() ? "" : stackTraceElement.getClassName() + ">") + stackTraceElement.getMethodName() + " at " + stackTraceElement.getLineNumber() + "</a>");
            }
            commandStatus.failed(new CommandExecutionException((Command)this, (Throwable)mvmExecutionException));
        }
        catch (InterruptedException interruptedException) {
            commandStatus.failed(new CommandExecutionException((Command)this, (Throwable)interruptedException));
        }
        try {
            commandStatusWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cancel() {
    }

    public String toString() {
        return "";
    }

    private static class CommandStatusWriter
    extends Writer {
        private CommandStatus fCommandStatus;
        private boolean fToError;

        CommandStatusWriter(CommandStatus commandStatus, boolean bl) {
            this.fCommandStatus = commandStatus;
            this.fToError = bl;
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            if (this.fToError) {
                this.fCommandStatus.printErrorLine(String.copyValueOf(cArray, n, n2));
            } else {
                this.fCommandStatus.printOutputLine(String.copyValueOf(cArray, n, n2));
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
            this.fCommandStatus = null;
            this.lock = null;
        }
    }
}

