/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mwswing.MJLabel;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class ScreenerFileWidget {
    private final MJLabel fLabel;
    private final File fFile;
    private final int fOffenseCount;
    private Timer fHoverTimer;

    public ScreenerFileWidget(File file, int n) {
        this(file, -1, n, null);
    }

    public ScreenerFileWidget(File file, int n, Icon icon) {
        this(file, -1, n, icon);
    }

    public ScreenerFileWidget(File file, int n, int n2) {
        this(file, n, n2, null);
    }

    private ScreenerFileWidget(final File file, final int n, final int n2, Icon icon) {
        this.fFile = file;
        this.fOffenseCount = n;
        this.fLabel = new MJLabel(ScreenerFileWidget.generateHtml(file, n, false));
        this.fLabel.setToolTipText(file.getAbsolutePath());
        this.fLabel.setIcon(icon != null ? icon : UiFileSystemUtils.getIconEvenIfNonExistent((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation(file), (ExtensionRegistry)ExplorerExtensionRegistry.getInstance()));
        this.fLabel.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ScreenerFileWidget.this.fLabel.setText(ScreenerFileWidget.generateHtml(file, n, true));
                ScreenerFileWidget.this.startHoverTimer();
            }
        });
        this.fLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MLEditorServices.getEditorApplication().openEditor(file).goToLine(n2, false);
            }
        });
    }

    public JComponent getComponent() {
        return this.fLabel;
    }

    private void startHoverTimer() {
        if (this.fHoverTimer == null) {
            this.fHoverTimer = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Point point;
                    PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                    if (pointerInfo != null && (point = pointerInfo.getLocation()) != null) {
                        Point point2 = ScreenerFileWidget.this.fLabel.getLocation();
                        SwingUtilities.convertPointToScreen(point2, ScreenerFileWidget.this.fLabel.getParent());
                        Rectangle rectangle = new Rectangle(point2, ScreenerFileWidget.this.fLabel.getSize());
                        if (rectangle.contains(point)) {
                            return;
                        }
                    }
                    ScreenerFileWidget.this.fLabel.setText(ScreenerFileWidget.generateHtml(ScreenerFileWidget.this.fFile, ScreenerFileWidget.this.fOffenseCount, false));
                    ScreenerFileWidget.this.fHoverTimer.stop();
                    ScreenerFileWidget.this.fHoverTimer = null;
                }
            });
            this.fHoverTimer.start();
        }
    }

    private static String generateHtml(File file, int n, boolean bl) {
        return "<html>" + (bl ? "<u>" : "") + file.getName() + (bl ? "</u>" : "") + (n > 0 ? " <font color=\"#444444\">  " + n + "</font></html>" : "");
    }
}

