/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SignatureDSA;
import com.jcraft.jsch.SignatureRSA;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;

class IdentityFile
implements Identity {
    String identity;
    byte[] key;
    byte[] iv;
    private JSch jsch;
    private HASH hash;
    private byte[] encoded_data;
    private Cipher cipher;
    private byte[] P_array;
    private byte[] Q_array;
    private byte[] G_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private byte[] n_array;
    private byte[] e_array;
    private byte[] d_array;
    private String algname = "ssh-rsa";
    private static final int ERROR = 0;
    private static final int RSA = 1;
    private static final int DSS = 2;
    private static final int UNKNOWN = 3;
    private static final int OPENSSH = 0;
    private static final int FSECURE = 1;
    private static final int PUTTY = 2;
    private int type = 0;
    private int keytype = 0;
    private byte[] publickeyblob = null;
    private boolean encrypted = true;

    static IdentityFile newInstance(String prvfile, String pubfile, JSch jsch) throws JSchException {
        byte[] pubkey;
        byte[] prvkey;
        block15: {
            prvkey = null;
            pubkey = null;
            File file = null;
            FileInputStream fis = null;
            try {
                int i;
                file = new File(prvfile);
                fis = new FileInputStream(prvfile);
                prvkey = new byte[(int)file.length()];
                int len = 0;
                while ((i = fis.read(prvkey, len, prvkey.length - len)) > 0) {
                    len += i;
                }
                fis.close();
            }
            catch (Exception e) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                if (e instanceof Throwable) {
                    throw new JSchException(e.toString(), e);
                }
                throw new JSchException(e.toString());
            }
            String _pubfile = pubfile;
            if (pubfile == null) {
                _pubfile = prvfile + ".pub";
            }
            try {
                int i;
                file = new File(_pubfile);
                fis = new FileInputStream(_pubfile);
                pubkey = new byte[(int)file.length()];
                int len = 0;
                while ((i = fis.read(pubkey, len, pubkey.length - len)) > 0) {
                    len += i;
                }
                fis.close();
            }
            catch (Exception e) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                if (pubfile == null) break block15;
                if (e instanceof Throwable) {
                    throw new JSchException(e.toString(), e);
                }
                throw new JSchException(e.toString());
            }
        }
        return IdentityFile.newInstance(prvfile, prvkey, pubkey, jsch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdentityFile newInstance(String name, byte[] prvkey, byte[] pubkey, JSch jsch) throws JSchException {
        try {
            IdentityFile identityFile = new IdentityFile(name, prvkey, pubkey, jsch);
            return identityFile;
        }
        finally {
            Util.bzero(prvkey);
        }
    }

    private IdentityFile(String name, byte[] prvkey, byte[] pubkey, JSch jsch) throws JSchException {
        this.identity = name;
        this.jsch = jsch;
        try {
            int i;
            Class<?> c = Class.forName(JSch.getConfig("3des-cbc"));
            this.cipher = (Cipher)c.newInstance();
            this.key = new byte[this.cipher.getBlockSize()];
            this.iv = new byte[this.cipher.getIVSize()];
            c = Class.forName(JSch.getConfig("md5"));
            this.hash = (HASH)c.newInstance();
            this.hash.init();
            byte[] buf = prvkey;
            int len = buf.length;
            for (i = 0; i < len && (buf[i] != 45 || i + 4 >= len || buf[i + 1] != 45 || buf[i + 2] != 45 || buf[i + 3] != 45 || buf[i + 4] != 45); ++i) {
            }
            while (i < len) {
                if (buf[i] == 66 && i + 3 < len && buf[i + 1] == 69 && buf[i + 2] == 71 && buf[i + 3] == 73) {
                    if (buf[i += 6] == 68 && buf[i + 1] == 83 && buf[i + 2] == 65) {
                        this.type = 2;
                    } else if (buf[i] == 82 && buf[i + 1] == 83 && buf[i + 2] == 65) {
                        this.type = 1;
                    } else if (buf[i] == 83 && buf[i + 1] == 83 && buf[i + 2] == 72) {
                        this.type = 3;
                        this.keytype = 1;
                    } else {
                        throw new JSchException("invalid privatekey: " + this.identity);
                    }
                    i += 3;
                    continue;
                }
                if (buf[i] == 65 && i + 7 < len && buf[i + 1] == 69 && buf[i + 2] == 83 && buf[i + 3] == 45 && buf[i + 4] == 50 && buf[i + 5] == 53 && buf[i + 6] == 54 && buf[i + 7] == 45) {
                    i += 8;
                    if (Session.checkCipher(JSch.getConfig("aes256-cbc"))) {
                        c = Class.forName(JSch.getConfig("aes256-cbc"));
                        this.cipher = (Cipher)c.newInstance();
                        this.key = new byte[this.cipher.getBlockSize()];
                        this.iv = new byte[this.cipher.getIVSize()];
                        continue;
                    }
                    throw new JSchException("privatekey: aes256-cbc is not available " + this.identity);
                }
                if (buf[i] == 67 && i + 3 < len && buf[i + 1] == 66 && buf[i + 2] == 67 && buf[i + 3] == 44) {
                    i += 4;
                    for (int ii = 0; ii < this.iv.length; ++ii) {
                        this.iv[ii] = (byte)((this.a2b(buf[i++]) << 4 & 0xF0) + (this.a2b(buf[i++]) & 0xF));
                    }
                    continue;
                }
                if (buf[i] == 13 && i + 1 < len && buf[i + 1] == 10) {
                    ++i;
                    continue;
                }
                if (buf[i] == 10 && i + 1 < len) {
                    if (buf[i + 1] == 10) {
                        i += 2;
                        break;
                    }
                    if (buf[i + 1] == 13 && i + 2 < len && buf[i + 2] == 10) {
                        i += 3;
                        break;
                    }
                    boolean inheader = false;
                    for (int j = i + 1; j < len && buf[j] != 10; ++j) {
                        if (buf[j] != 58) continue;
                        inheader = true;
                        break;
                    }
                    if (!inheader) {
                        ++i;
                        this.encrypted = false;
                        break;
                    }
                }
                ++i;
            }
            if (this.type == 0) {
                throw new JSchException("invalid privatekey: " + this.identity);
            }
            int start = i;
            while (i < len) {
                if (buf[i] == 10) {
                    boolean xd = buf[i - 1] == 13;
                    System.arraycopy(buf, i + 1, buf, i - (xd ? 1 : 0), len - i - 1 - (xd ? 1 : 0));
                    if (xd) {
                        --len;
                    }
                    --len;
                    continue;
                }
                if (buf[i] == 45) break;
                ++i;
            }
            this.encoded_data = Util.fromBase64(buf, start, i - start);
            if (this.encoded_data.length > 4 && this.encoded_data[0] == 63 && this.encoded_data[1] == 111 && this.encoded_data[2] == -7 && this.encoded_data[3] == -21) {
                Buffer _buf = new Buffer(this.encoded_data);
                _buf.getInt();
                _buf.getInt();
                byte[] _type = _buf.getString();
                byte[] _cipher = _buf.getString();
                String cipher = Util.byte2str(_cipher);
                if (cipher.equals("3des-cbc")) {
                    _buf.getInt();
                    byte[] foo = new byte[this.encoded_data.length - _buf.getOffSet()];
                    _buf.getByte(foo);
                    this.encoded_data = foo;
                    this.encrypted = true;
                    throw new JSchException("unknown privatekey format: " + this.identity);
                }
                if (cipher.equals("none")) {
                    _buf.getInt();
                    this.encrypted = false;
                    byte[] foo = new byte[this.encoded_data.length - _buf.getOffSet()];
                    _buf.getByte(foo);
                    this.encoded_data = foo;
                }
            }
            if (pubkey == null) {
                return;
            }
            buf = pubkey;
            len = buf.length;
            if (buf.length > 4 && buf[0] == 45 && buf[1] == 45 && buf[2] == 45 && buf[3] == 45) {
                i = 0;
                while (len > ++i && buf[i] != 10) {
                }
                if (len <= i) {
                    return;
                }
                while (i < len) {
                    if (buf[i] == 10) {
                        boolean inheader = false;
                        for (int j = i + 1; j < len && buf[j] != 10; ++j) {
                            if (buf[j] != 58) continue;
                            inheader = true;
                            break;
                        }
                        if (!inheader) {
                            ++i;
                            break;
                        }
                    }
                    ++i;
                }
                if (len <= i) {
                    return;
                }
                start = i;
                while (i < len) {
                    if (buf[i] == 10) {
                        System.arraycopy(buf, i + 1, buf, i, len - i - 1);
                        --len;
                        continue;
                    }
                    if (buf[i] == 45) break;
                    ++i;
                }
                this.publickeyblob = Util.fromBase64(buf, start, i - start);
                if (this.type == 3 && this.publickeyblob.length > 8) {
                    if (this.publickeyblob[8] == 100) {
                        this.type = 2;
                    } else if (this.publickeyblob[8] == 114) {
                        this.type = 1;
                    }
                }
            } else {
                if (buf[0] != 115 || buf[1] != 115 || buf[2] != 104 || buf[3] != 45) {
                    return;
                }
                for (i = 0; i < len && buf[i] != 32; ++i) {
                }
                if (++i >= len) {
                    return;
                }
                start = i;
                while (i < len && buf[i] != 32 && buf[i] != 10) {
                    ++i;
                }
                this.publickeyblob = Util.fromBase64(buf, start, i - start);
                if (this.publickeyblob.length < 11) {
                    if (JSch.getLogger().isEnabled(2)) {
                        JSch.getLogger().log(2, "failed to parse the public key");
                    }
                    this.publickeyblob = null;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof JSchException) {
                throw (JSchException)e;
            }
            if (e instanceof Throwable) {
                throw new JSchException(e.toString(), e);
            }
            throw new JSchException(e.toString());
        }
    }

    @Override
    public String getAlgName() {
        if (this.type == 1) {
            return "ssh-rsa";
        }
        return "ssh-dss";
    }

    @Override
    public boolean setPassphrase(byte[] _passphrase) throws JSchException {
        try {
            if (this.encrypted) {
                if (_passphrase == null) {
                    return false;
                }
                byte[] passphrase = _passphrase;
                int hsize = this.hash.getBlockSize();
                byte[] hn = new byte[this.key.length / hsize * hsize + (this.key.length % hsize == 0 ? 0 : hsize)];
                byte[] tmp = null;
                if (this.keytype == 0) {
                    int index = 0;
                    while (index + hsize <= hn.length) {
                        if (tmp != null) {
                            this.hash.update(tmp, 0, tmp.length);
                        }
                        this.hash.update(passphrase, 0, passphrase.length);
                        this.hash.update(this.iv, 0, this.iv.length > 8 ? 8 : this.iv.length);
                        tmp = this.hash.digest();
                        System.arraycopy(tmp, 0, hn, index, tmp.length);
                        index += tmp.length;
                    }
                    System.arraycopy(hn, 0, this.key, 0, this.key.length);
                } else if (this.keytype == 1) {
                    int index = 0;
                    while (index + hsize <= hn.length) {
                        if (tmp != null) {
                            this.hash.update(tmp, 0, tmp.length);
                        }
                        this.hash.update(passphrase, 0, passphrase.length);
                        tmp = this.hash.digest();
                        System.arraycopy(tmp, 0, hn, index, tmp.length);
                        index += tmp.length;
                    }
                    System.arraycopy(hn, 0, this.key, 0, this.key.length);
                }
                Util.bzero(passphrase);
            }
            if (this.decrypt()) {
                this.encrypted = false;
                return true;
            }
            this.prv_array = null;
            this.pub_array = null;
            this.G_array = null;
            this.Q_array = null;
            this.P_array = null;
            return false;
        }
        catch (Exception e) {
            if (e instanceof JSchException) {
                throw (JSchException)e;
            }
            if (e instanceof Throwable) {
                throw new JSchException(e.toString(), e);
            }
            throw new JSchException(e.toString());
        }
    }

    @Override
    public byte[] getPublicKeyBlob() {
        if (this.publickeyblob != null) {
            return this.publickeyblob;
        }
        if (this.type == 1) {
            return this.getPublicKeyBlob_rsa();
        }
        return this.getPublicKeyBlob_dss();
    }

    byte[] getPublicKeyBlob_rsa() {
        if (this.e_array == null) {
            return null;
        }
        Buffer buf = new Buffer("ssh-rsa".length() + 4 + this.e_array.length + 4 + this.n_array.length + 4);
        buf.putString(Util.str2byte("ssh-rsa"));
        buf.putString(this.e_array);
        buf.putString(this.n_array);
        return buf.buffer;
    }

    byte[] getPublicKeyBlob_dss() {
        if (this.P_array == null) {
            return null;
        }
        Buffer buf = new Buffer("ssh-dss".length() + 4 + this.P_array.length + 4 + this.Q_array.length + 4 + this.G_array.length + 4 + this.pub_array.length + 4);
        buf.putString(Util.str2byte("ssh-dss"));
        buf.putString(this.P_array);
        buf.putString(this.Q_array);
        buf.putString(this.G_array);
        buf.putString(this.pub_array);
        return buf.buffer;
    }

    @Override
    public byte[] getSignature(byte[] data) {
        if (this.type == 1) {
            return this.getSignature_rsa(data);
        }
        return this.getSignature_dss(data);
    }

    byte[] getSignature_rsa(byte[] data) {
        try {
            Class<?> c = Class.forName(JSch.getConfig("signature.rsa"));
            SignatureRSA rsa = (SignatureRSA)c.newInstance();
            rsa.init();
            rsa.setPrvKey(this.d_array, this.n_array);
            rsa.update(data);
            byte[] sig = rsa.sign();
            Buffer buf = new Buffer("ssh-rsa".length() + 4 + sig.length + 4);
            buf.putString(Util.str2byte("ssh-rsa"));
            buf.putString(sig);
            return buf.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    byte[] getSignature_dss(byte[] data) {
        try {
            Class<?> c = Class.forName(JSch.getConfig("signature.dss"));
            SignatureDSA dsa = (SignatureDSA)c.newInstance();
            dsa.init();
            dsa.setPrvKey(this.prv_array, this.P_array, this.Q_array, this.G_array);
            dsa.update(data);
            byte[] sig = dsa.sign();
            Buffer buf = new Buffer("ssh-dss".length() + 4 + sig.length + 4);
            buf.putString(Util.str2byte("ssh-dss"));
            buf.putString(sig);
            return buf.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean decrypt() {
        if (this.type == 1) {
            return this.decrypt_rsa();
        }
        return this.decrypt_dss();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean decrypt_rsa() {
        try {
            int foo;
            byte[] plain;
            if (this.encrypted) {
                if (this.keytype == 0) {
                    this.cipher.init(1, this.key, this.iv);
                    plain = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                } else {
                    if (this.keytype != 1) return false;
                    for (int i = 0; i < this.iv.length; ++i) {
                        this.iv[i] = 0;
                    }
                    this.cipher.init(1, this.key, this.iv);
                    plain = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                }
            } else {
                if (this.n_array != null) {
                    return true;
                }
                plain = this.encoded_data;
            }
            if (this.keytype == 1) {
                Buffer buf = new Buffer(plain);
                int foo2 = buf.getInt();
                if (plain.length != foo2 + 4) {
                    return false;
                }
                this.e_array = buf.getMPIntBits();
                this.d_array = buf.getMPIntBits();
                this.n_array = buf.getMPIntBits();
                byte[] u_array = buf.getMPIntBits();
                byte[] p_array = buf.getMPIntBits();
                byte[] q_array = buf.getMPIntBits();
                return true;
            }
            int index = 0;
            int length = 0;
            if (plain[index] != 48) {
                return false;
            }
            int n = ++index;
            ++index;
            length = plain[n] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            if (plain[index] != 2) {
                return false;
            }
            int n2 = ++index;
            ++index;
            length = plain[n2] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            index += length;
            int n3 = ++index;
            ++index;
            length = plain[n3] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.n_array = new byte[length];
            System.arraycopy(plain, index, this.n_array, 0, length);
            index += length;
            int n4 = ++index;
            ++index;
            length = plain[n4] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.e_array = new byte[length];
            System.arraycopy(plain, index, this.e_array, 0, length);
            index += length;
            int n5 = ++index;
            ++index;
            length = plain[n5] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.d_array = new byte[length];
            System.arraycopy(plain, index, this.d_array, 0, length);
            index += length;
            int n6 = ++index;
            ++index;
            length = plain[n6] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            byte[] p_array = new byte[length];
            System.arraycopy(plain, index, p_array, 0, length);
            index += length;
            int n7 = ++index;
            ++index;
            length = plain[n7] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            byte[] q_array = new byte[length];
            System.arraycopy(plain, index, q_array, 0, length);
            index += length;
            int n8 = ++index;
            ++index;
            length = plain[n8] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            byte[] dmp1_array = new byte[length];
            System.arraycopy(plain, index, dmp1_array, 0, length);
            index += length;
            int n9 = ++index;
            ++index;
            length = plain[n9] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            byte[] dmq1_array = new byte[length];
            System.arraycopy(plain, index, dmq1_array, 0, length);
            index += length;
            int n10 = ++index;
            ++index;
            length = plain[n10] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            byte[] iqmp_array = new byte[length];
            System.arraycopy(plain, index, iqmp_array, 0, length);
            index += length;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean decrypt_dss() {
        try {
            int foo;
            byte[] plain;
            if (this.encrypted) {
                if (this.keytype == 0) {
                    this.cipher.init(1, this.key, this.iv);
                    plain = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                } else {
                    if (this.keytype != 1) return false;
                    for (int i = 0; i < this.iv.length; ++i) {
                        this.iv[i] = 0;
                    }
                    this.cipher.init(1, this.key, this.iv);
                    plain = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                }
            } else {
                if (this.P_array != null) {
                    return true;
                }
                plain = this.encoded_data;
            }
            if (this.keytype == 1) {
                Buffer buf = new Buffer(plain);
                int foo2 = buf.getInt();
                if (plain.length != foo2 + 4) {
                    return false;
                }
                this.P_array = buf.getMPIntBits();
                this.G_array = buf.getMPIntBits();
                this.Q_array = buf.getMPIntBits();
                this.pub_array = buf.getMPIntBits();
                this.prv_array = buf.getMPIntBits();
                return true;
            }
            int index = 0;
            int length = 0;
            if (plain[index] != 48) {
                return false;
            }
            int n = ++index;
            ++index;
            length = plain[n] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            if (plain[index] != 2) {
                return false;
            }
            int n2 = ++index;
            ++index;
            length = plain[n2] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            index += length;
            int n3 = ++index;
            ++index;
            length = plain[n3] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.P_array = new byte[length];
            System.arraycopy(plain, index, this.P_array, 0, length);
            index += length;
            int n4 = ++index;
            ++index;
            length = plain[n4] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.Q_array = new byte[length];
            System.arraycopy(plain, index, this.Q_array, 0, length);
            index += length;
            int n5 = ++index;
            ++index;
            length = plain[n5] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.G_array = new byte[length];
            System.arraycopy(plain, index, this.G_array, 0, length);
            index += length;
            int n6 = ++index;
            ++index;
            length = plain[n6] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.pub_array = new byte[length];
            System.arraycopy(plain, index, this.pub_array, 0, length);
            index += length;
            int n7 = ++index;
            ++index;
            length = plain[n7] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.prv_array = new byte[length];
            System.arraycopy(plain, index, this.prv_array, 0, length);
            int n8 = index + length;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isEncrypted() {
        return this.encrypted;
    }

    @Override
    public String getName() {
        return this.identity;
    }

    private byte a2b(byte c) {
        if (48 <= c && c <= 57) {
            return (byte)(c - 48);
        }
        if (97 <= c && c <= 122) {
            return (byte)(c - 97 + 10);
        }
        return (byte)(c - 65 + 10);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IdentityFile)) {
            return super.equals(o);
        }
        IdentityFile foo = (IdentityFile)o;
        return this.getName().equals(foo.getName());
    }

    @Override
    public void clear() {
        Util.bzero(this.encoded_data);
        Util.bzero(this.prv_array);
        Util.bzero(this.d_array);
        Util.bzero(this.key);
        Util.bzero(this.iv);
    }

    public void finalize() {
        this.clear();
    }
}

