/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.TxnLogRecord;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.TxnManagerTransaction;
import com.sun.jini.mahalo.log.CannotRecoverException;
import java.util.logging.Level;
import java.util.logging.Logger;

class ParticipantModRecord
implements TxnLogRecord {
    static final long serialVersionUID = 5542043673924560855L;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private ParticipantHandle part;
    private int result;

    ParticipantModRecord(ParticipantHandle participantHandle, int n) {
        if (participantHandle == null) {
            throw new IllegalArgumentException("ParticipantModRecord: recover: non-null ParticipantHandle recover attempted");
        }
        this.part = participantHandle;
        this.result = n;
    }

    ParticipantHandle getPart() {
        return this.part;
    }

    int getResult() {
        return this.result;
    }

    public void recover(TxnManagerTransaction txnManagerTransaction) throws CannotRecoverException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(ParticipantModRecord.class.getName(), "recover", txnManagerTransaction);
        }
        if (txnManagerTransaction == null) {
            throw new NullPointerException("ParticipantModRecord: recover: non-null transaction must be specified");
        }
        txnManagerTransaction.modifyParticipant(this.getPart(), this.getResult());
        if (this.getResult() == 6) {
            txnManagerTransaction.modifyTxnState(6);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(ParticipantModRecord.class.getName(), "recover");
        }
    }
}

