/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import com.mathworks.mde.cmdhist.CmdHistoryWindow;
import com.mathworks.widgets.text.print.MultiHeaderTextPrinter;
import com.mathworks.widgets.text.print.PrintUtils;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class CmdHistoryPrinter {
    private CmdHistoryPrinter() {
    }

    private static String getMainHeaderText() {
        return CmdHistoryWindow.sRes.getString("printing.header.title") + "\t" + CmdHistoryWindow.sRes.getString("printing.header.pg") + " ";
    }

    protected static void print(JTree jTree) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            int n = treePath.getPathCount();
            for (int j = 0; j < n - 1; ++j) {
                stringBuilder.append('\u00a0');
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.isLeaf()) {
                stringBuilder.append('\u00a0');
            } else {
                stringBuilder.append(jTree.isCollapsed(i) ? "+" : "-");
            }
            stringBuilder.append(defaultMutableTreeNode.toString()).append('\n');
        }
        CmdHistoryPrinter.printSyntaxText(jTree, stringBuilder.toString());
    }

    protected static void print(JList jList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < jList.getModel().getSize(); ++i) {
            stringBuilder.append((String)jList.getModel().getElementAt(i)).append('\n');
        }
        CmdHistoryPrinter.printSyntaxText(jList, stringBuilder.toString());
    }

    private static void printSyntaxText(JComponent jComponent, String string) {
        MultiHeaderTextPrinter.printSyntaxText((String)string, (JComponent)jComponent, (Font)jComponent.getFont(), (String)CmdHistoryWindow.sRes.getString("printing.header.title"), (String)CmdHistoryPrinter.getMainHeaderText());
    }

    public static void pageSetup() {
        PrintUtils.showPageSetupDialog((String)CmdHistoryWindow.sRes.getString("printing.header.title"));
    }
}

