/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.dataimport;

import com.mathworks.mde.dataimport.DataPreviewPanel;
import com.mathworks.mde.dataimport.IVariableContentsOwner;
import com.mathworks.mde.dataimport.ImportProxy;
import com.mathworks.mde.dataimport.ImportUtils;
import com.mathworks.mde.dataimport.ImportWizardContents;
import com.mathworks.mde.dataimport.ValueSpecification;
import com.mathworks.mde.dataimport.VariableContentsViewer;
import com.mathworks.mlwidgets.workspace.ImportFileChooser;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.ColorPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.SwingUtilities;

class DataSourceSelectionPanel
extends MJPanel
implements IVariableContentsOwner {
    private static final String SOURCE_TYPE_FILE = "FILE";
    private static final String SOURCE_TYPE_CLIPBOARD = "CLIPBOARD";
    private static final String MOVIE = "MOVIE";
    private static final String IMAGE = "IMAGE";
    private static final String SOUND = "SOUND";
    private static final String ROW_HEADERS = "rowheaders";
    private static final String COL_HEADERS = "colheaders";
    private static final Object EMPTY_IMAGINARY_PLACEHOLDER = new Object();
    private String fDataSourceType;
    private File fFileToImport;
    private DataPreviewPanel fDataPreviewPanel;
    private ImportProxy fImportProxy;
    private Map<String, Object> fVarPreviewReal;
    private Map<String, Object> fVarPreviewImag;
    private Map<String, VariableContentsViewer> fRequestorHashtable;
    private boolean fNextAvailable;
    private static ImportWizardContents sIWC = null;

    DataSourceSelectionPanel(ImportWizardContents importWizardContents, ImportProxy importProxy, File file, boolean bl) {
        this.fFileToImport = file;
        this.fNextAvailable = false;
        this.fImportProxy = importProxy;
        sIWC = importWizardContents;
        this.fVarPreviewReal = new Hashtable<String, Object>();
        this.fVarPreviewImag = new Hashtable<String, Object>();
        this.fRequestorHashtable = new Hashtable<String, VariableContentsViewer>();
        this.fDataSourceType = bl ? SOURCE_TYPE_CLIPBOARD : SOURCE_TYPE_FILE;
        this.fDataPreviewPanel = new DataPreviewPanel(this.fImportProxy, bl || file != null, sIWC);
        this.refreshPreviewBorder();
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.fDataPreviewPanel), "Center");
        if (!bl) {
            this.fileCommand();
        } else {
            this.clipboardCommand();
        }
        this.resetColors();
    }

    void resetColors() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.resetColorsDispatch();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataSourceSelectionPanel.this.resetColorsDispatch();
                }
            });
        }
    }

    private void resetColorsDispatch() {
        Color color = ColorPrefs.getTextColor();
        Color color2 = ColorPrefs.getBackgroundColor();
        this.fDataPreviewPanel.setPreviewForeground(color);
        this.fDataPreviewPanel.setPreviewBackground(color2);
    }

    private void fileCommand() {
        this.setDataSourceType(SOURCE_TYPE_FILE);
        this.handleNextEnabled();
    }

    private void clipboardCommand() {
        this.setDataSourceType(SOURCE_TYPE_CLIPBOARD);
        this.handleNextEnabled();
    }

    void browse() {
        ImportFileChooser.showImportFileDialog((Component)((Object)this));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataSourceSelectionPanel.this.handleNextEnabled();
            }
        });
    }

    public static String getCurrentWorksheetname() {
        return sIWC.getCurrentWorksheetname();
    }

    private void setDataSourceType(String string) {
        this.fDataSourceType = string;
    }

    private boolean isDataSourceFile() {
        return this.fDataSourceType.equals(SOURCE_TYPE_FILE);
    }

    private boolean isDataSourceClipboard() {
        return this.fDataSourceType.equals(SOURCE_TYPE_CLIPBOARD);
    }

    void setPreviewTextContents(String string, boolean bl, String[] stringArray, boolean bl2) {
        this.fDataPreviewPanel.setPreviewTextContents(string, stringArray);
        if (!bl2 && bl) {
            this.fImportProxy.requestVariableList(this.fDataPreviewPanel.getCurrentWorksheetName());
        }
    }

    /*
     * WARNING - void declaration
     */
    void setPreviewTabList(int n, String[] stringArray, String[] stringArray2, String[] stringArray3, long[] lArray, String string) {
        sIWC.setCurrentWorksheetname(string);
        sIWC.clearCurrentVariableNames();
        if (SwingUtilities.isEventDispatchThread()) {
            this.fDataPreviewPanel.cleanupTabbedPane();
            if (stringArray == null || stringArray.length == 0) {
                this.fDataPreviewPanel.addNoDataTab();
                this.fNextAvailable = false;
            } else {
                VariableContentsViewer variableContentsViewer;
                if (n != 0) {
                    void var8_14;
                    this.fNextAvailable = true;
                    String string2 = null;
                    Object object = null;
                    String string3 = null;
                    switch (n) {
                        case 1: {
                            string2 = ImportUtils.getResource("dssp.movie.preview");
                            String string4 = ImportUtils.getResource("dssp.movie.play");
                            string3 = MOVIE;
                            break;
                        }
                        case 2: {
                            string2 = ImportUtils.getResource("dssp.image.preview");
                            String string5 = ImportUtils.getResource("dssp.image.play");
                            string3 = IMAGE;
                            break;
                        }
                        case 3: {
                            string2 = ImportUtils.getResource("dssp.sound.preview");
                            String string6 = ImportUtils.getResource("dssp.sound.play");
                            string3 = SOUND;
                        }
                    }
                    MJButton mJButton = new MJButton((String)var8_14);
                    mJButton.setEnabled(true);
                    mJButton.setActionCommand(string3);
                    mJButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = actionEvent.getActionCommand();
                            if (string.equals(DataSourceSelectionPanel.MOVIE)) {
                                DataSourceSelectionPanel.this.fImportProxy.requestMoviePreview(DataSourceSelectionPanel.this.fFileToImport);
                            }
                            if (string.equals(DataSourceSelectionPanel.IMAGE)) {
                                DataSourceSelectionPanel.this.fImportProxy.requestImagePreview(DataSourceSelectionPanel.this.fFileToImport);
                            }
                            if (string.equals(DataSourceSelectionPanel.SOUND)) {
                                DataSourceSelectionPanel.this.fImportProxy.requestSoundPreview(DataSourceSelectionPanel.this.fFileToImport);
                            }
                        }
                    });
                    mJButton.setName("ShowPreview");
                    String string7 = new MJPanel((LayoutManager)new FlowLayout());
                    string7.setLayout((LayoutManager)new FlowLayout());
                    string7.add((Component)mJButton);
                    variableContentsViewer = new MJPanel((LayoutManager)new BorderLayout());
                    variableContentsViewer.add((Component)((Object)string7), "North");
                    this.fDataPreviewPanel.addTab(string2, (Component)((Object)variableContentsViewer));
                }
                this.fNextAvailable = false;
                int n2 = 0;
                for (String string7 : stringArray) {
                    if (DataSourceSelectionPanel.isUsed(stringArray2, stringArray3, lArray[n2], string7)) {
                        this.fNextAvailable = true;
                        sIWC.addVariableName(string7);
                        variableContentsViewer = new VariableContentsViewer(this, new ValueSpecification(string7, -1, -1, string));
                        variableContentsViewer.setName("VariableContentsViewer");
                        this.fDataPreviewPanel.addTab(string7, (Component)((Object)variableContentsViewer));
                    }
                    ++n2;
                }
            }
            this.doNextEnabled();
        } else {
            PreviewTabListUpdater previewTabListUpdater = new PreviewTabListUpdater(n, stringArray, stringArray2, stringArray3, lArray, string);
            SwingUtilities.invokeLater(previewTabListUpdater);
        }
    }

    private static boolean isUsed(String[] stringArray, String[] stringArray2, long l, String string) {
        if (sIWC.isSpreasheetFile()) {
            return l > 0L && (!COL_HEADERS.equals(string) && !ROW_HEADERS.equals(string) || stringArray != null && COL_HEADERS.equals(string) || stringArray2 != null && ROW_HEADERS.equals(string));
        }
        return !COL_HEADERS.equals(string) && !ROW_HEADERS.equals(string) || stringArray != null && COL_HEADERS.equals(string) || stringArray2 != null && ROW_HEADERS.equals(string);
    }

    private void handleNextEnabled() {
        boolean bl = DataSourceSelectionPanel.calculateNextAvailable();
        if (!bl) {
            this.fNextAvailable = false;
            this.refreshPreviewBorder();
        }
        this.doNextEnabled();
    }

    private void doNextEnabled() {
        this.putClientProperty("NAVIGATION_CHANGED", new Object());
    }

    public boolean isNextAvailable() {
        return this.fNextAvailable;
    }

    private void refreshPreviewBorder() {
        String string = ImportUtils.getResource("dssp.dataPreview");
        if (this.isDataSourceClipboard()) {
            string = ImportUtils.getResource("dssp.clipboardPreview");
            this.setPreviewTextContents("", false, null, false);
            this.fImportProxy.requestFilePreview(null);
        }
        if (this.isDataSourceFile()) {
            string = ImportUtils.getResource("dssp.argPreview", this.fFileToImport.getAbsolutePath());
            this.setPreviewTextContents(ImportUtils.getResource("dssp.creatingPreview"), false, null, false);
            this.fImportProxy.requestFilePreview(this.fFileToImport);
        }
        this.fDataPreviewPanel.setTitle(string);
    }

    private static boolean calculateNextAvailable() {
        return true;
    }

    public static boolean isBackAvailable() {
        return false;
    }

    public static boolean isFinishAvailable() {
        return false;
    }

    @Override
    public void getVariablePreviewData(VariableContentsViewer variableContentsViewer, ValueSpecification valueSpecification) {
        String string = valueSpecification.getHashtableKey();
        if (this.fVarPreviewReal.containsKey(string)) {
            Object object = this.fVarPreviewReal.get(string);
            Object object2 = this.fVarPreviewImag.get(string);
            if (object2.equals(EMPTY_IMAGINARY_PLACEHOLDER)) {
                object2 = null;
            }
            if (!(object instanceof String)) {
                if (object instanceof double[][]) {
                    variableContentsViewer.setContents((double[][])object, (double[][])object2);
                } else {
                    variableContentsViewer.setContents((int[][])object, (int[][])object2);
                }
            } else {
                variableContentsViewer.setContents((String)object);
            }
        } else {
            variableContentsViewer.setContents(ImportUtils.getResource("dssp.creatingPreview"));
            this.fRequestorHashtable.put(string, variableContentsViewer);
            this.fImportProxy.requestVariablePreviewData(this, valueSpecification);
        }
    }

    @Override
    public void addVariablePreviewData(ValueSpecification valueSpecification, String string) {
        VariableContentsViewer variableContentsViewer = this.putVariablePreviewData(valueSpecification, string, null);
        if (variableContentsViewer != null) {
            variableContentsViewer.setContents(string);
        }
    }

    @Override
    public void addVariablePreviewData(ValueSpecification valueSpecification, double[][] dArray, double[][] dArray2) {
        VariableContentsViewer variableContentsViewer = this.putVariablePreviewData(valueSpecification, dArray, dArray2);
        if (variableContentsViewer != null) {
            variableContentsViewer.setContents(dArray, dArray2);
        }
    }

    @Override
    public void addVariablePreviewData(ValueSpecification valueSpecification, int[][] nArray, int[][] nArray2) {
        VariableContentsViewer variableContentsViewer = this.putVariablePreviewData(valueSpecification, nArray, nArray2);
        if (variableContentsViewer != null) {
            variableContentsViewer.setContents(nArray, nArray2);
        }
    }

    private VariableContentsViewer putVariablePreviewData(ValueSpecification valueSpecification, Object object, Object object2) {
        String string = valueSpecification.getHashtableKey();
        this.fVarPreviewReal.put(string, object);
        this.fVarPreviewImag.put(string, object2 == null ? EMPTY_IMAGINARY_PLACEHOLDER : object2);
        return this.fRequestorHashtable.containsKey(string) ? this.fRequestorHashtable.get(string) : null;
    }

    public void cleanup() {
        this.fVarPreviewReal = null;
        this.fVarPreviewImag = null;
        this.fRequestorHashtable = null;
        this.fDataPreviewPanel.cleanup();
        this.fDataPreviewPanel = null;
        this.fImportProxy = null;
    }

    private class PreviewTabListUpdater
    implements Runnable {
        private int fFileTypeCode;
        private final String[] fTabs;
        private final long[] fByteses;
        private String fWorksheetName;
        private String[] fColHeaders;
        private String[] fRowHeaders;

        PreviewTabListUpdater(int n, String[] stringArray, String[] stringArray2, String[] stringArray3, long[] lArray, String string) {
            this.fFileTypeCode = n;
            this.fWorksheetName = string;
            this.fTabs = stringArray != null ? (String[])stringArray.clone() : null;
            this.fByteses = lArray != null ? (long[])lArray.clone() : null;
            this.fColHeaders = stringArray2 != null ? (String[])stringArray2.clone() : null;
            this.fRowHeaders = stringArray3 != null ? (String[])stringArray3.clone() : null;
        }

        @Override
        public void run() {
            DataSourceSelectionPanel.this.setPreviewTabList(this.fFileTypeCode, this.fTabs, this.fColHeaders, this.fRowHeaders, this.fByteses, this.fWorksheetName);
        }
    }
}

