/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.explorer;

import com.mathworks.matlab.api.explorer.ActionComponentProvider;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.mlwidgets.mlservices.scc.MWSccManager;
import com.mathworks.mlwidgets.mlservices.scc.SccFileListener;
import com.mathworks.mlwidgets.mlservices.scc.SccFileProvider;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.FileEvent;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.JComponent;

public class SourceControlActionProvider
implements ActionProvider {
    private static final ActionDefinition sScmMenuPlaceholder = new ActionDefinition("scmMenu", CoreMenuSection.DIFF_SCM.getSection(), "scmMenu");
    private final SccAdapter fAdapter = new SccAdapter();

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return fileSystemEntry == null || fileSystemEntry.isReal();
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.defineAction(sScmMenuPlaceholder).setMenuComponentProvider(SelectionMode.MULTIPLE_SELECTION_OR_CURRENT_LOCATION, new ActionComponentProvider(){

            public JComponent getComponent(ActionInput actionInput) {
                MJMenu mJMenu = MWSccManager.getSccMenu((SccFileProvider)SourceControlActionProvider.this.fAdapter);
                SourceControlActionProvider.this.fAdapter.setInput(actionInput);
                return mJMenu;
            }
        });
    }

    private static class SccAdapter
    implements SccFileProvider {
        private SccFileListener fFileListener;
        private String[] fSelectedFiles;
        private Frame fFrame;

        SccAdapter() {
            MWSccManager.registerSccFileProvider((SccFileProvider)this);
        }

        public void installSccFileListener(SccFileListener sccFileListener) {
            this.fFileListener = sccFileListener;
        }

        public void uinstallSccFileListener() {
            this.fFileListener = null;
        }

        public boolean save(String string) {
            return false;
        }

        public String[] getSelectedFiles() {
            return (String[])this.fSelectedFiles.clone();
        }

        public Frame getFrame(String string) {
            return this.fFrame;
        }

        void setInput(ActionInput actionInput) {
            this.fFrame = WindowUtils.getFrameForComponent((Component)actionInput.getComponent());
            this.fSelectedFiles = new String[actionInput.getSelection().size()];
            List list = actionInput.getSelection();
            for (int i = 0; i < this.fSelectedFiles.length; ++i) {
                this.fSelectedFiles[i] = ((FileSystemEntry)list.get(i)).getLocation().toString();
            }
            if (this.fFileListener != null) {
                this.fFileListener.fileSelectionChanged(new FileEvent((Object)this, 7));
            }
        }
    }
}

