/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceEntityRequest;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.helpsearch.reference.ReferenceRetrievalStrategy;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.MLHelpBrowserTask;
import com.mathworks.mde.help.OverloadMessageBar;
import com.mathworks.mde.help.ReferenceDataUtils;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocCommandHelpBrowserTask
implements MLHelpBrowserTask {
    private static final Pattern TOPIC_PRODUCT_PATTERN = Pattern.compile("^([^/]+)/(.+)$");
    public static final Collection<RefEntityType> MUPAD_TYPES = DocCommandHelpBrowserTask.getMupadRefEntityTypes();
    public static final Collection<RefEntityType> NON_MUPAD_TYPES = DocCommandHelpBrowserTask.getNonMupadRefEntityTypes();
    private final DocumentationSet fDocSet;
    private final String fDocRoot;
    private final ReferenceDataRetriever fRetriever;
    private String fTopic;
    private List<ReferenceData> fRefData;

    public DocCommandHelpBrowserTask(SearchHelper searchHelper, String string) {
        this(searchHelper.getDocumentationSet(), string, (ReferenceRetrievalStrategy)DocCenterReferenceRetrievalStrategy.getInstance((SearchHelper)searchHelper));
    }

    public DocCommandHelpBrowserTask(DocumentationSet documentationSet, String string, ReferenceRetrievalStrategy referenceRetrievalStrategy) {
        this.fDocSet = documentationSet;
        this.fDocRoot = string;
        this.fRetriever = referenceRetrievalStrategy == null ? null : new ReferenceDataRetriever(referenceRetrievalStrategy);
    }

    public boolean findReferencePages(String string, boolean bl) {
        this.fTopic = string;
        this.fRefData = this.populateRefPages(string, bl);
        return this.fRefData != null && !this.fRefData.isEmpty();
    }

    @Override
    public String getUrlToDisplay() {
        return ReferenceDataUtils.getPageLocation(this.fDocRoot, this.fRefData.get(0));
    }

    @Override
    public void updateHelpBrowser(MLHelpBrowser mLHelpBrowser) {
        if (this.fRefData.size() > 1) {
            this.addMessageBar(mLHelpBrowser);
        }
    }

    @Override
    public void cleanup() {
        try {
            this.fRetriever.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void addMessageBar(MLHelpBrowser mLHelpBrowser) {
        OverloadMessageBar overloadMessageBar = new OverloadMessageBar(mLHelpBrowser, this.fDocRoot, this.fTopic, this.fRefData);
        overloadMessageBar.install();
    }

    private List<ReferenceData> populateRefPages(String string, boolean bl) {
        if (this.fRetriever == null) {
            return null;
        }
        ReferenceRequest referenceRequest = this.getReferenceRequest(string, bl);
        if (referenceRequest != null) {
            return this.fRetriever.getReferenceData(referenceRequest);
        }
        return null;
    }

    private ReferenceRequest getReferenceRequest(String string, boolean bl) {
        Matcher matcher = TOPIC_PRODUCT_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            string = matcher.group(2);
            if (string2.equalsIgnoreCase("mupad")) {
                ReferenceEntityRequest referenceEntityRequest = new ReferenceEntityRequest(string, MUPAD_TYPES);
                referenceEntityRequest.setMatchCase(true);
                return referenceEntityRequest;
            }
            Collection<RefEntityType> collection = DocCommandHelpBrowserTask.getRefEntityTypes(bl);
            DocProduct docProduct = this.fDocSet.getProductByIndexString(string2);
            if (docProduct != null) {
                return new ReferenceEntityRequest(string, docProduct, collection);
            }
            return null;
        }
        Collection<RefEntityType> collection = DocCommandHelpBrowserTask.getRefEntityTypes(bl);
        return new ReferenceEntityRequest(string, collection);
    }

    private static Collection<RefEntityType> getRefEntityTypes(boolean bl) {
        if (bl) {
            return EnumSet.of(RefEntityType.FUNCTION, RefEntityType.CLASS, RefEntityType.METHOD, RefEntityType.PROPERTY);
        }
        return NON_MUPAD_TYPES;
    }

    private static Collection<RefEntityType> getMupadRefEntityTypes() {
        EnumSet<RefEntityType> enumSet = EnumSet.noneOf(RefEntityType.class);
        for (RefEntityType refEntityType : RefEntityType.values()) {
            if (!refEntityType.toString().toLowerCase(Locale.ENGLISH).startsWith("mupad")) continue;
            enumSet.add(refEntityType);
        }
        return enumSet;
    }

    private static Collection<RefEntityType> getNonMupadRefEntityTypes() {
        EnumSet<RefEntityType> enumSet = EnumSet.allOf(RefEntityType.class);
        enumSet.removeAll(DocCommandHelpBrowserTask.getMupadRefEntityTypes());
        return enumSet;
    }
}

