/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.mde.help.HelpInfoBarComponent;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.ReferenceDataUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.text.Format;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class OverloadMessageBar
implements HelpInfoBarComponent {
    private static final MessageFormat LINK_FORMAT = new MessageFormat("<a href=\"{0}\">{1}</a>");
    private static final int NUM_PER_LINE = 5;
    private final CloseMessageBarListener fCloseListener;
    private final MLHelpBrowser fHelpBrowser;
    private final String fDocRoot;
    private final String fTopic;
    private final List<ReferenceData> fAllRefData;
    private boolean fShowAll = false;
    private ReferenceData fSelected;

    public OverloadMessageBar(MLHelpBrowser mLHelpBrowser, String string, String string2, List<ReferenceData> list) {
        this.fHelpBrowser = mLHelpBrowser;
        this.fTopic = string2;
        this.fAllRefData = list;
        this.fDocRoot = string;
        this.fCloseListener = new CloseMessageBarListener();
        this.fSelected = list.get(0);
    }

    @Override
    public JComponent getComponent() {
        String string = this.buildMessage();
        JComponent jComponent = new HyperlinkTextLabel(string, (HyperlinkTextLabel.HyperlinkHandler)new OverloadLinkHandler()).getComponent();
        jComponent.setName("Doc Overload Message Label");
        return jComponent;
    }

    @Override
    public void infoBarRemoved() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OverloadMessageBar.this.fHelpBrowser.removePageChangedListener(OverloadMessageBar.this.fCloseListener);
            }
        });
    }

    @Override
    public String getMessageBarName() {
        return "Doc Overload Message Bar";
    }

    void install() {
        this.fHelpBrowser.addInfoMessageBar(this);
        this.fHelpBrowser.addPageChangedListener(this.fCloseListener);
    }

    private String buildMessage() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder("<html>");
        MessageFormat messageFormat = new MessageFormat(HelpUtils.getLocalizedString((String)"doccenter.overloads.message"));
        stringBuilder.append(messageFormat.format(new Object[]{this.fTopic})).append(' ');
        int n = this.fAllRefData.size() - 1;
        if (n > 2) {
            stringBuilder.append("<br>");
        }
        int n2 = this.fShowAll ? n : Math.min(n, 5);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            object = this.fAllRefData.get(n4);
            if (!object.equals(this.fSelected)) {
                if (n3 > 0) {
                    stringBuilder.append(", ");
                    if (n3 % 5 == 0) {
                        stringBuilder.append("<br>");
                    }
                }
                String string = object.getProduct().getShortName() + "/" + object.getTopic();
                stringBuilder.append(OverloadMessageBar.createHyperlink(String.valueOf(n4), string));
                ++n3;
            }
            ++n4;
        }
        if (n2 < n) {
            n4 = n - n2;
            object = new MessageFormat(HelpUtils.getLocalizedString((String)"doccenter.overloads.more"));
            stringBuilder.append(", ").append(OverloadMessageBar.createHyperlink("more", ((Format)object).format(new Object[]{n4})));
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static String createHyperlink(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        return LINK_FORMAT.format(objectArray);
    }

    private class CloseMessageBarListener
    implements PageChangedListener {
        private CloseMessageBarListener() {
        }

        public void pageChanged(PageChangedEvent pageChangedEvent) {
            String string = pageChangedEvent.getFullUrl();
            if (!ReferenceDataUtils.isMatchingReferencePage(OverloadMessageBar.this.fDocRoot, OverloadMessageBar.this.fSelected, string)) {
                OverloadMessageBar.this.fHelpBrowser.removeInfoMessageBar(OverloadMessageBar.this);
            }
        }
    }

    private class OverloadLinkHandler
    implements HyperlinkTextLabel.HyperlinkHandler {
        private OverloadLinkHandler() {
        }

        public void processHyperlink(String string) {
            if (string.equals("more")) {
                OverloadMessageBar.this.fShowAll = true;
                OverloadMessageBar.this.install();
            } else {
                int n = Integer.parseInt(string);
                OverloadMessageBar.this.fSelected = (ReferenceData)OverloadMessageBar.this.fAllRefData.get(n);
                OverloadMessageBar.this.install();
                String string2 = ReferenceDataUtils.getPageLocation(OverloadMessageBar.this.fDocRoot, OverloadMessageBar.this.fSelected);
                OverloadMessageBar.this.fHelpBrowser.setCurrentLocation(string2);
            }
        }
    }
}

