/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchHighlight {
    private String fHighlightText;
    private List<Extent> fExtents;

    public SearchHighlight(String string, List<Extent> list) {
        this.fHighlightText = string;
        this.fExtents = new ArrayList<Extent>(list);
    }

    public String getHighlightText() {
        return this.fHighlightText;
    }

    public List<Extent> getExtents() {
        return Collections.unmodifiableList(this.fExtents);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Extent extent : this.fExtents) {
            stringBuilder.append(this.fHighlightText.substring(n, extent.getStart()));
            stringBuilder.append('[');
            stringBuilder.append(this.fHighlightText.substring(extent.getStart(), extent.getEnd()));
            stringBuilder.append(']');
            n = extent.getEnd();
        }
        stringBuilder.append(this.fHighlightText.substring(n));
        return stringBuilder.toString();
    }

    public static class Extent {
        private int iStart;
        private int iEnd;

        public Extent(int n, int n2) {
            this.iStart = n;
            this.iEnd = n2;
        }

        public int getStart() {
            return this.iStart;
        }

        public int getEnd() {
            return this.iEnd;
        }

        public String toString() {
            return "[" + this.iStart + " : " + this.iEnd + "]";
        }
    }
}

