/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.DocSearchPageChangedListener;
import com.mathworks.help.helpui.HelpBrowserComponent;
import com.mathworks.help.helpui.HelpBrowserComponentHelper;
import com.mathworks.help.helpui.HelpBrowserFindHandler;
import com.mathworks.help.helpui.HelpBrowserLocaleHelper;
import com.mathworks.help.helpui.HelpBrowserSearchHelper;
import com.mathworks.help.helpui.HelpBrowserToolBar;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.HelpBrowserWindowListener;
import com.mathworks.help.helpui.suggestions.DocSuggestionProtocolHandler;
import com.mathworks.html.BasicHtmlActions;
import com.mathworks.html.DefaultViewSourceHandler;
import com.mathworks.html.FindInPageHandler;
import com.mathworks.html.FindPanel;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.StandardHtmlActionId;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class HelpBrowser {
    private final HelpBrowserComponent fHelpBrowserComponent;
    private FindPanel fFindPanel;

    public HelpBrowser(HtmlComponent<? extends HtmlActions> htmlComponent, HelpBrowserToolBar helpBrowserToolBar) {
        assert (SwingUtilities.isEventDispatchThread()) : "HelpBrowser must be created on the EDT.";
        this.fHelpBrowserComponent = new HelpBrowserComponent(htmlComponent, helpBrowserToolBar);
    }

    public Component getComponent() {
        return this.fHelpBrowserComponent.getPanel();
    }

    public void setCurrentLocation(String string) {
        if (string == null) {
            return;
        }
        this.fHelpBrowserComponent.setCurrentLocation(string);
    }

    private static void createAndShowHelpBrowser(String string, boolean bl) {
        JFrame jFrame = new JFrame(HelpBrowserUtils.getString("helpbrowser.title"));
        jFrame.setName("HelpBrowser");
        jFrame.getAccessibleContext().setAccessibleName("HelpBrowser");
        if (bl) {
            jFrame.setDefaultCloseOperation(3);
        } else {
            jFrame.setDefaultCloseOperation(2);
        }
        Image image = HelpBrowser.createFrameImage();
        if (image != null) {
            jFrame.setIconImage(image);
        }
        HtmlPanel<HtmlActions> htmlPanel = HelpBrowser.createHtmlComponent(string);
        HelpBrowserFindHandler helpBrowserFindHandler = new HelpBrowserFindHandler();
        BasicHtmlActions basicHtmlActions = HelpBrowser.createHelpBrowserActions(htmlPanel, helpBrowserFindHandler);
        htmlPanel.setActions((HtmlActions)basicHtmlActions);
        HelpBrowserToolBar helpBrowserToolBar = new HelpBrowserToolBar((HtmlActions)basicHtmlActions, new HelpBrowserComponentHelper());
        HelpBrowser helpBrowser = new HelpBrowser((HtmlComponent<? extends HtmlActions>)htmlPanel, helpBrowserToolBar);
        helpBrowserFindHandler.setHelpBrowser(helpBrowser);
        helpBrowser.setupKeyBindings();
        String string2 = HelpBrowserUtils.buildUrl(string);
        helpBrowser.setCurrentLocation(string2);
        jFrame.addWindowListener(new HelpBrowserWindowListener(helpBrowser));
        jFrame.setSize(1000, 800);
        jFrame.setLocation(20, 40);
        jFrame.getContentPane().add(helpBrowser.getComponent());
        jFrame.setVisible(true);
    }

    void addFindPanel(final FindInPageHandler findInPageHandler) {
        if (this.fFindPanel == null) {
            this.fFindPanel = new FindPanel(this.fHelpBrowserComponent.getHtmlComponent(), findInPageHandler);
            this.fHelpBrowserComponent.getPanel().add(this.fFindPanel.getComponent(), "South");
            this.fHelpBrowserComponent.getPanel().revalidate();
            this.fHelpBrowserComponent.getPanel().repaint();
            this.addHtmlPanelKeyBinding(KeyStroke.getKeyStroke(27, 0), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    findInPageHandler.closeFindInPage();
                }
            }, "helpbrowser.close_find");
        }
        this.fFindPanel.getComponent().requestFocusInWindow();
        this.fFindPanel.requestFocusInTextField();
    }

    void removeFindPanel() {
        this.fHelpBrowserComponent.getPanel().remove(this.fFindPanel.getComponent());
        this.fFindPanel = null;
        this.removeHtmlPanelKeyBinding(KeyStroke.getKeyStroke(27, 0));
        this.fHelpBrowserComponent.getPanel().revalidate();
        this.fHelpBrowserComponent.getPanel().repaint();
    }

    private void setupKeyBindings() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(70, 128);
        this.addHtmlPanelKeyBinding(keyStroke, StandardHtmlActionId.FIND);
    }

    private void addHtmlPanelKeyBinding(KeyStroke keyStroke, StandardHtmlActionId standardHtmlActionId) {
        String string = "helpbrowser.htmlAction." + standardHtmlActionId.toString();
        HtmlComponentActionWrapper htmlComponentActionWrapper = new HtmlComponentActionWrapper(standardHtmlActionId);
        this.addHtmlPanelKeyBinding(keyStroke, htmlComponentActionWrapper, string);
    }

    private void addHtmlPanelKeyBinding(KeyStroke keyStroke, Action action, Object object) {
        InputMap inputMap = this.fHelpBrowserComponent.getPanel().getInputMap(1);
        inputMap.put(keyStroke, object);
        this.fHelpBrowserComponent.getPanel().getActionMap().put(object, action);
    }

    private void removeHtmlPanelKeyBinding(KeyStroke keyStroke) {
        InputMap inputMap = this.fHelpBrowserComponent.getPanel().getInputMap(1);
        Object object = inputMap.get(keyStroke);
        inputMap.remove(keyStroke);
        this.fHelpBrowserComponent.getPanel().getActionMap().remove(object);
    }

    private static HtmlPanel<HtmlActions> createHtmlComponent(String string) {
        boolean bl;
        HtmlPanel htmlPanel = new HtmlPanel();
        File file = null;
        boolean bl2 = bl = string != null && !HelpBrowserUtils.isWebAddress(string);
        if (bl && !(file = new File(string)).isDirectory()) {
            file = file.getParentFile();
        }
        if (bl) {
            HelpBrowserSearchHelper helpBrowserSearchHelper = new HelpBrowserSearchHelper(file, new HelpBrowserLocaleHelper());
            htmlPanel.addPageChangedListener((PageChangedListener)new DocSearchPageChangedListener((HtmlComponent<? extends HtmlActions>)htmlPanel, helpBrowserSearchHelper, file.getName()));
            htmlPanel.addRequestHandler((RequestHandler)new DocSuggestionProtocolHandler((HtmlComponent<? extends HtmlActions>)htmlPanel, helpBrowserSearchHelper, string));
        }
        return htmlPanel;
    }

    private static BasicHtmlActions createHelpBrowserActions(HtmlComponent<HtmlActions> htmlComponent, FindInPageHandler findInPageHandler) {
        BasicHtmlActions basicHtmlActions = new BasicHtmlActions(htmlComponent, (BasicHtmlActions.BasicHtmlActionLabels)new HelpBrowserActionLabels());
        basicHtmlActions.setViewSourceHandler((BasicHtmlActions.ViewSourceHandler)new DefaultViewSourceHandler());
        basicHtmlActions.setFindInPageHandler(findInPageHandler);
        return basicHtmlActions;
    }

    private static Image createFrameImage() {
        Image image = null;
        String string = HelpBrowserUtils.getString("helpbrowser.toolbar.image.help.small");
        String string2 = HelpBrowserUtils.getString("helpbrowser.toolbar.image.membrane.small");
        URL uRL = HelpBrowserUtils.getImageURL(string);
        URL uRL2 = HelpBrowserUtils.getImageURL(string2);
        if (uRL2 != null && uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL2);
            ImageIcon imageIcon2 = new ImageIcon(uRL);
            image = HelpBrowserUtils.createBadgedImage(imageIcon2, imageIcon, 5, 6, 11, 11);
        }
        return image;
    }

    public static void main(String[] stringArray) {
        final String string = HelpBrowserUtils.getArgument(stringArray, "location");
        String string2 = HelpBrowserUtils.getArgument(stringArray, "standalone");
        if (string == null) {
            System.err.println("HelpBrowser must be invoked with the documentation location.");
            System.out.println("Usage: com.mathworks.help.helpui.HelpBrowser -location=<doc location> [-standalone=<true|false>]");
            return;
        }
        final boolean bl = string2 != null && string2.equalsIgnoreCase("true");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpBrowser.createAndShowHelpBrowser(string, bl);
            }
        });
    }

    public void dispose() {
        this.fHelpBrowserComponent.dispose();
    }

    private static class HelpBrowserActionLabels
    implements BasicHtmlActions.BasicHtmlActionLabels {
        private HelpBrowserActionLabels() {
        }

        public String getLabel(StandardHtmlActionId standardHtmlActionId) {
            String string = HelpBrowserActionLabels.getResourceBundleKey(standardHtmlActionId);
            return string == null ? "" : HelpBrowserUtils.getString(string);
        }

        private static String getResourceBundleKey(StandardHtmlActionId standardHtmlActionId) {
            switch (standardHtmlActionId) {
                case GO_BACK: {
                    return "helpbrowser.toolbar.button.back.alttext";
                }
                case GO_FORWARD: {
                    return "helpbrowser.toolbar.button.forward.alttext";
                }
                case RELOAD: {
                    return "helpbrowser.toolbar.button.refresh.alttext";
                }
                case HOME: {
                    return "helpbrowser.toolbar.button.home.alttext";
                }
                case COPY: {
                    return "helpbrowser.toolbar.button.copy.alttext";
                }
                case PRINT: {
                    return "helpbrowser.toolbar.button.print.alttext";
                }
                case FIND: {
                    return "helpbrowser.toolbar.button.find.alttext";
                }
                case VIEW_SOURCE: {
                    return "helpbrowser.toolbar.button.pagesource.alttext";
                }
                case SAVE_AS: {
                    return "helpbrowser.toolbar.button.saveas.alttext";
                }
            }
            return null;
        }
    }

    private class HtmlComponentActionWrapper
    extends AbstractAction {
        private final StandardHtmlActionId iActionId;

        private HtmlComponentActionWrapper(StandardHtmlActionId standardHtmlActionId) {
            this.iActionId = standardHtmlActionId;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Action action = (Action)HelpBrowser.this.fHelpBrowserComponent.getHtmlComponent().getActions().getBasicActions().get(this.iActionId);
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }
}

