/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.export.pagesetup;

import com.mathworks.hg.peer.UnitPos;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.page.export.pagesetup.PageSetupDialog;
import com.mathworks.page.export.print.PagePrintSettings;
import com.mathworks.page.utils.VertFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PSTabSize
extends MJPanel
implements ChangeListener,
ActionListener,
PropertyChangeListener {
    private PagePrintSettings fPrintSettings;
    private MJRadioButton fRadBtnModeAuto;
    private MJRadioButton fRadBtnModeManual;
    private MJSpinner fFigLeft;
    private MJSpinner fFigTop;
    private MJSpinner fFigWidth;
    private MJSpinner fFigHeight;
    private MJComboBox fComboUnits;
    private MJButton fBtnCenter;
    private MJButton fBtnFillPage;
    private MJButton fBtnAspectRatio;
    private MJButton fBtnDefaultSize;

    public PSTabSize(PagePrintSettings pagePrintSettings) {
        this.fPrintSettings = pagePrintSettings;
        this.fPrintSettings.addPropertyChangeListener(this);
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        MJPanel mJPanel = new MJPanel();
        this.add((Component)mJPanel, "Center");
        mJPanel.setLayout((LayoutManager)new GridBagLayout());
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBorder((Border)new TitledBorder(PageSetupDialog.sResHandle.getString("groupbox.mode")));
        mJPanel.add((Component)mJPanel2, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(18, 6, 6, 6), 0, 0));
        mJPanel2.setLayout((LayoutManager)new MGridLayout(2, 1));
        this.fRadBtnModeAuto = new MJRadioButton(PageSetupDialog.sResHandle.getString("button.usescreensize"));
        this.fRadBtnModeManual = new MJRadioButton(PageSetupDialog.sResHandle.getString("button.usemanualsize"));
        mJPanel2.add((Component)this.fRadBtnModeAuto);
        mJPanel2.add((Component)this.fRadBtnModeManual);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fRadBtnModeAuto);
        buttonGroup.add((AbstractButton)this.fRadBtnModeManual);
        this.fRadBtnModeAuto.addActionListener((ActionListener)this);
        this.fRadBtnModeManual.addActionListener((ActionListener)this);
        MJPanel mJPanel3 = new MJPanel();
        mJPanel3.setLayout((LayoutManager)new BorderLayout());
        mJPanel3.setBorder((Border)new TitledBorder(PageSetupDialog.sResHandle.getString("groupbox.manualsize")));
        mJPanel.add((Component)mJPanel3, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 6, 6), 0, 0));
        MJPanel mJPanel4 = new MJPanel();
        mJPanel4.setLayout((LayoutManager)new GridBagLayout());
        MJPanel mJPanel5 = new MJPanel();
        mJPanel5.setLayout((LayoutManager)new VertFlowLayout());
        mJPanel3.add((Component)mJPanel4, (Object)"Center");
        mJPanel3.add((Component)mJPanel5, (Object)"East");
        MJLabel mJLabel = new MJLabel(PageSetupDialog.sResHandle.getString("spin.FigLeft"));
        MJLabel mJLabel2 = new MJLabel(PageSetupDialog.sResHandle.getString("spin.FigTop"));
        MJLabel mJLabel3 = new MJLabel(PageSetupDialog.sResHandle.getString("spin.FigWidth"));
        MJLabel mJLabel4 = new MJLabel(PageSetupDialog.sResHandle.getString("spin.FigHeight"));
        MJLabel mJLabel5 = new MJLabel(PageSetupDialog.sResHandle.getString("label.units"));
        this.fFigLeft = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 0.01));
        this.fFigTop = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 0.01));
        this.fFigWidth = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 0.01));
        this.fFigHeight = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 0.01));
        this.fFigLeft.setEditor((JComponent)new JSpinner.NumberEditor((JSpinner)this.fFigLeft, "###0.00"));
        this.fFigTop.setEditor((JComponent)new JSpinner.NumberEditor((JSpinner)this.fFigTop, "###0.00"));
        this.fFigWidth.setEditor((JComponent)new JSpinner.NumberEditor((JSpinner)this.fFigWidth, "###0.00"));
        this.fFigHeight.setEditor((JComponent)new JSpinner.NumberEditor((JSpinner)this.fFigHeight, "###0.00"));
        this.fComboUnits = new MJComboBox();
        for (int i = 0; i < UnitPos.UNITS.length - 3; ++i) {
            this.fComboUnits.addItem((Object)UnitPos.UNITS[i]);
        }
        this.fComboUnits.setSelectedItem((Object)UnitPos.unitsToString((int)0));
        this.fFigLeft.addChangeListener((ChangeListener)this);
        this.fFigTop.addChangeListener((ChangeListener)this);
        this.fFigWidth.addChangeListener((ChangeListener)this);
        this.fFigHeight.addChangeListener((ChangeListener)this);
        this.fComboUnits.addActionListener((ActionListener)this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mJPanel4.add((Component)mJLabel, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel4.add((Component)mJLabel2, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel4.add((Component)mJLabel3, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel4.add((Component)mJLabel4, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel4.add((Component)mJLabel5, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        mJPanel4.add((Component)this.fFigLeft, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel4.add((Component)this.fFigTop, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel4.add((Component)this.fFigWidth, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel4.add((Component)this.fFigHeight, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel4.add((Component)this.fComboUnits, (Object)gridBagConstraints);
        this.fBtnDefaultSize = new MJButton(PageSetupDialog.sResHandle.getString("button.fDefaultSize"));
        this.fBtnFillPage = new MJButton(PageSetupDialog.sResHandle.getString("button.fFillPage"));
        this.fBtnAspectRatio = new MJButton(PageSetupDialog.sResHandle.getString("button.fAspectRatio"));
        this.fBtnCenter = new MJButton(PageSetupDialog.sResHandle.getString("button.fCenter"));
        Dimension dimension = this.fBtnAspectRatio.getPreferredSize();
        dimension.width = 110;
        this.fBtnDefaultSize.setPreferredSize(dimension);
        this.fBtnFillPage.setPreferredSize(dimension);
        this.fBtnAspectRatio.setPreferredSize(dimension);
        this.fBtnCenter.setPreferredSize(dimension);
        this.fBtnDefaultSize.addActionListener((ActionListener)this);
        this.fBtnFillPage.addActionListener((ActionListener)this);
        this.fBtnAspectRatio.addActionListener((ActionListener)this);
        this.fBtnCenter.addActionListener((ActionListener)this);
        mJPanel5.add((Component)this.fBtnDefaultSize);
        mJPanel5.add((Component)this.fBtnFillPage);
        mJPanel5.add((Component)this.fBtnAspectRatio);
        mJPanel5.add((Component)this.fBtnCenter);
        MJPanel mJPanel6 = new MJPanel();
        mJPanel.add((Component)mJPanel6, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fRadBtnModeAuto.setName("RadBtn_ModeAuto");
        this.fRadBtnModeManual.setName("RadBtn_ModeManual");
        this.fFigLeft.setName("Spinner_FigLeft");
        this.fFigTop.setName("Spinner_FigTop");
        this.fFigWidth.setName("Spinner_FigWidth");
        this.fFigHeight.setName("SpinnerFigHeight");
        this.fComboUnits.setName("Combo_FigUnits");
        this.fBtnCenter.setName("Btn_FigPosCenter");
        this.fBtnFillPage.setName("Btn_FigPosFillPage");
        this.fBtnAspectRatio.setName("Btn_FigPosAspectRatio");
        this.fBtnDefaultSize.setName("Btn_FigPosDefault");
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object.equals(this.fFigLeft) || object.equals(this.fFigTop) || object.equals(this.fFigWidth) || object.equals(this.fFigHeight)) {
            this.onFigPositionChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.fComboUnits)) {
            this.onUnitsChanged();
        } else if (object.equals(this.fRadBtnModeAuto) || object.equals(this.fRadBtnModeManual)) {
            this.onFigPositionModeChanged();
        } else if (object.equals(this.fBtnCenter)) {
            this.onPositionCenter();
        } else if (object.equals(this.fBtnFillPage)) {
            this.onPositionFillPage();
        } else if (object.equals(this.fBtnAspectRatio)) {
            this.onPositionAspectRatio();
        } else if (object.equals(this.fBtnDefaultSize)) {
            this.onPositionDefault();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getSource() != this.fPrintSettings) {
            return;
        }
        if (string.equals("PaperPositionMode")) {
            this.setFigPositionMode(object.toString());
        } else if (string.equals("PaperPosition")) {
            this.setFigPosition((double[])object);
        } else if (string.equals("PaperUnits")) {
            this.setUnits((String)object);
        }
    }

    private double getDefaultMargin() {
        int n = UnitPos.unitsToInt((String)this.fPrintSettings.getUnits());
        double[] dArray = this.fPrintSettings.convertUnits(0.25, 0.0, 0, n);
        return dArray[0];
    }

    private void onPositionCenter() {
        double[] dArray = this.fPrintSettings.getPaperSize();
        double[] dArray2 = this.fPrintSettings.getFigPosition();
        dArray2[0] = 0.5 * (dArray[0] - dArray2[2]);
        dArray2[1] = 0.5 * (dArray[1] - dArray2[3]);
        this.fPrintSettings.setFigPosition(null, dArray2);
    }

    private void onPositionFillPage() {
        double[] dArray = this.fPrintSettings.getPaperSize();
        double d = this.getDefaultMargin();
        double[] dArray2 = new double[]{d, d, dArray[0] - 2.0 * d, dArray[1] - 2.0 * d};
        this.fPrintSettings.setFigPosition(null, dArray2);
    }

    private void onPositionAspectRatio() {
        double[] dArray;
        double d;
        double[] dArray2 = this.fPrintSettings.getFigPosition();
        double d2 = dArray2[2] / dArray2[3];
        if (d2 < (d = (dArray = this.fPrintSettings.getFigSize())[0] / dArray[1])) {
            dArray2[3] = dArray2[2] / d;
        } else {
            dArray2[2] = dArray2[3] * d;
        }
        this.fPrintSettings.setFigPosition(null, dArray2);
    }

    private void onPositionDefault() {
        int n = UnitPos.unitsToInt((String)this.fPrintSettings.getUnits());
        double[] dArray = this.fPrintSettings.convertUnits(0.25, 2.5, 8.0, 6.0, 0, n);
        this.fPrintSettings.setFigPosition(null, dArray);
    }

    private void onFigPositionModeChanged() {
        boolean bl = this.fRadBtnModeManual.isSelected();
        String string = bl ? "manual" : "auto";
        this.fPrintSettings.setFigPositionMode(this, string);
        this.setFigPositionMode(string);
    }

    private void onFigPositionChanged() {
        double[] dArray = new double[]{((Number)this.fFigLeft.getValue()).doubleValue(), ((Number)this.fFigTop.getValue()).doubleValue(), ((Number)this.fFigWidth.getValue()).doubleValue(), ((Number)this.fFigHeight.getValue()).doubleValue()};
        this.fPrintSettings.setFigPosition(this, dArray);
    }

    private void onUnitsChanged() {
        String string = (String)this.fComboUnits.getSelectedItem();
        this.fPrintSettings.setUnits(this, string);
    }

    private void setFigPositionMode(String string) {
        boolean bl = string.equals("manual");
        if (bl) {
            this.fRadBtnModeManual.setSelected(true);
            this.fFigTop.setEnabled(true);
            this.fFigLeft.setEnabled(true);
            this.fFigWidth.setEnabled(true);
            this.fFigHeight.setEnabled(true);
            this.fBtnCenter.setEnabled(true);
            this.fBtnFillPage.setEnabled(true);
            this.fBtnAspectRatio.setEnabled(true);
            this.fBtnDefaultSize.setEnabled(true);
            this.fComboUnits.setEnabled(true);
        } else {
            this.fRadBtnModeAuto.setSelected(true);
            this.fFigTop.setEnabled(false);
            this.fFigLeft.setEnabled(false);
            this.fFigWidth.setEnabled(false);
            this.fFigHeight.setEnabled(false);
            this.fBtnCenter.setEnabled(false);
            this.fBtnFillPage.setEnabled(false);
            this.fBtnAspectRatio.setEnabled(false);
            this.fBtnDefaultSize.setEnabled(false);
            this.fComboUnits.setEnabled(false);
        }
    }

    private void setFigPosition(double[] dArray) {
        this.fFigLeft.removeChangeListener((ChangeListener)this);
        this.fFigTop.removeChangeListener((ChangeListener)this);
        this.fFigWidth.removeChangeListener((ChangeListener)this);
        this.fFigHeight.removeChangeListener((ChangeListener)this);
        this.fFigLeft.setValue((Object)new Double(dArray[0]));
        this.fFigTop.setValue((Object)new Double(dArray[1]));
        this.fFigWidth.setValue((Object)new Double(dArray[2]));
        this.fFigHeight.setValue((Object)new Double(dArray[3]));
        this.fFigLeft.addChangeListener((ChangeListener)this);
        this.fFigTop.addChangeListener((ChangeListener)this);
        this.fFigWidth.addChangeListener((ChangeListener)this);
        this.fFigHeight.addChangeListener((ChangeListener)this);
    }

    private void setUnits(String string) {
        this.fComboUnits.removeActionListener((ActionListener)this);
        this.fComboUnits.setSelectedItem((Object)string);
        this.fComboUnits.addActionListener((ActionListener)this);
    }
}

