/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchField;
import com.mathworks.search.SearchSuggestions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

public class SuggestionProvider {
    private static final Pattern FIND_LAST_WORD_PATTERN = Pattern.compile("^(.*\\s+)(\\w+)\\s*$");
    private IndexReader fReader;
    private SearchField fField;

    public SuggestionProvider(IndexReader reader, SearchField field) {
        this.fReader = reader;
        this.fField = field;
    }

    private IndexReader getIndexReader() {
        return this.fReader;
    }

    public SearchSuggestions getSuggestions(String searchText, int maxSuggestions) {
        try {
            Matcher m = FIND_LAST_WORD_PATTERN.matcher(searchText);
            if (m.find()) {
                String fullWords = m.group(1);
                String partialWord = m.group(2);
                return this.getSuggestionsForLastWord(fullWords, partialWord, maxSuggestions);
            }
            return this.getSuggestionsForSingleWord(searchText, maxSuggestions);
        }
        catch (IOException e) {
            return SearchSuggestions.emptySuggestions();
        }
    }

    private SearchSuggestions getSuggestionsForSingleWord(String prefix, int maxSuggestions) throws IOException {
        SuggestionsMap<Term> suggestedTerms = this.getSuggestedTerms(prefix, maxSuggestions);
        ArrayList<String> suggestedStrings = new ArrayList<String>();
        for (Term term : ((SuggestionsMap)suggestedTerms).values()) {
            suggestedStrings.add(term.text());
        }
        return new SearchSuggestions(suggestedStrings, ((SuggestionsMap)suggestedTerms).getTotalFound());
    }

    private SearchSuggestions getSuggestionsForLastWord(String fullWords, String partialWord, int maxSuggestions) throws IOException {
        String[] splitFullWords = fullWords.split("\\s+");
        HashSet<String> fullWordSet = new HashSet<String>();
        fullWordSet.addAll(Arrays.asList(splitFullWords));
        SortedMap<Integer, TermDocs> fullWordTermDocsMap = this.getFullWordTermDocs(splitFullWords);
        if (fullWordTermDocsMap.firstKey() == 0) {
            return SearchSuggestions.emptySuggestions();
        }
        Collection<TermDocs> fullWordTermDocs = fullWordTermDocsMap.values();
        SuggestionsMap<Term> partialWordTerms = this.getSuggestedTerms(partialWord, Integer.MAX_VALUE);
        SuggestionsMap suggestions = new SuggestionsMap(maxSuggestions);
        for (Term t : ((SuggestionsMap)partialWordTerms).values()) {
            if (fullWordSet.contains(t.text())) continue;
            int intersection = SuggestionProvider.intersectTermDocs(fullWordTermDocs, this.getIndexReader().termDocs(t));
            if (intersection > 0) {
                String suggestionString = fullWords + t.text();
                suggestions.add(new Suggestion(suggestionString, intersection), suggestionString);
            }
            fullWordTermDocs = this.getFullWordTermDocs(splitFullWords).values();
        }
        return new SearchSuggestions(suggestions.values(), suggestions.getTotalFound());
    }

    private SortedMap<Integer, TermDocs> getFullWordTermDocs(String[] fullWords) throws IOException {
        TreeMap<Integer, TermDocs> fullWordTermDocs = new TreeMap<Integer, TermDocs>();
        IndexReader reader = this.getIndexReader();
        for (String fullWord : fullWords) {
            Term fullWordTerm = new Term(this.fField.getFieldName(), fullWord);
            fullWordTermDocs.put(reader.docFreq(fullWordTerm), reader.termDocs(fullWordTerm));
        }
        return fullWordTermDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SuggestionsMap<Term> getSuggestedTerms(String prefix, int maxSuggestions) throws IOException {
        prefix = prefix.trim();
        SuggestionsMap<Term> suggestionTerms = new SuggestionsMap<Term>(maxSuggestions);
        TermEnum terms = this.getIndexReader().terms(new Term(this.fField.getFieldName(), prefix));
        try {
            Term currentTerm = terms.term();
            while (SuggestionProvider.shouldAcceptTerm(currentTerm, prefix)) {
                Suggestion suggestion = new Suggestion(currentTerm.text(), this.getIndexReader().docFreq(currentTerm));
                ((SuggestionsMap)suggestionTerms).add(suggestion, currentTerm);
                currentTerm = SuggestionProvider.getNextTerm(terms);
            }
        }
        finally {
            terms.close();
        }
        return suggestionTerms;
    }

    private static boolean shouldAcceptTerm(Term term, String prefix) {
        return term != null && term.text().startsWith(prefix);
    }

    private static Term getNextTerm(TermEnum terms) throws IOException {
        return terms.next() ? terms.term() : null;
    }

    private static int intersectTermDocs(Collection<TermDocs> fullWordDocs, TermDocs partialWordDocs) throws IOException {
        ArrayList<TermDocs> td = new ArrayList<TermDocs>(fullWordDocs);
        td.add(partialWordDocs);
        int intersect = 0;
        int nextDoc = SuggestionProvider.getNextCommonTermDoc(td, 0);
        while (nextDoc > -1) {
            ++intersect;
            nextDoc = SuggestionProvider.getNextCommonTermDoc(td, nextDoc + 1);
        }
        return intersect;
    }

    private static int getNextCommonTermDoc(Iterable<TermDocs> td, int startFrom) throws IOException {
        int candidateDoc = SuggestionProvider.getInitialMatchCandidate(td, startFrom);
        boolean allMatch = false;
        while (!allMatch) {
            allMatch = true;
            Iterator<TermDocs> iterator = td.iterator();
            while (iterator.hasNext() && allMatch) {
                TermDocs t = iterator.next();
                int doc = t.doc();
                if (doc >= candidateDoc) continue;
                if (t.skipTo(candidateDoc)) {
                    int newCandidate = t.doc();
                    allMatch = newCandidate == candidateDoc;
                    candidateDoc = newCandidate;
                    continue;
                }
                return -1;
            }
        }
        return candidateDoc;
    }

    private static int getInitialMatchCandidate(Iterable<TermDocs> td, int startFrom) throws IOException {
        int candidateDoc = startFrom;
        for (TermDocs t : td) {
            t.next();
            int potentialCandidate = t.doc();
            if (potentialCandidate <= candidateDoc) continue;
            candidateDoc = potentialCandidate;
        }
        return candidateDoc;
    }

    private static class Suggestion
    implements Comparable<Suggestion> {
        private final String iText;
        private final int iNumDocs;

        private Suggestion(String text, int numDocs) {
            this.iText = text;
            this.iNumDocs = numDocs;
        }

        private String getText() {
            return this.iText;
        }

        private int getNumDocs() {
            return this.iNumDocs;
        }

        @Override
        public int compareTo(Suggestion o) {
            if (this.getNumDocs() == o.getNumDocs()) {
                return this.getText().compareTo(o.getText());
            }
            return this.getNumDocs() < o.getNumDocs() ? 1 : -1;
        }

        public boolean equals(Object obj) {
            return obj instanceof Suggestion && this.iText.equals(((Suggestion)obj).iText);
        }

        public int hashCode() {
            return this.iText.hashCode();
        }
    }

    private static class SuggestionsMap<E> {
        private final int iMaxSize;
        private final SortedMap<Suggestion, E> iMap = new TreeMap<Suggestion, E>();
        private int iTotalFound = 0;

        private SuggestionsMap(int maxSize) {
            this.iMaxSize = maxSize;
        }

        private void add(Suggestion s, E value) {
            ++this.iTotalFound;
            this.iMap.put(s, value);
            if (this.iMap.size() > this.iMaxSize) {
                this.iMap.remove(this.iMap.lastKey());
            }
        }

        private Collection<E> values() {
            return this.iMap.values();
        }

        private int getTotalFound() {
            return this.iTotalFound;
        }
    }
}

