/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.collection.impl;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.util.CheckNullArgument;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class ComparisonCollectionImpl
implements ComparisonCollection {
    private final String mName;
    private final String mType;
    private final SortedSet<ComparisonSource> mContents;

    protected ComparisonCollectionImpl(String string, String string2, Comparator<ComparisonSource> comparator) {
        CheckNullArgument.check(string, "aName");
        CheckNullArgument.check(string2, "aType");
        CheckNullArgument.check(comparator, "aComparator");
        this.mName = string;
        this.mType = string2;
        this.mContents = new TreeSet<ComparisonSource>(comparator);
    }

    @Override
    public Collection<ComparisonSource> getComparisonSources() {
        return this.mContents;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getType() {
        return this.mType;
    }

    protected void addSource(ComparisonSource comparisonSource) {
        this.mContents.add(comparisonSource);
    }
}

