/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.comparisons.compare.impl.CompareInMatlabGenerateHTML;
import com.mathworks.comparisons.decorator.htmlreport.HTMLReportDecorator;
import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.data.CEventDataRefresh;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.parameter.ComparisonParameterAllowMerging;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJOptionPane;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class MatDataComparison
extends CompareInMatlabGenerateHTML {
    private static final String COMPARE_FUNCTION = "comparisons_private";
    private static final String COMPARE_FUNCTION_NAME_INPUT = "matdiff";
    private static final int NUM_OUT_ARGS = 1;
    private static final boolean MERGE_ENABLED_DEFAULT = true;
    private static ConcurrentHashMap<String, MatDataComparison> sComparisons = null;

    public MatDataComparison() {
        super(COMPARE_FUNCTION, 1);
        MatDataComparison.addComparison(this);
    }

    @Override
    protected void setInputArgs(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, ComparisonParameterSet comparisonParameterSet) {
        this.mInputArgs = new Object[5];
        this.mInputArgs[0] = COMPARE_FUNCTION_NAME_INPUT;
        this.mInputArgs[1] = comparisonSource;
        this.mInputArgs[2] = comparisonSource2;
        this.mInputArgs[3] = this.getReportID();
        this.mInputArgs[4] = Boolean.toString(MatDataComparison.isMergingEnabled(comparisonParameterSet));
    }

    @Override
    protected HTMLReportDecorator createDefaultDecorator() {
        return new HTMLReportDecorator(this.getMainEventListener());
    }

    public String getReportID() {
        return Integer.toString(this.hashCode());
    }

    @Override
    public void dispose() {
        MatDataComparison.removeComparison(this);
        super.dispose();
    }

    public void doRefresh() {
        this.getMainEventListener().processEvent(new ComparisonEvent(this, CEventDataRefresh.getInstance()));
    }

    public void doErrorDialog(String string) {
        MJOptionPane.showMessageDialog((Component)((Object)((HTMLReportDecorator)this.getDecorator()).getHTMLRenderer()), (Object)string, (String)ResourceManager.getString("listcomparison.errorTitle"), (int)0);
    }

    private static boolean isMergingEnabled(ComparisonParameterSet comparisonParameterSet) {
        if (comparisonParameterSet.hasParameter(ComparisonParameterAllowMerging.getInstance())) {
            return (Boolean)comparisonParameterSet.getValue(ComparisonParameterAllowMerging.getInstance());
        }
        return true;
    }

    private static synchronized void addComparison(MatDataComparison matDataComparison) {
        if (sComparisons == null) {
            sComparisons = new ConcurrentHashMap();
        }
        sComparisons.put(matDataComparison.getReportID(), matDataComparison);
    }

    private static synchronized void removeComparison(MatDataComparison matDataComparison) {
        sComparisons.remove(matDataComparison.getReportID());
    }

    public static synchronized MatDataComparison getComparison(String string) {
        return sComparisons == null ? null : sComparisons.get(string);
    }

    public static synchronized Collection<String> getComparisonCodes() {
        return sComparisons == null ? new ArrayList() : sComparisons.keySet();
    }
}

