/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.variable;

import com.mathworks.comparisons.decorator.variable.StructTableModel;
import com.mathworks.comparisons.decorator.variable.StructTableObject;
import com.mathworks.comparisons.decorator.variable.SummaryLabel;
import com.mathworks.comparisons.decorator.variable.VariableComparisonDecorator;
import com.mathworks.comparisons.decorator.variable.VariableDifferences;
import com.mathworks.comparisons.util.ComparisonColors;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mlwidgets.workspace.util.WorkspaceIcon;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class StructDifferencesPanel
extends MJPanel {
    private static final String PANEL_NAME = "StructDiffPanel";
    private static final String TABLE_NAME = "StructDiffTable";
    private static final String COLOR_PROPERTY = "StructTableCellColor";
    private RecordlistTable fTable;
    private VariableComparisonDecorator fParent;

    public StructDifferencesPanel(VariableComparisonDecorator variableComparisonDecorator, VariableDifferences variableDifferences) {
        super((LayoutManager)new BorderLayout());
        this.setName(PANEL_NAME);
        this.fParent = variableComparisonDecorator;
        StructTableModel structTableModel = new StructTableModel();
        structTableModel.setNames(SummaryLabel.getDesc1(variableDifferences), SummaryLabel.getDesc2(variableDifferences));
        final VariableDifferences.FieldEntry[] fieldEntryArray = variableDifferences.getFields();
        structTableModel.setData(fieldEntryArray);
        this.fTable = new RecordlistTable((IRecordlistModel)structTableModel);
        this.fTable.setName(TABLE_NAME);
        this.fTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.fTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.fTable.getColumnModel().getColumn(2).setPreferredWidth(250);
        this.add((Component)new MJScrollPane((Component)this.fTable), "Center");
        this.fTable.setDefaultRenderer(String.class, (TableCellRenderer)new FieldRenderer());
        this.fTable.setToolTipText(ResourceManager.getString("variable.doubleclickrow"));
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = StructDifferencesPanel.this.fTable.getSelectedRow()) >= 0) {
                    String string = fieldEntryArray[n].getName();
                    if (fieldEntryArray[n].getSummary1() != null && fieldEntryArray[n].getSummary2() != null) {
                        StructDifferencesPanel.this.fParent.doFieldSubsref(string);
                    }
                }
            }
        });
        this.fTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.fTable.getSelectionModel().setSelectionMode(0);
        this.fTable.setFullCellSelection(true);
    }

    public void doLayout() {
        super.doLayout();
        if (this.fTable.getRowHeight() < 17) {
            this.fTable.setRowHeight(17);
        }
        this.fTable.sizeColumnsToFit(-1);
    }

    private static class FieldRenderer
    extends DefaultTableCellRenderer {
        private FieldRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Serializable serializable;
            Object object2;
            super.getTableCellRendererComponent(jTable, object, bl, bl, n, n2);
            TableModel tableModel = jTable.getModel();
            StructTableObject structTableObject = (StructTableObject)tableModel.getValueAt(n, n2);
            this.setText(structTableObject.getDescription());
            if (n2 == 0) {
                this.setIcon(null);
            } else {
                object2 = structTableObject.getClazz();
                serializable = object2.isEmpty() ? null : WorkspaceIcon.getIcon((String)object2);
                this.setIcon((Icon)((Object)serializable));
            }
            if (!bl) {
                object2 = structTableObject.getDiffType();
                serializable = object2 == StructTableObject.DiffType.ADDED ? ComparisonColors.getAddedColor() : (object2 == StructTableObject.DiffType.MODIFIED ? ComparisonColors.getModifiedColor() : (object2 == StructTableObject.DiffType.REMOVED ? ComparisonColors.getRemovedColor() : jTable.getBackground()));
                this.setBackground((Color)serializable);
                this.putClientProperty(StructDifferencesPanel.COLOR_PROPERTY, serializable);
            }
            return this;
        }
    }
}

