/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.impl;

import com.mathworks.comparisons.selection.BrowseAction;
import com.mathworks.comparisons.selection.DropPolicy;
import com.mathworks.comparisons.selection.InvalidConversionException;
import com.mathworks.comparisons.selection.ListModelPolicy;
import com.mathworks.comparisons.selection.SelectionDataType;
import com.mathworks.comparisons.selection.SelectionPolicies;
import com.mathworks.comparisons.selection.StringConversionPolicy;
import com.mathworks.comparisons.selection.ValidSourceSelectionPolicy;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.util.CheckNullArgument;
import com.mathworks.comparisons.util.ResourceManager;
import java.lang.reflect.Constructor;
import javax.swing.Icon;

public abstract class SelectionPoliciesImpl<T>
implements SelectionPolicies<T> {
    private final SelectionDataType<T> mSelectionDataType;
    private final String mDescription;
    private final Icon mIcon;
    private final Class<? extends ListModelPolicy<T>> mListModelPolicyClass;
    private final Class<? extends StringConversionPolicy<T>> mStringConversionPolicyClass;
    private final Class<? extends ValidSourceSelectionPolicy<T>> mValidSourceSelectionPolicyClass;
    private final Class<? extends DropPolicy<T>> mDropPolicyClass;
    private final Class<? extends BrowseAction<T>> mBrowseActionClass;

    protected SelectionPoliciesImpl(SelectionDataType<T> selectionDataType, String string, Icon icon, Class<? extends ListModelPolicy<T>> clazz, Class<? extends StringConversionPolicy<T>> clazz2, Class<? extends ValidSourceSelectionPolicy<T>> clazz3, Class<? extends DropPolicy<T>> clazz4, Class<? extends BrowseAction<T>> clazz5) {
        CheckNullArgument.check(selectionDataType, "aDataType");
        CheckNullArgument.check(string, "aDescription");
        CheckNullArgument.check(icon, "aIcon");
        CheckNullArgument.check(clazz, "aListPolicyClass");
        CheckNullArgument.check(clazz2, "aStringPolicyClass");
        CheckNullArgument.check(clazz3, "aValidSourcePolicyClass");
        this.mSelectionDataType = selectionDataType;
        this.mDescription = string;
        this.mIcon = icon;
        this.mListModelPolicyClass = clazz;
        this.mStringConversionPolicyClass = clazz2;
        this.mValidSourceSelectionPolicyClass = clazz3;
        this.mDropPolicyClass = clazz4;
        this.mBrowseActionClass = clazz5;
    }

    @Override
    public SelectionDataType<T> getSelectionDataType() {
        return this.mSelectionDataType;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public Icon getIcon() {
        return this.mIcon;
    }

    @Override
    public ListModelPolicy<T> createListModelPolicy() {
        return (ListModelPolicy)this.create(this.mListModelPolicyClass);
    }

    @Override
    public StringConversionPolicy<T> createStringConversionPolicy() {
        return (StringConversionPolicy)this.create(this.mStringConversionPolicyClass);
    }

    @Override
    public ValidSourceSelectionPolicy<T> createValidSourceSelectionPolicy() {
        return (ValidSourceSelectionPolicy)this.create(this.mValidSourceSelectionPolicyClass);
    }

    @Override
    public DropPolicy<T> createDropPolicy() {
        if (this.mDropPolicyClass != null) {
            return (DropPolicy)this.create(this.mDropPolicyClass);
        }
        return null;
    }

    @Override
    public BrowseAction<T> createBrowseAction() {
        if (this.mBrowseActionClass != null) {
            return (BrowseAction)((Object)this.create(this.mBrowseActionClass));
        }
        return null;
    }

    @Override
    public ComparisonSource convertToComparisonSource(T t) throws InvalidConversionException {
        if (t != null) {
            Class<?> clazz;
            Class<?> clazz2 = this.mSelectionDataType.getApplicableType();
            if (clazz2.isAssignableFrom(clazz = t.getClass())) {
                ValidSourceSelectionPolicy<T> validSourceSelectionPolicy = this.createValidSourceSelectionPolicy();
                return validSourceSelectionPolicy.convertToComparisonSource(t);
            }
            throw new InvalidConversionException(t, ResourceManager.format("exception.incompatibleclasses", clazz.getName(), clazz2.getName()));
        }
        return null;
    }

    @Override
    public ComparisonSource convertStringToComparisonSource(String string) throws InvalidConversionException {
        return this.convertToComparisonSource(this.createStringConversionPolicy().convert(string));
    }

    Object create(Class<?> clazz) {
        Object obj;
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            obj = constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return obj;
    }
}

