/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.AccessPosition;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ExternalCSSBoxAssist;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.LineBox;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.UnsupportedOperationException;
import ice.util.alg.Bidi;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.text.BreakIterator;
import java.util.StringTokenizer;

class TextBox
extends CSSBox {
    private Font renderingFont = null;
    private static final boolean checkGlyph;
    private DTextNode textNode;
    private int[] breakOffsetInPixels;
    private int spaceWidthInPixels = 0;
    private int textDescent;
    private int textAscent;
    private int lineHeight;
    private static ExternalCSSBoxAssist runtimeExtension;
    private static boolean fontsReportCorrectly;
    private boolean isJavaBidi = JavaVersion.isV12orGreater();
    private BreakIterator _sentenceInstance;
    private int _sentenceCount;
    private int _wordCount;

    TextBox(DTextNode dTextNode, CSSLayout cSSLayout) {
        super(cSSLayout);
        this.textNode = dTextNode;
    }

    void dispose() {
        super.dispose();
        this.breakOffsetInPixels = null;
    }

    boolean isEmpty() {
        return this.textNode.isEmpty();
    }

    DNode getDomNode() {
        return this.textNode;
    }

    int calcBreaks() {
        if (this.spaceWidthInPixels == 0) {
            this.initBreaks();
        }
        return this.numBreaks;
    }

    int getBreaks(int[] nArray, int n) {
        System.arraycopy(this.breakOffsetInPixels, 0, nArray, n, this.numBreaks);
        return this.numBreaks;
    }

    long getChunkDescentAscent(int n, int n2, LineBox lineBox) {
        if (!this.textNode.isPre && this.isEmpty()) {
            return 0L;
        }
        return TextBox.wrapDescentAscent(this.textDescent, this.textAscent, this.lineHeight);
    }

    private final void initBreaks() {
        DElement dElement = this.parentBox.element;
        if (dElement != null && dElement.tagId == 10 && this.parentBox.css.directionFlag == 1) {
            this.textNode.reverseText();
        }
        this.css = this.parentBox.css;
        this.renderingFont = this.css.getFont();
        FontMetrics fontMetrics = this.css.getFontMetrics();
        if (checkGlyph) {
            this.renderingFont = this.css.getTestedFont(this.textNode.text, 0, this.textNode.text.length);
            fontMetrics = this.css.getFontMetrics();
        }
        this.numBreaks = (this.css.misc & 4) != 0 ? 0 : this.textNode.numBreaks;
        this.breakOffsetInPixels = new int[this.numBreaks];
        char[] cArray = this.textNode.text;
        int[] nArray = this.textNode.breakOffset;
        this.textDescent = fontMetrics.getDescent();
        this.textAscent = fontMetrics.getAscent();
        long l = TextBox.calculateCompressedFontSize(this.textAscent, this.textDescent, this.css);
        this.textDescent = TextBox.unwrapDescent(l);
        this.textAscent = TextBox.unwrapAscent(l);
        this.lineHeight = TextBox.calculateLineHeight(this.css);
        this.spaceWidthInPixels = fontMetrics.charWidth(' ');
        int n = 0;
        if (this.textNode.isPre) {
            int[] nArray2 = this.css.getFontCharWidths();
            int n2 = 0;
            for (int i = 0; i < this.numBreaks; ++i) {
                int n3 = nArray[i];
                if (n3 < 0) {
                    n3 = -n3;
                }
                while (n2 < n3) {
                    n = cArray[n2] >= nArray2.length ? (n += fontMetrics.charWidth(cArray[n2])) : (cArray[n2] == '\n' ? ++n : (n += nArray2[cArray[n2]]));
                    ++n2;
                }
                this.breakOffsetInPixels[i] = nArray[i] < 0 ? -n : n;
            }
            while (n2 < cArray.length) {
                n = cArray[n2] >= nArray2.length ? (n += fontMetrics.charWidth(cArray[n2])) : (n += nArray2[cArray[n2]]);
                ++n2;
            }
            this.totalWidth = n;
        } else {
            for (int i = 0; i < this.numBreaks; ++i) {
                int n4 = nArray[i];
                if (n4 < 0) {
                    n4 = -n4;
                }
                n = fontMetrics.charsWidth(cArray, 0, n4);
                this.breakOffsetInPixels[i] = nArray[i] < 0 ? -n : n;
            }
            this.totalWidth = fontMetrics.charsWidth(cArray, 0, cArray.length);
        }
    }

    static final long calculateCompressedFontSize(int n, int n2, CSSAttribs cSSAttribs) {
        if (!fontsReportCorrectly) {
            float f = (float)n / (float)n2;
            int n3 = Math.round((float)cSSAttribs.font_size / (1.0f + f));
            int n4 = cSSAttribs.font_size - n3;
            return TextBox.wrapDescentAscent(++n3, ++n4, 0);
        }
        return TextBox.wrapDescentAscent(n2, n, 0);
    }

    static int calculateLineHeight(CSSAttribs cSSAttribs) {
        int n = 0;
        n = (cSSAttribs.percentage_flag & 0x200000) > 0 ? cSSAttribs.line_height * cSSAttribs.font_size / 100 : cSSAttribs.line_height;
        return n;
    }

    public int getCount(int n, Point point) {
        switch (n) {
            case 1: {
                this._startingCharOffset = point.x;
                point.x += this.textNode.text.length;
                return this.textNode.text.length;
            }
            case 2: {
                this._startingWordOffset = point.x;
                if (this._wordCount == 0) {
                    String string = new String(this.textNode.text);
                    if (string.trim().length() == 0) {
                        return 0;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                    while (stringTokenizer.hasMoreElements()) {
                        stringTokenizer.nextElement();
                        ++this._wordCount;
                    }
                }
                point.x += this._wordCount;
                return this._wordCount;
            }
            case 3: {
                this._startingSentenceOffset = point.x;
                if (this._sentenceInstance == null) {
                    String string = new String(this.textNode.text);
                    this._sentenceInstance = BreakIterator.getSentenceInstance();
                    this._sentenceInstance.setText(string);
                    this._sentenceInstance.first();
                    while (this._sentenceInstance.next() != -1) {
                        ++this._sentenceCount;
                    }
                    if (this._wordCount == 0) {
                        this._sentenceCount = 0;
                    }
                }
                point.x += this._sentenceCount;
                return this._sentenceCount;
            }
        }
        throw new UnsupportedOperationException("Unsupported Access type: " + n);
    }

    CSSBox findChildByIndex_r(int n, int n2, Point point) {
        switch (n) {
            case 1: {
                this._startingCharOffset = point.x;
                point.x += this.textNode.text.length;
                if (this._startingCharOffset > n2 || n2 >= point.x) break;
                return this;
            }
            case 2: {
                this._startingWordOffset = point.x;
                point.x += this._wordCount;
                if (this._startingWordOffset > n2 || n2 >= point.x) break;
                return this;
            }
            case 3: {
                this._startingSentenceOffset = point.x;
                point.x += this._sentenceCount;
                if (this._startingSentenceOffset > n2 || n2 >= point.x) break;
                return this;
            }
        }
        return null;
    }

    String getText(int n, int n2, AccessPosition accessPosition) {
        int n3 = 0;
        int n4 = this.textNode.text.length;
        switch (n) {
            case 1: {
                accessPosition._characterInDoc = n2;
                int n5 = n2 - this._startingCharOffset;
                accessPosition._wordInDoc = this.getWordFromCharIdx(n5) + this._startingWordOffset;
                accessPosition._sentenceInDoc = this._startingSentenceOffset + this.getSentenceFromCharIdx(n5);
                return String.valueOf(this.textNode.text[n5]);
            }
            case 2: {
                int n6 = n2 - this._startingWordOffset;
                if (n2 > this._startingWordOffset) {
                    n3 = this.textNode.breakOffset[n6 - 1];
                }
                if (n6 < this.textNode.breakOffset.length) {
                    n4 = this.textNode.breakOffset[n6];
                }
                accessPosition._wordInDoc = n2;
                accessPosition._characterInDoc = n3 + this._startingCharOffset;
                accessPosition._sentenceInDoc = this._startingSentenceOffset + this.getSentenceFromCharIdx(n3);
                return String.valueOf(this.textNode.text, n3, n4 - n3);
            }
            case 3: {
                if (this._sentenceInstance == null) {
                    String string = new String(this.textNode.text);
                    this._sentenceInstance = BreakIterator.getSentenceInstance();
                    this._sentenceInstance.setText(string);
                }
                int n7 = n2 - this._startingSentenceOffset;
                this._sentenceInstance.first();
                n3 = this._sentenceInstance.next(n7);
                this._sentenceInstance.first();
                n4 = this._sentenceInstance.next(n7 + 1);
                accessPosition._characterInDoc = n3 + this._startingCharOffset;
                accessPosition._sentenceInDoc = n2;
                accessPosition._wordInDoc = this.getWordFromCharIdx(n3) + this._startingWordOffset;
                return String.valueOf(this.textNode.text, n3, n4 - n3);
            }
        }
        throw new UnsupportedOperationException("Unsupported Access type: " + n);
    }

    int getStartingCharacterOffset() {
        return this._startingCharOffset;
    }

    public int getCharIndexOfWordRelative(int n) {
        if (n == 0) {
            return 0;
        }
        if (n < this._wordCount) {
            return this.textNode.breakOffset[n - 1];
        }
        return -1;
    }

    public int getCharIndexOfWordAbsolute(int n) {
        return this.getCharIndexOfWordRelative(n - this._startingWordOffset);
    }

    int getWordFromCharIdx(int n) {
        if (this.numBreaks == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.numBreaks; ++i) {
            if (i > 0) {
                n2 = this.textNode.breakOffset[i - 1];
            }
            n3 = this.textNode.breakOffset[i];
            if (n < n2 || n >= n3) continue;
            return i;
        }
        if (n >= this.textNode.breakOffset[this.numBreaks - 1] && n < this.textNode.text.length) {
            return this._wordCount - 1;
        }
        Debug.trace((String)("Char index out of range searching for word? " + n));
        return 0;
    }

    int getSentenceFromCharIdx(int n) {
        if (this._sentenceInstance == null) {
            Point point = new Point();
            this.getCount(3, point);
        }
        if (this._sentenceCount == 1) {
            return 0;
        }
        int n2 = 0;
        int n3 = this.textNode.text.length;
        for (int i = 0; i < this._sentenceCount; ++i) {
            this._sentenceInstance.first();
            n2 = this._sentenceInstance.next(i);
            n3 = i < this._sentenceCount - 1 ? this._sentenceInstance.next(i + 1) : this.textNode.text.length;
            if (n < n2 || n >= n3) continue;
            return i;
        }
        Debug.trace((String)("Char index out of range searching for sentence? " + n));
        return 0;
    }

    void paintChunk(Graphics graphics, int n, int n2, LineBox lineBox, int n3) {
        int n4;
        char c;
        int n5;
        int n6;
        int n7;
        this.css = this.parentBox.css;
        int n8 = this.textAscent + this.textDescent;
        if (!this.isEmpty() && this.parentBox.getType() != 1) {
            n7 = n;
            n6 = n2;
            n5 = this.css.padding_top + this.css.padding_bottom;
            if (n == 0) {
                n6 -= (n7 -= this.css.padding_left);
            }
            if (n + n2 == this.totalWidth) {
                n6 += this.css.padding_right;
            }
            this.paintBackground(graphics, graphics.getClipBounds(), n7, 0 - this.css.padding_top, n6, n8 + n5, 0);
            if (n == 0) {
                n7 -= this.css.border_left_width;
                n6 += this.css.border_left_width;
            }
            if (n + n2 == this.totalWidth) {
                n6 += this.css.border_right_width;
            }
            if (!((InlineBox)this.parentBox).hasMoreThanOneChild()) {
                this.paintBorders(graphics, graphics.getClipBounds(), n7, -this.css.padding_top - this.css.border_top_width, n6, n8 + n5 + this.css.border_top_width + this.css.border_bottom_width, this.css.border_top_width > 0 && this.css.border_top_style != 8, this.css.border_bottom_width > 0 && this.css.border_bottom_style != 8, this.css.border_left_width > 0 && this.css.border_left_style != 8 && n == 0, this.css.border_right_width > 0 && this.css.border_right_style != 8 && n + n2 == this.totalWidth);
            }
        }
        if ((this.css.misc & 1) == 0) {
            return;
        }
        n7 = 0;
        n6 = this.textNode.text.length;
        n5 = 0;
        int n9 = 0;
        if (n != 0) {
            for (n5 = 0; n5 < this.numBreaks; ++n5) {
                n9 = this.breakOffsetInPixels[n5];
                if ((n9 >= 0 || n9 != -n) && (n9 < 0 || n9 != n)) continue;
                n7 = this.textNode.breakOffset[n5];
                if (n7 >= 0) break;
                n7 = -n7;
                break;
            }
        }
        if (n5 == this.numBreaks) {
            n5 = 0;
        }
        if (n + n2 != this.totalWidth) {
            while (n5 < this.numBreaks) {
                n9 = this.breakOffsetInPixels[n5];
                if (n9 < 0 && n9 == -(n + n2) || n9 >= 0 && n9 == n + n2) {
                    n6 = this.textNode.breakOffset[n5];
                    if (n6 < 0) {
                        n6 = -n6;
                    }
                    if ((c = this.textNode.text[n6 - 1]) == ' ' || c == '\n') {
                        --n6;
                    }
                    break;
                }
                ++n5;
            }
        } else if (this.numBreaks > 0 && this.breakOffsetInPixels[this.numBreaks - 1] == -this.totalWidth) {
            --n6;
        }
        if (n7 >= n6) {
            return;
        }
        if (graphics.getFont() != this.renderingFont) {
            graphics.setFont(this.renderingFont);
        }
        c = '\u0000';
        if (this.cssLayout.somethingSelected && this.cssLayout.selection.isInside(this.textNode)) {
            if (this.cssLayout.selection.startContainer == this.textNode || this.cssLayout.selection.endContainer == this.textNode) {
                c = '\u0001';
                graphics.setColor(this.css.color);
            } else {
                graphics.setColor(SystemColor.textHighlight);
                graphics.fillRect(n, 0, n2, n8);
                graphics.setColor(SystemColor.textHighlightText);
            }
        } else {
            graphics.setColor(this.css.color);
        }
        char[] cArray = this.textNode.text;
        if (this.isJavaBidi || this.textNode.doc.charsetId == 0) {
            graphics.drawChars(cArray, n7, n6 - n7, n, this.textAscent);
        } else {
            this.renderWithLocalBidi(graphics, n7, n6, n, this.textAscent);
        }
        if ((this.css.text_decoration & 1) != 0) {
            n4 = n8 - 2;
            graphics.drawLine(n, n4, n + n2, n4);
        }
        if ((this.css.text_decoration & 4) != 0) {
            n4 = 1;
            graphics.drawLine(n, n4, n + n2, n4);
        }
        if ((this.css.text_decoration & 2) != 0) {
            n4 = Math.round((float)n8 * 0.56f);
            graphics.drawLine(n, n4, n + n2, n4);
        }
        if ((this.css.misc & 2) != 0) {
            this.cssLayout.outlinePainter.addRectangle(this, n, 0, n2, n8);
        }
        if (c != '\u0000') {
            int n10;
            n4 = n7;
            int n11 = n6;
            int n12 = n;
            int n13 = n10 = n + n2;
            int n14 = n12;
            FontMetrics fontMetrics = this.css.getFontMetrics();
            if (this.cssLayout.selection.startContainer == this.textNode) {
                n4 = this.cssLayout.selection.startOffset;
                if (n4 >= n6) {
                    return;
                }
                if (n4 > n7) {
                    n14 = this.pxLocationFromChrIndex(this.textNode.text, this.textNode.breakOffset, this.breakOffsetInPixels, n4, fontMetrics, this.textNode.isPre);
                } else {
                    n4 = n7;
                }
            }
            if (this.cssLayout.selection.endContainer == this.textNode) {
                n11 = this.cssLayout.selection.endOffset;
                if (n11 <= n7) {
                    return;
                }
                if (n11 < n6) {
                    n13 = this.pxLocationFromChrIndex(this.textNode.text, this.textNode.breakOffset, this.breakOffsetInPixels, n11, fontMetrics, this.textNode.isPre);
                } else {
                    n11 = n6;
                }
            }
            if (n4 < n11) {
                int n15 = n13 - n14;
                Graphics graphics2 = graphics.create();
                graphics2.setClip(n14, 0, n15, n8);
                graphics2.setColor(SystemColor.textHighlight);
                graphics2.fillRect(n14, 0, n15, n8);
                graphics2.setColor(SystemColor.textHighlightText);
                if (this.isJavaBidi || this.textNode.doc.charsetId == 0) {
                    graphics2.drawChars(cArray, n7, n6 - n7, n, this.textAscent);
                } else {
                    this.renderWithLocalBidi(graphics2, n7, n6, n, this.textAscent);
                }
                graphics2.dispose();
            }
        }
        if (runtimeExtension != null) {
            runtimeExtension.addonTextProcessing(graphics, this, n2, n8, n);
        }
    }

    public int getRenderedLineNumber(int n) {
        int n2 = 0;
        if (this.textAscent + this.textDescent > 0) {
            n2 = n / (this.textAscent + this.textDescent);
        }
        return n2;
    }

    int getCharacterIndex(int n, boolean bl) {
        int n2 = this.findStartingBreakIdxFromArray(this.breakOffsetInPixels, n);
        int n3 = this.textNode.isPre ? this.fastChrIndexFromPx(this.textNode.text, this.textNode.breakOffset, this.breakOffsetInPixels, n2, n) : this.accurateChrIndexFromPx(this.textNode.text, this.textNode.breakOffset, this.breakOffsetInPixels, n2, n);
        if (bl) {
            return n3;
        }
        return n3 + 1;
    }

    int findStartingBreakIdxFromArray(int[] nArray, int n) {
        if (nArray.length == 0) {
            return 0;
        }
        int n2 = Math.abs(nArray[nArray.length - 1]);
        if (n < 0 || n > n2) {
            return 0;
        }
        if (n < nArray[0]) {
            return 0;
        }
        int n3 = 0;
        while (Math.abs(nArray[n3]) < n) {
            ++n3;
        }
        return n3;
    }

    int fastChrIndexFromPx(char[] cArray, int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (nArray.length != 0) {
            if (n == 0) {
                n5 = 0;
            } else {
                if (nArray2[n - 1] == n2) {
                    return nArray[n - 1];
                }
                n5 = Math.abs(nArray[n - 1]);
                n3 = nArray2[n - 1];
            }
        }
        int[] nArray3 = this.css.getFontCharWidths();
        FontMetrics fontMetrics = this.css.getFontMetrics();
        if (n3 < 0) {
            n3 = -n3;
        }
        n4 = n3;
        while (n5 <= cArray.length - 1) {
            n3 = cArray[n5] >= nArray3.length ? (n3 += fontMetrics.charWidth(cArray[n5])) : (cArray[n5] == '\n' ? ++n3 : (n3 += nArray3[cArray[n5]]));
            if (n4 <= n2 && n3 >= n2) {
                return n5;
            }
            n4 = n3;
            ++n5;
        }
        return 0;
    }

    private int accurateChrIndexFromPx(char[] cArray, int[] nArray, int[] nArray2, int n, int n2) {
        FontMetrics fontMetrics = this.css.getFontMetrics();
        int n3 = 0;
        int n4 = 0;
        float f = 0.0f;
        int n5 = 0;
        if (n > 0) {
            n3 = Math.abs(nArray2[n - 1]);
            n4 = Math.abs(nArray2[n]);
            f = (n4 - n3) / n4;
            n5 = Math.round((float)nArray[n - 1] * (1.0f + f));
        }
        int n6 = 1;
        int n7 = n5;
        n4 = n3 = fontMetrics.charsWidth(cArray, 0, n7);
        if (n3 > n2) {
            n6 = -1;
        }
        while ((n3 = fontMetrics.charsWidth(cArray, 0, n7 += n6)) > n2 || n4 < n2) {
            if (n3 >= n2 && n4 <= n2) {
                return n7 - 1;
            }
            n4 = n3;
        }
        return n7;
    }

    int pxLocationFromChrIndex(char[] cArray, int[] nArray, int[] nArray2, int n, FontMetrics fontMetrics, boolean bl) {
        if (n < 0) {
            return 0;
        }
        if (n > cArray.length) {
            if (nArray2.length > 0) {
                return nArray2[nArray2.length - 1];
            }
            return fontMetrics.charsWidth(cArray, 0, cArray.length - 1);
        }
        int n2 = this.findStartingBreakIdxFromArray(nArray, n);
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0 && nArray2.length > n2) {
            n4 = Math.abs(nArray[n2 - 1]);
            n3 = Math.abs(nArray2[n2 - 1]);
        }
        if (bl) {
            int[] nArray3 = this.css.getFontCharWidths();
            while (n4 < n) {
                n3 = cArray[n4] >= nArray3.length ? (n3 += fontMetrics.charWidth(cArray[n4])) : (cArray[n4] == '\n' ? ++n3 : (n3 += nArray3[cArray[n4]]));
                ++n4;
            }
            return n3;
        }
        return fontMetrics.charsWidth(cArray, 0, n);
    }

    void findBoundingBox(Rectangle rectangle) {
        BlockBox blockBox = null;
        int n = this.ox;
        CSSBox cSSBox = this.parentBox;
        while (cSSBox.parentBox != null) {
            if (cSSBox.getType() == 0) {
                n += cSSBox.css.margin_left + cSSBox.css.border_left_width + cSSBox.css.padding_left;
                n += cSSBox.ox;
            } else {
                n += cSSBox.css.text_indent;
            }
            if (cSSBox.getType() == 1) {
                blockBox = (BlockBox)cSSBox;
                blockBox.recordBoundingBoxForInline(rectangle, n, this.totalWidth);
                if (rectangle.width == 0) {
                    rectangle.height = 0;
                    rectangle.width = 0;
                    rectangle.y = 0;
                    rectangle.x = 0;
                    blockBox.findBoundingBox(rectangle);
                    break;
                }
                if (cSSBox.css.position == 126 || cSSBox.css.position == 6) break;
                Point point = new Point();
                cSSBox = cSSBox.parentBox;
                if (cSSBox != null) {
                    cSSBox.findAbsolutePosition(point);
                }
                rectangle.x += point.x;
                rectangle.y += point.y;
                break;
            }
            cSSBox = cSSBox.parentBox;
        }
    }

    private void renderWithLocalBidi(Graphics graphics, int n, int n2, int n3, int n4) {
        Bidi bidi = Bidi.createBidi((int)this.textNode.doc.charsetId, (char[])this.textNode.text, (int)n, (int)n2);
        char[] cArray = bidi.getChars();
        if (cArray != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = n3;
            for (int i = 0; i < cArray.length; ++i) {
                graphics.drawChars(cArray, i, 1, n5, n4);
                n5 += fontMetrics.charWidth(cArray[i]);
            }
        }
    }

    char[] getText() {
        return this.textNode.text;
    }

    static {
        boolean bl = Defs.sysPropertyBoolean((String)"ice.pilots.html4.testallglyphs", (boolean)true);
        if (!JavaVersion.isV12orGreater()) {
            bl = false;
        }
        checkGlyph = bl;
        String string = Defs.property((String)"ice.pilots.html4.GraphicExtension");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                runtimeExtension = (ExternalCSSBoxAssist)clazz.newInstance();
            }
            catch (Exception exception) {
                Debug.p((String)("Exception occured loading graphic extension class:" + exception));
            }
        }
        fontsReportCorrectly = Defs.sysPropertyBoolean((String)"ice.pilots.html4.fontsReportCorrectly");
    }
}

