/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormInputPasswordText
extends JPasswordField
implements EventListener,
ObjectPainter,
DocumentListener,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private Border _originalBorder = this.getBorder();
    int maxLength = 10000;
    private String startValue;

    FormInputPasswordText(DocView docView, DElement dElement) {
        this.docView = docView;
        this.element = (DInputElement)dElement;
        int n = dElement.getAttributeAsInt("size");
        if (n < 0) {
            n = 20;
        }
        this.setColumns(n + 1);
        this.setOpaque(true);
        this.checkAttributes();
        this.getDocument().addDocumentListener(this);
    }

    private void checkAttributes() {
        String string;
        this.setEditable(!this.element.getReadOnly());
        this.setEnabled(!this.element.getDisabled());
        int n = this.element.getMaxLength();
        if (n > 0) {
            this.maxLength = n;
        }
        if ((string = this.element.getValue()) != null && !string.equals(this.getText())) {
            int n2 = this.getCaretPosition();
            this.setText(string);
            try {
                this.setCaretPosition(n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing()) {
            super.paintComponent(graphics);
        } else {
            graphics.translate(1, 1);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getSize().width - 2, this.getSize().height - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawRect(0, 0, this.getSize().width - 2, this.getSize().height - 2);
            graphics.setColor(Color.black);
            String string = "*******";
            FontMetrics fontMetrics = graphics.getFontMetrics();
            fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.getDescent();
            graphics.drawString(string, 2, this.getBounds().height / 2 + n);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    void updateFont() {
        if (this.box != null) {
            String string = this.getText();
            CSSAttribs cSSAttribs = this.box.getCSSAttribs();
            Font font = cSSAttribs.getTestedFont(string);
            if (!font.equals(this.getFont())) {
                this.setFont(font);
            }
        }
    }

    private void textValueChanged() {
        this.docView.getPilot().getStorm().runOnEventThreadLater(new Runnable(){

            public void run() {
                String string = FormInputPasswordText.this.getText();
                FormInputPasswordText.this.updateFont();
                if (string.length() > FormInputPasswordText.this.maxLength) {
                    int n = FormInputPasswordText.this.getCaretPosition();
                    if (n > FormInputPasswordText.this.maxLength) {
                        n = FormInputPasswordText.this.maxLength;
                    }
                    string = string.substring(0, FormInputPasswordText.this.maxLength);
                    FormInputPasswordText.this.setText(string);
                    FormInputPasswordText.this.setCaretPosition(n);
                }
            }
        }, 0L);
        this.element.setValue(this.getText());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        KeyEvent keyEvent;
        int n;
        FormInputPasswordText formInputPasswordText = null;
        int n2 = aWTEvent.getID();
        if (!(n2 != 401 && n2 != 402 || (n = (keyEvent = (KeyEvent)aWTEvent).getKeyCode()) != 38 && n != 40 && n != 39 && n != 37)) {
            formInputPasswordText = this;
        }
        if (this.docView.onComponentEvent(this, aWTEvent, formInputPasswordText)) {
            super.processEvent(aWTEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = focusEvent.getID();
        if (n == 1004) {
            this.processFocusGained(focusEvent);
        } else if (n == 1005) {
            this.processFocusLost(focusEvent);
        }
        super.processFocusEvent(focusEvent);
    }

    private void processFocusGained(FocusEvent focusEvent) {
        if (this.startValue == null) {
            this.startValue = this.getText();
        }
    }

    private void processFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        String string = this.getText();
        if (!string.equals(this.startValue)) {
            this.element.dispatchChange();
        }
        this.startValue = null;
    }

    public void handleEvent(Event event) {
        DOMEvent dOMEvent = (DOMEvent)event;
        super.processEvent((AWTEvent)dOMEvent.getSystemEvent());
        dOMEvent.setDefaultDone();
    }

    protected int getColumnWidth() {
        String string = Defs.sysProperty((String)"ice.pilots.html4.colWidthChar", (String)"o");
        if (string == null || string.length() != 1) {
            return super.getColumnWidth();
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.charWidth(string.charAt(0));
    }

    public void setBorderVisible(boolean bl) {
        if (!bl) {
            this._originalBorder = this.getBorder();
            this.setBorder(null);
        } else {
            this.setBorder(this._originalBorder);
        }
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
        this.updateFont();
    }
}

